/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import jdk.internal.instrumentation.ClassInstrumentation;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.Logger;
import jdk.management.resource.internal.inst.InitInstrumentation;

public final class StaticInstrumentation {
    public static void main(String[] stringArray) throws Exception {
        StaticInstrumentation.instrumentClassesForResourceManagement(new File(stringArray[0]), new File(stringArray[1]));
    }

    public static void instrumentClassesForResourceManagement(File file, File file2) throws Exception {
        Object object;
        if (!file.isDirectory()) {
            throw new Exception(file + " is not a directory");
        }
        if (!file2.isDirectory()) {
            throw new Exception(file + " is not a directory");
        }
        InstrumentationLogger instrumentationLogger = new InstrumentationLogger();
        System.out.println();
        System.out.println("Reading from " + file);
        System.out.println("Output to " + file2);
        Set<File> set = StaticInstrumentation.findAllJarFiles(file);
        HashMap hashMap = new HashMap();
        System.out.println();
        System.out.println("Searching for classes");
        int n = 0;
        for (Class<?> serializable : InitInstrumentation.hooks) {
            String string = StaticInstrumentation.findTargetClassName(serializable);
            System.out.println(n + ":");
            ++n;
            System.out.println("   Instrumentation: " + serializable.getName());
            System.out.println("   Target         : " + (String)string);
            boolean clazz = false;
            for (File file3 : set) {
                object = StaticInstrumentation.getJarEntry(string, file3);
                if (object == null) continue;
                System.out.println("   Found in jar  : " + file3);
                if (((JarEntry)object).getCodeSigners() != null) {
                    throw new Exception("The target class '" + (String)string + "' was found in a signed jar: " + file3);
                }
                StaticInstrumentation.addNewTask(hashMap, file3, serializable);
                clazz = true;
                break;
            }
            if (clazz) continue;
            throw new Exception("The target class '" + (String)string + " was not found in any jar");
        }
        System.out.println();
        System.out.println("Instrumenting");
        for (File file3 : hashMap.keySet()) {
            File file4 = new File(file2, file3.getName());
            Files.copy(file3.toPath(), file4.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("   Jar     : " + file3);
            System.out.println("   Jar copy: " + file4);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (Class clazz : (List)hashMap.get(file3)) {
                String string = StaticInstrumentation.findTargetClassName(clazz);
                System.out.println("      Class: " + (String)string);
                byte[] byArray = StaticInstrumentation.findSourceBytesFor(string, file4);
                object = new ClassInstrumentation(clazz, string, byArray, instrumentationLogger).getNewBytes();
                File file5 = StaticInstrumentation.createOutputFile(file2, string);
                StaticInstrumentation.writeOutputClass(file5, (byte[])object);
                arrayList.add(file5);
            }
            System.out.println("   Updating jar");
            StaticInstrumentation.updateJar(file2, file4, arrayList);
            System.out.println();
        }
    }

    private static void updateJar(File file, File file2, List<File> list) throws InterruptedException, IOException {
        String string = System.getProperty("java.home") + File.separator + "bin" + File.separator + "jar";
        ProcessBuilder processBuilder = new ProcessBuilder(string, "uvf", file2.getAbsolutePath());
        for (File file3 : list) {
            String string2 = file.toPath().relativize(file3.toPath()).toString();
            processBuilder.command().add(string2);
        }
        processBuilder.directory(file);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        System.out.println("Executing: " + processBuilder.command().stream().collect(Collectors.joining(" ")));
        Process process = processBuilder.start();
        process.waitFor();
    }

    private static void addNewTask(HashMap<File, List<Class<?>>> hashMap, File file, Class<?> clazz) {
        List<Class<?>> list = hashMap.get(file);
        if (list == null) {
            list = new ArrayList();
            hashMap.put(file, list);
        }
        list.add(clazz);
    }

    private static Set<File> findAllJarFiles(File file) throws IOException {
        File file2;
        HashSet<File> hashSet = new HashSet<File>();
        LinkedBlockingDeque<File> linkedBlockingDeque = new LinkedBlockingDeque<File>();
        linkedBlockingDeque.add(file);
        while ((file2 = (File)linkedBlockingDeque.poll()) != null) {
            for (File file3 : file2.listFiles()) {
                if (file3.isDirectory()) {
                    linkedBlockingDeque.add(file3);
                    continue;
                }
                if (!file3.getName().endsWith(".jar")) continue;
                hashSet.add(file3);
            }
        }
        return hashSet;
    }

    private static File createOutputFile(File file, String string) {
        File file2 = new File(file, string.replace(".", File.separator) + ".class");
        file2.getParentFile().mkdirs();
        return file2;
    }

    private static void writeOutputClass(File file, byte[] byArray) throws FileNotFoundException, IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
        }
    }

    private static String findTargetClassName(Class<?> clazz) {
        return clazz.getAnnotation(InstrumentationTarget.class).value();
    }

    private static JarEntry getJarEntry(String string, File file) throws Exception {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry;
            String string2 = string.replace(".", "/") + ".class";
            JarEntry jarEntry2 = jarEntry = jarFile.getJarEntry(string2);
            return jarEntry2;
        }
    }

    private static byte[] findSourceBytesFor(String string, File file) throws Exception {
        try (JarFile jarFile = new JarFile(file);){
            byte[] byArray;
            String string2 = string.replace(".", "/") + ".class";
            ZipEntry zipEntry = jarFile.getEntry(string2);
            if (zipEntry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = byArray = StaticInstrumentation.readBytes(jarFile.getInputStream(zipEntry));
            return byArray3;
        }
    }

    private static byte[] readBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static class InstrumentationLogger
    implements Logger {
        InstrumentationLogger() {
        }

        @Override
        public void error(String string) {
            System.err.println("StaticInstrumentation error: " + string);
        }

        @Override
        public void warn(String string) {
            System.err.println("StaticInstrumentation warning: " + string);
        }

        @Override
        public void info(String string) {
            System.err.println("StaticInstrumentation info: " + string);
        }

        @Override
        public void debug(String string) {
        }

        @Override
        public void trace(String string) {
        }

        @Override
        public void error(String string, Throwable throwable) {
            System.err.println("StaticInstrumentation error: " + string + ": " + throwable);
        }
    }
}

