/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.nestedDichotomies;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class ND
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6355893369855683820L;
    protected NDTree m_ndtree = null;
    protected Hashtable m_classifiers = null;
    protected boolean m_hashtablegiven = false;

    public ND() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lin Dong and Eibe Frank and Stefan Kramer");
        result.setValue(TechnicalInformation.Field.TITLE, "Ensembles of Balanced Nested Dichotomies for Multi-class Problems");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "PKDD");
        result.setValue(TechnicalInformation.Field.YEAR, "2005");
        result.setValue(TechnicalInformation.Field.PAGES, "84-95");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Stefan Kramer");
        additional.setValue(TechnicalInformation.Field.TITLE, "Ensembles of nested dichotomies for multi-class problems");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Twenty-first International Conference on Machine Learning");
        additional.setValue(TechnicalInformation.Field.YEAR, "2004");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return result;
    }

    public void setHashtable(Hashtable table) {
        this.m_hashtablegiven = true;
        this.m_classifiers = table;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        Random random = data.getRandomNumberGenerator(this.m_Seed);
        if (!this.m_hashtablegiven) {
            this.m_classifiers = new Hashtable();
        }
        int[] indices = new int[data.numClasses()];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        for (i = indices.length - 1; i > 0; --i) {
            int help = indices[i];
            int index = random.nextInt(i + 1);
            indices[i] = indices[index];
            indices[index] = help;
        }
        this.m_ndtree = new NDTree();
        this.m_ndtree.insertClassIndexAtNode(indices[0]);
        for (i = 1; i < indices.length; ++i) {
            int nodeIndex = random.nextInt(2 * i - 1);
            NDTree node = this.m_ndtree.locateNode(nodeIndex, new int[1]);
            node.insertClassIndex(indices[i]);
        }
        this.m_ndtree.unifyTree();
        this.buildClassifierForNode(this.m_ndtree, data);
    }

    public void buildClassifierForNode(NDTree node, Instances data) throws Exception {
        if (node.m_left != null) {
            RemoveWithValues rwv;
            MakeIndicator filter = new MakeIndicator();
            filter.setAttributeIndex("" + (data.classIndex() + 1));
            filter.setValueIndices(node.m_right.getString());
            filter.setNumeric(false);
            filter.setInputFormat(data);
            FilteredClassifier classifier = new FilteredClassifier();
            if (data.numInstances() > 0) {
                classifier.setClassifier(Classifier.makeCopies(this.m_Classifier, 1)[0]);
            } else {
                classifier.setClassifier(new ZeroR());
            }
            classifier.setFilter(filter);
            if (!this.m_classifiers.containsKey(node.m_left.getString() + "|" + node.m_right.getString())) {
                classifier.buildClassifier(data);
                this.m_classifiers.put(node.m_left.getString() + "|" + node.m_right.getString(), classifier);
            } else {
                classifier = (FilteredClassifier)this.m_classifiers.get(node.m_left.getString() + "|" + node.m_right.getString());
            }
            if (node.m_left.m_left != null) {
                rwv = new RemoveWithValues();
                rwv.setInvertSelection(true);
                rwv.setNominalIndices(node.m_left.getString());
                rwv.setAttributeIndex("" + (data.classIndex() + 1));
                rwv.setInputFormat(data);
                Instances firstSubset = Filter.useFilter(data, rwv);
                this.buildClassifierForNode(node.m_left, firstSubset);
            }
            if (node.m_right.m_left != null) {
                rwv = new RemoveWithValues();
                rwv.setInvertSelection(true);
                rwv.setNominalIndices(node.m_right.getString());
                rwv.setAttributeIndex("" + (data.classIndex() + 1));
                rwv.setInputFormat(data);
                Instances secondSubset = Filter.useFilter(data, rwv);
                this.buildClassifierForNode(node.m_right, secondSubset);
            }
        }
    }

    public double[] distributionForInstance(Instance inst) throws Exception {
        return this.distributionForInstance(inst, this.m_ndtree);
    }

    protected double[] distributionForInstance(Instance inst, NDTree node) throws Exception {
        double[] newDist = new double[inst.numClasses()];
        if (node.m_left == null) {
            newDist[node.getIndices()[0]] = 1.0;
            return newDist;
        }
        Classifier classifier = (Classifier)this.m_classifiers.get(node.m_left.getString() + "|" + node.m_right.getString());
        double[] leftDist = this.distributionForInstance(inst, node.m_left);
        double[] rightDist = this.distributionForInstance(inst, node.m_right);
        double[] dist = classifier.distributionForInstance(inst);
        for (int i = 0; i < inst.numClasses(); ++i) {
            newDist[i] = node.m_right.contains(i) ? dist[1] * rightDist[i] : dist[0] * leftDist[i];
        }
        return newDist;
    }

    public String toString() {
        if (this.m_classifiers == null) {
            return "ND: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("ND\n\n");
        this.m_ndtree.toString(text, new int[1], 0);
        return text.toString();
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building a random tree structure.\n\nFor more info, check\n\n" + this.getTechnicalInformation().toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }

    public static void main(String[] argv) {
        ND.runClassifier(new ND(), argv);
    }

    protected class NDTree
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 4284655952754474880L;
        protected FastVector m_indices = new FastVector(1);
        protected NDTree m_parent = null;
        protected NDTree m_left = null;
        protected NDTree m_right = null;

        protected NDTree() {
            this.m_indices.addElement(new Integer(Integer.MAX_VALUE));
        }

        protected NDTree locateNode(int nodeIndex, int[] currentIndex) {
            if (nodeIndex == currentIndex[0]) {
                return this;
            }
            if (this.m_left == null) {
                return null;
            }
            currentIndex[0] = currentIndex[0] + 1;
            NDTree leftresult = this.m_left.locateNode(nodeIndex, currentIndex);
            if (leftresult != null) {
                return leftresult;
            }
            currentIndex[0] = currentIndex[0] + 1;
            return this.m_right.locateNode(nodeIndex, currentIndex);
        }

        protected void insertClassIndex(int classIndex) {
            NDTree right = new NDTree();
            if (this.m_left != null) {
                this.m_right.m_parent = right;
                this.m_left.m_parent = right;
                right.m_right = this.m_right;
                right.m_left = this.m_left;
            }
            this.m_right = right;
            this.m_right.m_indices = (FastVector)this.m_indices.copy();
            this.m_right.m_parent = this;
            this.m_left = new NDTree();
            this.m_left.insertClassIndexAtNode(classIndex);
            this.m_left.m_parent = this;
            this.propagateClassIndex(classIndex);
        }

        protected void propagateClassIndex(int classIndex) {
            this.insertClassIndexAtNode(classIndex);
            if (this.m_parent != null) {
                this.m_parent.propagateClassIndex(classIndex);
            }
        }

        protected void insertClassIndexAtNode(int classIndex) {
            int i = 0;
            while (classIndex > (Integer)this.m_indices.elementAt(i)) {
                ++i;
            }
            this.m_indices.insertElementAt(new Integer(classIndex), i);
        }

        protected int[] getIndices() {
            int[] ints = new int[this.m_indices.size() - 1];
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                ints[i] = (Integer)this.m_indices.elementAt(i);
            }
            return ints;
        }

        protected boolean contains(int index) {
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                if (index != (Integer)this.m_indices.elementAt(i)) continue;
                return true;
            }
            return false;
        }

        protected String getString() {
            StringBuffer string = new StringBuffer();
            for (int i = 0; i < this.m_indices.size() - 1; ++i) {
                if (i > 0) {
                    string.append(',');
                }
                string.append((Integer)this.m_indices.elementAt(i) + 1);
            }
            return string.toString();
        }

        protected void unifyTree() {
            if (this.m_left != null) {
                if ((Integer)this.m_left.m_indices.elementAt(0) > (Integer)this.m_right.m_indices.elementAt(0)) {
                    NDTree temp = this.m_left;
                    this.m_left = this.m_right;
                    this.m_right = temp;
                }
                this.m_left.unifyTree();
                this.m_right.unifyTree();
            }
        }

        protected void toString(StringBuffer text, int[] id, int level) {
            for (int i = 0; i < level; ++i) {
                text.append("   | ");
            }
            text.append(id[0] + ": " + this.getString() + "\n");
            if (this.m_left != null) {
                id[0] = id[0] + 1;
                this.m_left.toString(text, id, level + 1);
                id[0] = id[0] + 1;
                this.m_right.toString(text, id, level + 1);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.9 $");
        }
    }
}

