/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.entities;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SpotsData {
    private List<String> spots;
    private List<String> sampleNames;
    private List<String> sampleLabels;
    private double[][] data;
    private List<Condition> conditions;

    public SpotsData(List<String> spots, List<String> sampleNames, List<String> sampleLabels, double[][] data) {
        this.spots = spots;
        this.sampleNames = sampleNames;
        this.sampleLabels = sampleLabels;
        this.data = data;
    }

    public List<String> getSpots() {
        return this.spots;
    }

    public List<String> getSampleLabels() {
        return this.sampleLabels;
    }

    public List<String> getSampleNames() {
        return this.sampleNames;
    }

    public double[][] getData() {
        return this.data;
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            HashMap labelSamples = new HashMap();
            for (int column = 0; column < this.getSampleNames().size(); ++column) {
                HashMap<String, Double> sampleSpotsValues = new HashMap<String, Double>();
                for (int row = 0; row < this.getSpots().size(); ++row) {
                    double value = this.getData()[row][column];
                    if (Double.isNaN(value)) continue;
                    sampleSpotsValues.put(this.getSpots().get(row), value);
                }
                labelSamples.putIfAbsent(this.getSampleLabels().get(column), new LinkedList());
                ((List)labelSamples.get(this.getSampleLabels().get(column))).add(new Sample(this.getSampleNames().get(column), sampleSpotsValues));
            }
            this.conditions = new LinkedList<Condition>();
            for (String condition : labelSamples.keySet()) {
                this.conditions.add(new Condition(condition, (List)labelSamples.get(condition)));
            }
        }
        return this.conditions;
    }
}

