/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import es.uvigo.ei.pipespecification.storage.ArgsRenamerPipeDefinition;
import es.uvigo.ei.pipespecification.storage.InvalidAnnotationsFormatException;
import es.uvigo.ei.pipespecification.storage.PipeDefinition;
import es.uvigo.ei.pipespecification.storage.PipeDefinitionLoader;
import es.uvigo.ei.pipespecification.storage.PipeLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class IncludeDefinitionLoader
extends PipeDefinitionLoader {
    IncludeDefinitionLoader() {
    }

    @Override
    String getElementName() {
        return "include";
    }

    @Override
    PipeDefinition loadFromElement(Element element, File file, Map<String, Class<?>> argumentsSpecificationContext) throws IncompatibleConstraintsException, InvalidAnnotationsFormatException, ClassNotFoundException, SAXException, IOException {
        String fileToInclude = element.getAttribute("file");
        if (fileToInclude == null) {
            throw new RuntimeException("The include element must have the file attribute");
        }
        File xmlFile = new File(file.getParentFile(), fileToInclude);
        if (!xmlFile.isFile()) {
            throw new RuntimeException("The file specified in the include element was not found");
        }
        PipeDefinition importedDefinition = PipeLoader.load(xmlFile);
        NodeList args = element.getElementsByTagNameNS("*", "arg");
        HashMap<String, String> renamer = new HashMap<String, String>();
        for (int i = 0; i < args.getLength(); ++i) {
            String oldName = ((Element)args.item(i)).getAttribute("name");
            if (oldName == null) {
                throw new RuntimeException("There must exist the attribute id in the arg element");
            }
            String newName = ((Element)args.item(i)).getAttribute("newName");
            if (newName == null) {
                throw new IllegalArgumentException("There must exist the attribute newName in the arg element inside the include element");
            }
            if (!argumentsSpecificationContext.containsKey(oldName)) {
                throw new IllegalArgumentException("The id attribute must point to an already defined argument");
            }
            renamer.put(oldName, newName);
        }
        ArgsRenamerPipeDefinition pipeRenamed = new ArgsRenamerPipeDefinition(renamer, importedDefinition);
        pipeRenamed.checkArguments(argumentsSpecificationContext);
        return pipeRenamed;
    }
}

