/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.ResultTreatment;
import es.uvigo.ei.aibench.core.operation.execution.EndpointsFactory;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.IncomingEndPoint;
import es.uvigo.ei.aibench.core.operation.execution.OutcomeTransformer;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import es.uvigo.ei.aibench.core.operation.execution.SimpleIncomingEndPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class StandardExecutionSession<T>
implements ExecutionSession {
    private final List<IncomingEndPoint> incoming;
    private final List<SimpleIncomingEndPoint> all = new ArrayList<SimpleIncomingEndPoint>();
    private final Map<Integer, OutcomeTransformer> output = new HashMap<Integer, OutcomeTransformer>();
    private boolean finished = false;
    private final ResultsCollector collector;
    private final ExecutorService executor;
    private Thread dispatcher;

    StandardExecutionSession(List<EndpointsFactory<T>> factories, T target, ResultsCollector collector, ExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("excecutor can't be null");
        }
        this.executor = executor;
        ArrayList<SimpleIncomingEndPoint> incomingList = new ArrayList<SimpleIncomingEndPoint>();
        int pos = 0;
        for (int i = 0; i < factories.size(); ++i) {
            EndpointsFactory<T> factory = factories.get(i);
            SimpleIncomingEndPoint endPoint = factory.instantiate(target);
            this.all.add(endPoint);
            if (factory.getDirection() != Direction.OUTPUT) {
                incomingList.add(endPoint);
            }
            if (factory.getDirection() == Direction.INPUT) continue;
            this.output.put(i, new OutcomeTransformer(factory.getTreatment() == ResultTreatment.DATASOURCE, collector, pos++));
        }
        this.incoming = Collections.unmodifiableList(new ArrayList(incomingList));
        if (collector == null) {
            throw new NullPointerException("collector can't be null");
        }
        this.collector = collector;
        this.dispatcher = new Thread(new Dispatcher());
        this.dispatcher.start();
    }

    public List<IncomingEndPoint> getIncomingEndpoints() {
        if (this.finished) {
            throw new IllegalStateException("The result have been collected");
        }
        return this.incoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        StandardExecutionSession standardExecutionSession = this;
        synchronized (standardExecutionSession) {
            for (IncomingEndPoint incomingEndPoint : this.all) {
                if (!incomingEndPoint.wasCalled()) {
                    throw new IllegalStateException("all endpoints must have been called");
                }
                incomingEndPoint.finish();
            }
            this.finished = true;
        }
    }

    @Override
    public void cancel() {
        this.executor.shutdownNow();
    }

    private class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Callable<Object>> jobs = new ArrayList<Callable<Object>>();
            for (int i = 0; i < StandardExecutionSession.this.all.size(); ++i) {
                SimpleIncomingEndPoint endPoint = (SimpleIncomingEndPoint)StandardExecutionSession.this.all.get(i);
                while (endPoint.getWorkToDo(jobs) > 0) {
                    Iterator iter = jobs.iterator();
                    while (iter.hasNext()) {
                        Callable job = (Callable)iter.next();
                        Future future = StandardExecutionSession.this.executor.submit(job);
                        try {
                            Object result = future.get();
                            if (StandardExecutionSession.this.output.containsKey(i)) {
                                ((OutcomeTransformer)StandardExecutionSession.this.output.get(i)).resultMade(result);
                            }
                            iter.remove();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Throwable cause = e;
                            if (cause.getCause() != null) {
                                cause = e.getCause();
                            }
                            if (cause.getCause() != null) {
                                cause = cause.getCause();
                            }
                            if (cause.getCause() != null) {
                                cause = cause.getCause();
                            }
                            System.err.println(StandardExecutionSession.this.output);
                            System.err.println(StandardExecutionSession.this.output.get(i));
                            for (Integer key : StandardExecutionSession.this.output.keySet()) {
                                OutcomeTransformer transformer = (OutcomeTransformer)StandardExecutionSession.this.output.get(key);
                                transformer.crash(cause);
                            }
                        }
                    }
                    assert (jobs.isEmpty());
                }
            }
            StandardExecutionSession standardExecutionSession = StandardExecutionSession.this;
            synchronized (standardExecutionSession) {
                StandardExecutionSession.this.collector.finish();
            }
        }
    }
}

