/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.comparison;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonEvent;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonListener;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.ProteinDataComparisonTableCell;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.ProteinDataComparisonTableModel;
import es.uvigo.ei.sing.s2p.gui.table.CSVTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;

public class ProteinDataComparisonTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<Condition> conditions;
    private JXTable table;
    private ProteinDataComparisonTableModel tableModel;

    public ProteinDataComparisonTable(List<Condition> conditions) {
        this.conditions = conditions;
        this.initComponent();
    }

    private void initComponent() {
        this.initTable();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.table), "Center");
    }

    private void initTable() {
        this.tableModel = new ProteinDataComparisonTableModel(this.conditions.get(0), this.conditions.get(1));
        this.table = new CSVTable(this.tableModel);
        this.table.setTableHeader(null);
        this.table.setColumnControlVisible(false);
        ComparisonTableCellRenderer renderer = new ComparisonTableCellRenderer();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)renderer));
        this.table.getSelectionModel().addListSelectionListener(new ProteinDataComparisonTableSelectionListener());
        this.table.getColumnModel().addColumnModelListener(new ProteinDataComparisonTableColumnModelListener());
    }

    private synchronized void fireSamplesSelectionEvent(int selectedRow, int selectedColumn) {
        int colIndex = this.table.convertColumnIndexToModel(selectedColumn);
        int rowIndex = this.table.convertRowIndexToModel(selectedRow);
        if (rowIndex > 0 && colIndex > 0) {
            Sample[] selectedSamples = this.tableModel.getSamplesAt(rowIndex, colIndex);
            this.fireSampleSelectionEvent(new ProteinDataComparisonEvent(selectedSamples, ProteinDataComparisonEvent.Type.SAMPLE_SELECTION));
        } else {
            this.fireSampleSelectionClearedEvent();
        }
    }

    private void fireSampleSelectionEvent(ProteinDataComparisonEvent proteinDataComparisonTableEvent) {
        Arrays.asList(this.getTableListeners()).stream().forEach(l -> l.onSampleSelection(proteinDataComparisonTableEvent));
    }

    private void fireSampleSelectionClearedEvent() {
        this.fireSampleSelectionClearedEvent(new ProteinDataComparisonEvent(this, ProteinDataComparisonEvent.Type.SAMPLE_SELECTION_CLEARED));
    }

    private void fireSampleSelectionClearedEvent(ProteinDataComparisonEvent proteinDataComparisonTableEvent) {
        Arrays.asList(this.getTableListeners()).stream().forEach(l -> l.onSampleSelectionCleared(proteinDataComparisonTableEvent));
    }

    private boolean isSingleValueSelected() {
        return this.table.getSelectedColumnCount() == 1 && this.table.getSelectedRowCount() == 1;
    }

    public void setComparison(Condition condition1, Condition condition2) {
        this.tableModel.setComparison(condition1, condition2);
    }

    public void addTableListener(ProteinDataComparisonListener l) {
        this.listenerList.add(ProteinDataComparisonListener.class, l);
    }

    public void removeTableListener(ProteinDataComparisonListener l) {
        this.listenerList.remove(ProteinDataComparisonListener.class, l);
    }

    public ProteinDataComparisonListener[] getTableListeners() {
        return (ProteinDataComparisonListener[])this.listenerList.getListeners(ProteinDataComparisonListener.class);
    }

    public void setMascotIdentifications(Map<String, MascotIdentifications> identifications) {
        this.tableModel.setMascotIdentifications(identifications);
    }

    public void setShowProteinIdentifications(boolean show) {
        this.tableModel.setShowProteinIdentifications(show);
    }

    public void removeMascotIdentifications() {
        this.tableModel.removeMascotIdentifications();
    }

    private class ComparisonTableCellRenderer
    extends DefaultTableRenderer {
        private static final long serialVersionUID = 1L;

        private ComparisonTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int columnModel = table.convertColumnIndexToModel(column);
            int rowModel = table.convertRowIndexToModel(row);
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Font font = c.getFont().deriveFont(0, 14.0f);
            Color background = c.getBackground();
            if (rowModel == 0 && columnModel == 0) {
                background = UISettings.BG_COLOR;
            } else if (rowModel == 0 || columnModel == 0) {
                background = Color.LIGHT_GRAY;
                font = font.deriveFont(1);
            }
            if (value instanceof ProteinDataComparisonTableCell) {
                ProteinDataComparisonTableCell cell = (ProteinDataComparisonTableCell)value;
                if (c instanceof JLabel) {
                    ((JLabel)c).setText(cell.getCellValue());
                    ((JLabel)c).setToolTipText(cell.getCellTooltip());
                }
            }
            c.setFont(font);
            c.setBackground(background);
            return c;
        }
    }

    private class ProteinDataComparisonTableColumnModelListener
    implements TableColumnModelListener {
        private ProteinDataComparisonTableColumnModelListener() {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ProteinDataComparisonTable.this.isSingleValueSelected()) {
                    ProteinDataComparisonTable.this.fireSamplesSelectionEvent(ProteinDataComparisonTable.this.table.getSelectedRow(), ProteinDataComparisonTable.this.table.getSelectedColumn());
                } else {
                    ProteinDataComparisonTable.this.fireSampleSelectionClearedEvent();
                }
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }
    }

    private class ProteinDataComparisonTableSelectionListener
    implements ListSelectionListener {
        private ProteinDataComparisonTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (ProteinDataComparisonTable.this.isSingleValueSelected()) {
                    ProteinDataComparisonTable.this.fireSamplesSelectionEvent(ProteinDataComparisonTable.this.table.getSelectedRow(), ProteinDataComparisonTable.this.table.getSelectedColumn());
                } else {
                    ProteinDataComparisonTable.this.fireSampleSelectionClearedEvent();
                }
            }
        }
    }
}

