/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.mascot;

import es.uvigo.ei.sing.s2p.core.entities.MascotEntry;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class MascotEntryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, String> MASCOT_ENTRY_FIELDS = new HashMap<Integer, String>();
    private MascotIdentifications entries;

    public MascotEntryTableModel(MascotIdentifications entries) {
        this.entries = entries;
    }

    @Override
    public String getColumnName(int column) {
        return MASCOT_ENTRY_FIELDS.get(column);
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return MASCOT_ENTRY_FIELDS.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getRowCount() > 0 ? this.getValueAt(0, columnIndex).getClass() : Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MascotEntry entry = (MascotEntry)this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getTitle();
            }
            case 1: {
                return entry.getPlatePosition();
            }
            case 2: {
                return entry.getMascotScore();
            }
            case 3: {
                return entry.getDifference();
            }
            case 4: {
                return entry.getMsCoverage();
            }
            case 5: {
                return entry.getProteinMW();
            }
            case 6: {
                return entry.getMethod();
            }
            case 7: {
                return entry.getpIValue();
            }
            case 8: {
                return entry.getAccession();
            }
        }
        throw new RuntimeException("Invalid state");
    }

    static {
        MASCOT_ENTRY_FIELDS.put(0, "Title");
        MASCOT_ENTRY_FIELDS.put(1, "Plate position");
        MASCOT_ENTRY_FIELDS.put(2, "Score");
        MASCOT_ENTRY_FIELDS.put(3, "Difference");
        MASCOT_ENTRY_FIELDS.put(4, "MS Coverage");
        MASCOT_ENTRY_FIELDS.put(5, "Protein MW");
        MASCOT_ENTRY_FIELDS.put(6, "Method");
        MASCOT_ENTRY_FIELDS.put(7, "pI-Value");
        MASCOT_ENTRY_FIELDS.put(8, "Accession");
    }
}

