/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.tree;

import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.history.HistoryElement;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.workbench.Workbench;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class AIBenchTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (!(parent != null && parent.getUserObject() instanceof OperationDefinition || !leaf || node.getUserObject() instanceof ClipboardItem)) {
            c.setIcon(null);
        }
        if (node.getUserObject() instanceof ClipboardItem) {
            c.setText(((ClipboardItem)node.getUserObject()).getName());
            ImageIcon icon = Workbench.getInstance().getDataTypeIcon(((ClipboardItem)node.getUserObject()).getRegisteredUserClass());
            if (icon == null) {
                c.setIcon(new ImageIcon(this.getClass().getResource("/images/attach.png")));
            } else {
                c.setIcon(icon);
            }
        } else if (node.getUserObject() instanceof HistoryElement) {
            c.setText(((HistoryElement)node.getUserObject()).getOperation().getName());
            ImageIcon icon = Workbench.getInstance().getOperationIcon(((HistoryElement)node.getUserObject()).getOperation());
            if (icon == null) {
                c.setIcon(new ImageIcon(this.getClass().getResource("/images/process.png")));
            } else {
                c.setIcon(icon);
            }
        } else if (node.equals(tree.getModel().getRoot())) {
            c.setIcon(new ImageIcon(this.getClass().getResource("/images/session.gif")));
            c.setText("");
        } else {
            c.setText(value.toString());
            if (leaf) {
                c.setToolTipText(node.getUserObject().toString());
            } else {
                c.setToolTipText(null);
            }
        }
        return c;
    }
}

