/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class DirectColorModel
extends PackedColorModel {
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_offset;
    private int green_offset;
    private int blue_offset;
    private int alpha_offset;
    private int red_scale;
    private int green_scale;
    private int blue_scale;
    private int alpha_scale;
    private boolean is_LinearRGB;
    private int lRGBprecision;
    private byte[] tosRGB8LUT;
    private byte[] fromsRGB8LUT8;
    private short[] fromsRGB8LUT16;

    public DirectColorModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DirectColorModel(int n, int n2, int n3, int n4, int n5) {
        super(ColorSpace.getInstance(1000), n, n2, n3, n4, n5, false, n5 == 0 ? 1 : 3, ColorModel.getDefaultTransferType(n));
        this.setFields();
    }

    public DirectColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(colorSpace, n, n2, n3, n4, n5, bl, n5 == 0 ? 1 : 3, n6);
        if (ColorModel.isLinearRGBspace(this.colorSpace)) {
            this.is_LinearRGB = true;
            if (this.maxBits <= 8) {
                this.lRGBprecision = 8;
                this.tosRGB8LUT = ColorModel.getLinearRGB8TosRGB8LUT();
                this.fromsRGB8LUT8 = ColorModel.getsRGB8ToLinearRGB8LUT();
            } else {
                this.lRGBprecision = 16;
                this.tosRGB8LUT = ColorModel.getLinearRGB16TosRGB8LUT();
                this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            }
        } else if (!this.is_sRGB) {
            for (int i = 0; i < 3; ++i) {
                if (colorSpace.getMinValue(i) == 0.0f && colorSpace.getMaxValue(i) == 1.0f) continue;
                throw new IllegalArgumentException("Illegal min/max RGB component value");
            }
        }
        this.setFields();
    }

    public final int getRedMask() {
        return this.maskArray[0];
    }

    public final int getGreenMask() {
        return this.maskArray[1];
    }

    public final int getBlueMask() {
        return this.maskArray[2];
    }

    public final int getAlphaMask() {
        if (this.supportsAlpha) {
            return this.maskArray[3];
        }
        return 0;
    }

    private float[] getDefaultRGBComponents(int n) {
        int[] nArray = this.getComponents(n, (int[])null, 0);
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        return this.colorSpace.toRGB(fArray);
    }

    private int getsRGBComponentFromsRGB(int n, int n2) {
        int n3 = (n & this.maskArray[n2]) >>> this.maskOffsets[n2];
        if (this.isAlphaPremultiplied) {
            int n4 = (n & this.maskArray[3]) >>> this.maskOffsets[3];
            n3 = n4 == 0 ? 0 : (int)((float)n3 * this.scaleFactors[n2] * 255.0f / ((float)n4 * this.scaleFactors[3]) + 0.5f);
        } else if (this.scaleFactors[n2] != 1.0f) {
            n3 = (int)((float)n3 * this.scaleFactors[n2] + 0.5f);
        }
        return n3;
    }

    private int getsRGBComponentFromLinearRGB(int n, int n2) {
        int n3 = (n & this.maskArray[n2]) >>> this.maskOffsets[n2];
        if (this.isAlphaPremultiplied) {
            float f = (1 << this.lRGBprecision) - 1;
            int n4 = (n & this.maskArray[3]) >>> this.maskOffsets[3];
            n3 = n4 == 0 ? 0 : (int)((float)n3 * this.scaleFactors[n2] * f / ((float)n4 * this.scaleFactors[3]) + 0.5f);
        } else if (this.nBits[n2] != this.lRGBprecision) {
            n3 = this.lRGBprecision == 16 ? (int)((float)n3 * this.scaleFactors[n2] * 257.0f + 0.5f) : (int)((float)n3 * this.scaleFactors[n2] + 0.5f);
        }
        return this.tosRGB8LUT[n3] & 0xFF;
    }

    @Override
    public final int getRed(int n) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n, 0);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n, 0);
        }
        float[] fArray = this.getDefaultRGBComponents(n);
        return (int)(fArray[0] * 255.0f + 0.5f);
    }

    @Override
    public final int getGreen(int n) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n, 1);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n, 1);
        }
        float[] fArray = this.getDefaultRGBComponents(n);
        return (int)(fArray[1] * 255.0f + 0.5f);
    }

    @Override
    public final int getBlue(int n) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n, 2);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n, 2);
        }
        float[] fArray = this.getDefaultRGBComponents(n);
        return (int)(fArray[2] * 255.0f + 0.5f);
    }

    @Override
    public final int getAlpha(int n) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n2 = (n & this.maskArray[3]) >>> this.maskOffsets[3];
        if (this.scaleFactors[3] != 1.0f) {
            n2 = (int)((float)n2 * this.scaleFactors[3] + 0.5f);
        }
        return n2;
    }

    @Override
    public final int getRGB(int n) {
        if (this.is_sRGB || this.is_LinearRGB) {
            return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
        }
        float[] fArray = this.getDefaultRGBComponents(n);
        return this.getAlpha(n) << 24 | (int)(fArray[0] * 255.0f + 0.5f) << 16 | (int)(fArray[1] * 255.0f + 0.5f) << 8 | (int)(fArray[2] * 255.0f + 0.5f) << 0;
    }

    @Override
    public int getRed(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRed(n);
    }

    @Override
    public int getGreen(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getGreen(n);
    }

    @Override
    public int getBlue(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getBlue(n);
    }

    @Override
    public int getAlpha(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getAlpha(n);
    }

    @Override
    public int getRGB(Object object) {
        int n = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRGB(n);
    }

    @Override
    public Object getDataElements(int n, Object object) {
        int[] nArray = null;
        if (this.transferType == 3 && object != null) {
            nArray = (int[])object;
            nArray[0] = 0;
        } else {
            nArray = new int[1];
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        if (this == colorModel || this.equals(colorModel)) {
            nArray[0] = n;
            return nArray;
        }
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        if (this.is_sRGB || this.is_LinearRGB) {
            float f;
            int n5;
            if (this.is_LinearRGB) {
                if (this.lRGBprecision == 8) {
                    n2 = this.fromsRGB8LUT8[n2] & 0xFF;
                    n3 = this.fromsRGB8LUT8[n3] & 0xFF;
                    n4 = this.fromsRGB8LUT8[n4] & 0xFF;
                    n5 = 8;
                    f = 0.003921569f;
                } else {
                    n2 = this.fromsRGB8LUT16[n2] & 0xFFFF;
                    n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                    n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                    n5 = 16;
                    f = 1.5259022E-5f;
                }
            } else {
                n5 = 8;
                f = 0.003921569f;
            }
            if (this.supportsAlpha) {
                int n6 = n >> 24 & 0xFF;
                if (this.isAlphaPremultiplied) {
                    f *= (float)n6 * 0.003921569f;
                    n5 = -1;
                }
                if (this.nBits[3] != 8 && (n6 = (int)((float)n6 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f)) > (1 << this.nBits[3]) - 1) {
                    n6 = (1 << this.nBits[3]) - 1;
                }
                nArray[0] = n6 << this.maskOffsets[3];
            }
            if (this.nBits[0] != n5) {
                n2 = (int)((float)n2 * f * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            }
            if (this.nBits[1] != n5) {
                n3 = (int)((float)n3 * f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            }
            if (this.nBits[2] != n5) {
                n4 = (int)((float)n4 * f * (float)((1 << this.nBits[2]) - 1) + 0.5f);
            }
        } else {
            float[] fArray = new float[3];
            float f = 0.003921569f;
            fArray[0] = (float)n2 * f;
            fArray[1] = (float)n3 * f;
            fArray[2] = (float)n4 * f;
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.supportsAlpha) {
                int n7 = n >> 24 & 0xFF;
                if (this.isAlphaPremultiplied) {
                    f *= (float)n7;
                    int n8 = 0;
                    while (n8 < 3) {
                        int n9 = n8++;
                        fArray[n9] = fArray[n9] * f;
                    }
                }
                if (this.nBits[3] != 8 && (n7 = (int)((float)n7 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f)) > (1 << this.nBits[3]) - 1) {
                    n7 = (1 << this.nBits[3]) - 1;
                }
                nArray[0] = n7 << this.maskOffsets[3];
            }
            n2 = (int)(fArray[0] * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            n3 = (int)(fArray[1] * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            n4 = (int)(fArray[2] * (float)((1 << this.nBits[2]) - 1) + 0.5f);
        }
        if (this.maxBits > 23) {
            if (n2 > (1 << this.nBits[0]) - 1) {
                n2 = (1 << this.nBits[0]) - 1;
            }
            if (n3 > (1 << this.nBits[1]) - 1) {
                n3 = (1 << this.nBits[1]) - 1;
            }
            if (n4 > (1 << this.nBits[2]) - 1) {
                n4 = (1 << this.nBits[2]) - 1;
            }
        }
        nArray[0] = nArray[0] | (n2 << this.maskOffsets[0] | n3 << this.maskOffsets[1] | n4 << this.maskOffsets[2]);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)(0xFF & nArray[0]);
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)(nArray[0] & 0xFFFF);
                return sArray;
            }
            case 3: {
                return nArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public final int[] getComponents(int n, int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        }
        for (int i = 0; i < this.numComponents; ++i) {
            nArray[n2 + i] = (n & this.maskArray[i]) >>> this.maskOffsets[i];
        }
        return nArray;
    }

    @Override
    public final int[] getComponents(Object object, int[] nArray, int n) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n2 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n2, nArray, n);
    }

    @Override
    public final WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int[] nArray;
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width (" + n + ") and height (" + n2 + ") cannot be <= 0");
        }
        if (this.supportsAlpha) {
            nArray = new int[4];
            nArray[3] = this.alpha_mask;
        } else {
            nArray = new int[]{this.red_mask, this.green_mask, this.blue_mask};
        }
        if (this.pixel_bits > 16) {
            return Raster.createPackedRaster(3, n, n2, nArray, null);
        }
        if (this.pixel_bits > 8) {
            return Raster.createPackedRaster(1, n, n2, nArray, null);
        }
        return Raster.createPackedRaster(0, n, n2, nArray, null);
    }

    @Override
    public int getDataElement(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < this.numComponents; ++i) {
            n2 |= nArray[n + i] << this.maskOffsets[i] & this.maskArray[i];
        }
        return n2;
    }

    @Override
    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = 0;
        for (int i = 0; i < this.numComponents; ++i) {
            n2 |= nArray[n + i] << this.maskOffsets[i] & this.maskArray[i];
        }
        switch (this.transferType) {
            case 0: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    byArray[0] = (byte)(n2 & 0xFF);
                    return byArray;
                }
                byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
                return byArray;
            }
            case 1: {
                if (object instanceof short[]) {
                    short[] sArray = (short[])object;
                    sArray[0] = (short)(n2 & 0xFFFF);
                    return sArray;
                }
                short[] sArray = new short[]{(short)(n2 & 0xFFFF)};
                return sArray;
            }
            case 3: {
                if (object instanceof int[]) {
                    int[] nArray2 = (int[])object;
                    nArray2[0] = n2;
                    return nArray2;
                }
                int[] nArray3 = new int[]{n2};
                return nArray3;
            }
        }
        throw new ClassCastException("This method has not been implemented for transferType " + this.transferType);
    }

    @Override
    public final ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        block42: {
            int[] nArray;
            int n;
            int n2;
            float f;
            int n3;
            int n4;
            int n5;
            block41: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied() == bl) {
                    return this;
                }
                n5 = writableRaster.getWidth();
                n4 = writableRaster.getHeight();
                n3 = this.numColorComponents;
                f = 1.0f / (float)((1 << this.nBits[n3]) - 1);
                n2 = writableRaster.getMinX();
                n = writableRaster.getMinY();
                nArray = null;
                int[] nArray2 = null;
                if (!bl) break block41;
                switch (this.transferType) {
                    case 0: {
                        int n6 = 0;
                        while (n6 < n4) {
                            int n7 = n2;
                            int n8 = 0;
                            while (n8 < n5) {
                                float f2 = (float)(nArray = writableRaster.getPixel(n7, n, nArray))[n3] * f;
                                if (f2 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        nArray[i] = (int)((float)nArray[i] * f2 + 0.5f);
                                    }
                                    writableRaster.setPixel(n7, n, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n7, n, nArray2);
                                }
                                ++n8;
                                ++n7;
                            }
                            ++n6;
                            ++n;
                        }
                        break block42;
                    }
                    case 1: {
                        int n9 = 0;
                        while (n9 < n4) {
                            int n10 = n2;
                            int n11 = 0;
                            while (n11 < n5) {
                                float f3 = (float)(nArray = writableRaster.getPixel(n10, n, nArray))[n3] * f;
                                if (f3 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        nArray[i] = (int)((float)nArray[i] * f3 + 0.5f);
                                    }
                                    writableRaster.setPixel(n10, n, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n10, n, nArray2);
                                }
                                ++n11;
                                ++n10;
                            }
                            ++n9;
                            ++n;
                        }
                        break block42;
                    }
                    case 3: {
                        int n12 = 0;
                        while (n12 < n4) {
                            int n13 = n2;
                            int n14 = 0;
                            while (n14 < n5) {
                                float f4 = (float)(nArray = writableRaster.getPixel(n13, n, nArray))[n3] * f;
                                if (f4 != 0.0f) {
                                    for (int i = 0; i < n3; ++i) {
                                        nArray[i] = (int)((float)nArray[i] * f4 + 0.5f);
                                    }
                                    writableRaster.setPixel(n13, n, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n13, n, nArray2);
                                }
                                ++n14;
                                ++n13;
                            }
                            ++n12;
                            ++n;
                        }
                        break block42;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    int n15 = 0;
                    while (n15 < n4) {
                        int n16 = n2;
                        int n17 = 0;
                        while (n17 < n5) {
                            float f5 = (float)(nArray = writableRaster.getPixel(n16, n, nArray))[n3] * f;
                            if (f5 != 0.0f) {
                                float f6 = 1.0f / f5;
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = (int)((float)nArray[i] * f6 + 0.5f);
                                }
                                writableRaster.setPixel(n16, n, nArray);
                            }
                            ++n17;
                            ++n16;
                        }
                        ++n15;
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n18 = 0;
                    while (n18 < n4) {
                        int n19 = n2;
                        int n20 = 0;
                        while (n20 < n5) {
                            float f7 = (float)(nArray = writableRaster.getPixel(n19, n, nArray))[n3] * f;
                            if (f7 != 0.0f) {
                                float f8 = 1.0f / f7;
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = (int)((float)nArray[i] * f8 + 0.5f);
                                }
                                writableRaster.setPixel(n19, n, nArray);
                            }
                            ++n20;
                            ++n19;
                        }
                        ++n18;
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n21 = 0;
                    while (n21 < n4) {
                        int n22 = n2;
                        int n23 = 0;
                        while (n23 < n5) {
                            float f9 = (float)(nArray = writableRaster.getPixel(n22, n, nArray))[n3] * f;
                            if (f9 != 0.0f) {
                                float f10 = 1.0f / f9;
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = (int)((float)nArray[i] * f10 + 0.5f);
                                }
                                writableRaster.setPixel(n22, n, nArray);
                            }
                            ++n23;
                            ++n22;
                        }
                        ++n21;
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        return new DirectColorModel(this.colorSpace, this.pixel_bits, this.maskArray[0], this.maskArray[1], this.maskArray[2], this.maskArray[3], bl, this.transferType);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        if (singlePixelPackedSampleModel.getNumBands() != this.getNumComponents()) {
            return false;
        }
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        for (int i = 0; i < this.numComponents; ++i) {
            if (nArray[i] == this.maskArray[i]) continue;
            return false;
        }
        return raster.getTransferType() == this.transferType;
    }

    private void setFields() {
        this.red_mask = this.maskArray[0];
        this.red_offset = this.maskOffsets[0];
        this.green_mask = this.maskArray[1];
        this.green_offset = this.maskOffsets[1];
        this.blue_mask = this.maskArray[2];
        this.blue_offset = this.maskOffsets[2];
        if (this.nBits[0] < 8) {
            this.red_scale = (1 << this.nBits[0]) - 1;
        }
        if (this.nBits[1] < 8) {
            this.green_scale = (1 << this.nBits[1]) - 1;
        }
        if (this.nBits[2] < 8) {
            this.blue_scale = (1 << this.nBits[2]) - 1;
        }
        if (this.supportsAlpha) {
            this.alpha_mask = this.maskArray[3];
            this.alpha_offset = this.maskOffsets[3];
            if (this.nBits[3] < 8) {
                this.alpha_scale = (1 << this.nBits[3]) - 1;
            }
        }
    }

    @Override
    public String toString() {
        return new String("DirectColorModel: rmask=" + Integer.toHexString(this.red_mask) + " gmask=" + Integer.toHexString(this.green_mask) + " bmask=" + Integer.toHexString(this.blue_mask) + " amask=" + Integer.toHexString(this.alpha_mask));
    }
}

