/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.TextAreaAppender;
import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.CoreListener;
import es.uvigo.ei.aibench.core.CoreUtils;
import es.uvigo.ei.aibench.core.IGenericGUI;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.ProgressHandler;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.datatypes.annotation.Datatype;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.workbench.Data;
import es.uvigo.ei.aibench.workbench.DefaultViewFactory;
import es.uvigo.ei.aibench.workbench.InputGUI;
import es.uvigo.ei.aibench.workbench.MainWindow;
import es.uvigo.ei.aibench.workbench.MemoryMonitor;
import es.uvigo.ei.aibench.workbench.MonitorizeDialog;
import es.uvigo.ei.aibench.workbench.OperationWrapper;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.WorkbenchExtensionTools;
import es.uvigo.ei.aibench.workbench.error.ComposedErrorNotifierProvider;
import es.uvigo.ei.aibench.workbench.error.ErrorNotifier;
import es.uvigo.ei.aibench.workbench.error.ErrorNotifierProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ParamsWindow;
import es.uvigo.ei.aibench.workbench.interfaces.AbstractViewFactory;
import es.uvigo.ei.aibench.workbench.interfaces.IViewFactory;
import es.uvigo.ei.aibench.workbench.interfaces.WorkbenchListener;
import es.uvigo.ei.aibench.workbench.tree.AIBenchJTreeManager;
import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.PluginXmlNode;

public class Workbench
implements IGenericGUI,
ClipboardListener {
    static final Logger logger = Logger.getLogger((String)Workbench.class.getName());
    private static Workbench _instance = null;
    private MainWindow mainWindow = null;
    private final List<OperationWrapper> interceptedOperations = new ArrayList<OperationWrapper>();
    private final Map<OperationDefinition<?>, OperationWrapper> operationDefinition2Wrapper = new HashMap();
    private final Map<OperationDefinition<?>, Class<?>> operationGUI = new HashMap();
    private final Map<Class<?>, List<IViewFactory>> dataTypeViews = new HashMap();
    private JComponent welcomeScreen;
    private String welcomeScreenTitle;
    private final Map<OperationDefinition<?>, ImageIcon> operationIcons = new HashMap();
    private final Map<OperationDefinition<?>, ImageIcon> operationBigIcons = new HashMap();
    private final Map<Class<?>, ImageIcon> dataTypeIcon = new HashMap();
    private final Map<OperationDefinition<?>, Vector<String>> operationVisibility = new HashMap();
    private List<ClipboardItem> openedItems = new Vector<ClipboardItem>();
    private final List<ClipboardItem> closedItems = new Vector<ClipboardItem>();
    private final List<WorkbenchListener> workbenchListeners = new ArrayList<WorkbenchListener>();
    private final Map<Object, MonitorizeDialog> monitors = new HashMap<Object, MonitorizeDialog>();
    private ClipboardItem activeItem = null;
    private ErrorNotifierProvider errorNotifierProvider = new ComposedErrorNotifierProvider();
    public static final Properties CONFIG = new Properties();
    private JComponent toret;
    static final String AIBENCH_HELP_PROPERTY = "AIBench.help";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workbench() {
        Class<Workbench> clazz = Workbench.class;
        synchronized (Workbench.class) {
            if (_instance != null) {
                throw new RuntimeException("This is a singleton.");
            }
            _instance = this;
            Core.getInstance().getClipboard().addClipboardListener((ClipboardListener)this);
            Core.getInstance().addCoreListener(new CoreListener(){

                public void operationDisabled(OperationDefinition<?> definition) {
                    ((OperationWrapper)Workbench.this.operationDefinition2Wrapper.get(definition)).setEnabled(false);
                }

                public void operationEnabled(OperationDefinition<?> definition) {
                    ((OperationWrapper)Workbench.this.operationDefinition2Wrapper.get(definition)).setEnabled(true);
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public JFrame getMainFrame() {
        return this.mainWindow;
    }

    private static synchronized void createInstance() {
        if (_instance == null) {
            new Workbench();
        }
    }

    public static Workbench getInstance() {
        if (_instance == null) {
            Workbench.createInstance();
        }
        return _instance;
    }

    public void setActiveData(ClipboardItem data) {
        if (this.activeItem != data) {
            this.activeItem = data;
        }
        if (this.activeItem != null) {
            this.mainWindow.bringToFront(this.activeItem);
        }
    }

    public AIBenchJTreeManager getTreeManager() {
        return AIBenchJTreeManager.getInstance();
    }

    public JMenuBar getMenuBar() {
        if (System.getProperty("aibench.nogui") != null) {
            throw new RuntimeException("no menu bar if aibench.nogui property was set");
        }
        return this.mainWindow.getJMenuBar();
    }

    public JToolBar getToolBar() {
        if (System.getProperty("aibench.nogui") != null) {
            throw new RuntimeException("no tool bar if aibench.nogui property was set");
        }
        return this.mainWindow.getToolbar();
    }

    public void showData(final ClipboardItem data) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Workbench.this.showData(data);
                }
            });
        } else if (data != null) {
            Datatype annot;
            List<IViewFactory> availableViews = this.searchView(data.getUserData());
            ArrayList<IViewFactory> copied = null;
            if (availableViews != null) {
                copied = new ArrayList<IViewFactory>();
                copied.addAll(availableViews);
            }
            if (copied == null) {
                copied = new ArrayList();
                copied.add(new DefaultViewFactory());
            } else if (CONFIG.getProperty("documentviewer.allways_show_default_view") != null && CONFIG.getProperty("documentviewer.allways_show_default_view").equals("true")) {
                copied.add(new DefaultViewFactory());
            }
            if (data.getUserData() != null && (annot = data.getUserData().getClass().getAnnotation(Datatype.class)) != null && !annot.viewable() && copied.size() == 1 && copied.get(0) instanceof DefaultViewFactory) {
                return;
            }
            if (copied.size() != 0) {
                if (this.openedItems.contains(data)) {
                    this.mainWindow.bringToFront(data);
                } else if (this.closedItems.contains(data)) {
                    this.mainWindow.showViews(copied, data);
                    this.openedItems.add(data);
                    this.closedItems.remove(data);
                } else {
                    this.mainWindow.showViews(copied, data);
                    this.openedItems.add(data);
                }
                if (this.getActiveData() != null) {
                    this.fireDataHided(this.getActiveData());
                }
                this.setActiveData(data);
                this.fireDataShowed(data);
            } else {
                logger.warn((Object)"Not available views");
            }
        } else {
            logger.warn((Object)"Workbench.showData(): Data is NULL");
        }
    }

    public void hideData(ClipboardItem data) {
        this.openedItems.remove(data);
        this.closedItems.add(data);
        this.mainWindow.hideData(data);
        this.fireDataClosed(data);
        if (this.openedItems.size() == 0) {
            this.setActiveData(null);
        } else if (this.getActiveData() == data) {
            this.setActiveData(this.openedItems.get(0));
        }
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("Closed " + (data.getUserData() != null ? data.getUserData().toString().substring(0, Math.min(data.getUserData().toString().length(), 100)) : " null item")));
        }
    }

    public void hideAllData() {
        if (this.openedItems.size() > 0) {
            this.hideData(this.openedItems.get(0));
            this.hideAllData();
        }
    }

    public ClipboardItem getActiveData() {
        return this.activeItem;
    }

    public ImageIcon getOperationIcon(OperationDefinition<?> operation) {
        if (operation == null) {
            return null;
        }
        return this.operationIcons.get(operation);
    }

    public ImageIcon getOperationIcon(String uid) {
        return this.getOperationIcon(Core.getInstance().getOperationById(uid));
    }

    public ImageIcon getOperationBigIcon(OperationDefinition<?> operation) {
        if (operation == null) {
            return null;
        }
        return this.operationBigIcons.get(operation);
    }

    public ImageIcon getOperationBigIcon(String uid) {
        return this.getOperationBigIcon(Core.getInstance().getOperationById(uid));
    }

    public ImageIcon getDataTypeIcon(Class<?> dataType) {
        if (this.dataTypeIcon.containsKey(dataType)) {
            return this.dataTypeIcon.get(dataType);
        }
        Class<?> currentClass = dataType;
        while ((currentClass = currentClass.getSuperclass()) != null) {
            for (Class<?> key : this.dataTypeIcon.keySet()) {
                if (!key.equals(currentClass)) continue;
                return this.dataTypeIcon.get(key);
            }
        }
        for (Class<?> key : this.dataTypeIcon.keySet()) {
            if (!key.isAssignableFrom(dataType)) continue;
            return this.dataTypeIcon.get(key);
        }
        return null;
    }

    public List<IViewFactory> getDataTypeViews(Class<?> dataType) {
        LinkedList<IViewFactory> toret = new LinkedList<IViewFactory>();
        for (Class<?> key : this.dataTypeViews.keySet()) {
            if (!key.isAssignableFrom(dataType)) continue;
            toret.addAll((Collection<IViewFactory>)this.dataTypeViews.get(key));
        }
        return toret;
    }

    public Class<?> getInputGUIClass(OperationDefinition<?> operation) {
        if (operation == null) {
            return null;
        }
        return this.operationGUI.get(operation);
    }

    public Class<?> getInputGUIClass(String uid) {
        return this.operationGUI.get(Core.getInstance().getOperationById(uid));
    }

    public boolean isOperationViewableIn(String uid, String identifier) {
        return this.isOperationViewableIn(Core.getInstance().getOperationById(uid), identifier);
    }

    public boolean isOperationViewableIn(OperationDefinition<?> operation, String identifier) {
        if (operation == null) {
            return false;
        }
        String visibility = CONFIG.getProperty(operation.getID() + ".visibility");
        if (visibility == null && this.operationVisibility.get(operation) != null) {
            visibility = this.operationVisibility.get(operation).toString();
        }
        if (visibility != null) {
            if (visibility.toUpperCase().indexOf("NONE") != -1) {
                return false;
            }
            return visibility.toUpperCase().indexOf(identifier) != -1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClipboardItem> executeOperationAndWait(final OperationDefinition<?> operation) {
        final Object pleaseWait = new Object();
        InputGUI win = this.getInputGUI(operation);
        class MyParamsReceiver
        implements ParamsReceiver,
        ProgressHandler {
            InputGUI gui;
            private List<ClipboardItem> toRemove;
            private boolean finished = false;
            private List<ClipboardItem> clipboardItems;
            Object operationKey;

            private void doRemove() {
                if (this.toRemove != null) {
                    for (int i = this.toRemove.size() - 1; i >= 0; --i) {
                        Core.getInstance().getClipboard().removeClipboardItem(this.toRemove.get(i));
                    }
                }
            }

            public MyParamsReceiver(InputGUI gui) {
                this.gui = gui;
            }

            @Override
            public void paramsIntroduced(ParamSpec[] params) {
                Core.getInstance().executeOperation(operation, (ProgressHandler)this, params);
            }

            public void operationStart(final Object progressBean, final Object operationKey) {
                this.operationKey = operationKey;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationStart(progressBean, operationKey);
                        }
                    });
                } else {
                    this.gui.finish();
                    MonitorizeDialog monitorDialog = new MonitorizeDialog(Workbench.this.mainWindow, progressBean, operationKey, operation);
                    monitorDialog.setModal(true);
                    Workbench.this.monitors.put(operationKey, monitorDialog);
                    monitorDialog.setVisible(true);
                }
            }

            public void validationError(Throwable t) {
                this.gui.onValidationError(t);
                t.printStackTrace();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationFinished(final List<Object> results, final List<ClipboardItem> clipboardItems) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationFinished(results, clipboardItems);
                        }
                    });
                } else if (Workbench.this.monitors.get(this.operationKey) != null) {
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setFinish(true);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setVisible(false);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).dispose();
                    Workbench.this.monitors.remove(this.operationKey);
                }
                this.clipboardItems = clipboardItems;
                this.finished = true;
                Object object = pleaseWait;
                synchronized (object) {
                    pleaseWait.notifyAll();
                }
                this.doRemove();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationError(Throwable t) {
                this.finished = true;
                Object object = pleaseWait;
                synchronized (object) {
                    pleaseWait.notifyAll();
                }
                this.doRemove();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                this.gui.finish();
                this.finished = true;
                Object object = pleaseWait;
                synchronized (object) {
                    pleaseWait.notifyAll();
                }
                this.doRemove();
            }

            @Override
            public void removeAfterTermination(List<ClipboardItem> items) {
                this.toRemove = items;
            }
        }
        MyParamsReceiver callback = new MyParamsReceiver(win);
        win.init(callback, operation);
        Object object = pleaseWait;
        synchronized (object) {
            if (!callback.finished) {
                try {
                    pleaseWait.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return callback.clipboardItems;
    }

    public void executeOperation(OperationDefinition<?> operation, ParamSpec[] params) {
        this.executeOperation(operation, null, params);
    }

    public void executeOperation(String uid, ProgressHandler userHandler, List<?> parameters) {
        this.executeOperation(Core.getInstance().getOperationById(uid), userHandler, CoreUtils.createParams(parameters));
    }

    public void executeOperation(final OperationDefinition<?> operation, final ProgressHandler userHandler, ParamSpec[] params) {
        class MyProgressHandler
        implements ProgressHandler {
            private List<ClipboardItem> toRemove;
            Object operationKey;

            MyProgressHandler() {
            }

            private void doRemove() {
                if (this.toRemove != null) {
                    ArrayList list = new ArrayList();
                    Collections.copy(this.toRemove, list);
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Core.getInstance().getClipboard().removeClipboardItem((ClipboardItem)list.get(i));
                    }
                }
            }

            public void operationStart(final Object progressBean, final Object operationKey) {
                this.operationKey = operationKey;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationStart(progressBean, operationKey);
                        }
                    });
                } else {
                    MonitorizeDialog monitorDialog = new MonitorizeDialog(Workbench.this.mainWindow, progressBean, operationKey, operation);
                    Workbench.this.monitors.put(operationKey, monitorDialog);
                    monitorDialog.setVisible(true);
                }
                if (userHandler != null) {
                    userHandler.operationStart(progressBean, operationKey);
                }
            }

            public void validationError(Throwable t) {
                t.printStackTrace();
                if (userHandler != null) {
                    userHandler.validationError(t);
                }
            }

            public void operationFinished(final List<Object> results, final List<ClipboardItem> clipboardItems) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationFinished(results, clipboardItems);
                        }
                    });
                } else if (Workbench.this.monitors.get(this.operationKey) != null) {
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setFinish(true);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setVisible(false);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).dispose();
                    Workbench.this.monitors.remove(this.operationKey);
                    this.doRemove();
                }
                if (userHandler != null) {
                    userHandler.operationFinished(results, clipboardItems);
                }
            }

            public void operationError(Throwable t) {
                this.doRemove();
                if (userHandler != null) {
                    userHandler.operationError(t);
                }
            }
        }
        MyProgressHandler handler = new MyProgressHandler();
        Core.getInstance().executeOperation(operation, (ProgressHandler)handler, params);
    }

    public void executeOperation(OperationDefinition<?> operation) {
        this.executeOperation(operation, (ProgressHandler)null);
    }

    public void executeOperation(final OperationDefinition<?> operation, final ProgressHandler userHandler) {
        InputGUI win = this.getInputGUI(operation);
        class MyParamsReceiver
        implements ParamsReceiver,
        ProgressHandler {
            private List<ClipboardItem> toRemove;
            InputGUI gui;
            Object operationKey;

            private void doRemove() {
                if (this.toRemove != null) {
                    ArrayList list = new ArrayList();
                    Collections.copy(this.toRemove, list);
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Core.getInstance().getClipboard().removeClipboardItem((ClipboardItem)list.get(i));
                    }
                }
            }

            public MyParamsReceiver(InputGUI gui) {
                this.gui = gui;
            }

            @Override
            public void paramsIntroduced(ParamSpec[] params) {
                Core.getInstance().executeOperation(operation, (ProgressHandler)this, params);
            }

            public void operationStart(final Object progressBean, final Object operationKey) {
                this.operationKey = operationKey;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationStart(progressBean, operationKey);
                        }
                    });
                } else {
                    this.gui.finish();
                    MonitorizeDialog monitorDialog = new MonitorizeDialog(Workbench.this.mainWindow, progressBean, operationKey, operation);
                    Workbench.this.monitors.put(operationKey, monitorDialog);
                    monitorDialog.setVisible(true);
                }
                if (userHandler != null) {
                    userHandler.operationStart(progressBean, operationKey);
                }
            }

            public void validationError(Throwable t) {
                this.gui.onValidationError(t);
                t.printStackTrace();
                if (userHandler != null) {
                    userHandler.validationError(t);
                }
            }

            public void operationFinished(final List<Object> results, final List<ClipboardItem> clipboardItems) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationFinished(results, clipboardItems);
                        }
                    });
                } else if (Workbench.this.monitors.get(this.operationKey) != null) {
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setFinish(true);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).setVisible(false);
                    ((MonitorizeDialog)Workbench.this.monitors.get(this.operationKey)).dispose();
                    Workbench.this.monitors.remove(this.operationKey);
                    this.doRemove();
                }
                if (userHandler != null) {
                    userHandler.operationFinished(results, clipboardItems);
                }
            }

            public void operationError(Throwable t) {
                this.doRemove();
                if (userHandler != null) {
                    userHandler.operationError(t);
                }
            }

            @Override
            public void cancel() {
                this.gui.finish();
                this.doRemove();
            }

            @Override
            public void removeAfterTermination(List<ClipboardItem> items) {
                this.toRemove = items;
            }
        }
        MyParamsReceiver callback = new MyParamsReceiver(win);
        win.init(callback, operation);
    }

    public List<OperationWrapper> getInterceptedOperations() {
        return this.interceptedOperations;
    }

    public void putItemInSlot(final String slotID, final String componentName, final String componentID, final JComponent component) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Workbench.this.putItemInSlot(slotID, componentName, componentID, component);
                }
            });
        } else {
            if (this.mainWindow == null) {
                return;
            }
            this.mainWindow.putItemInSlot(slotID, componentName, componentID, component);
            this.fireComponentAdded(slotID, componentName, componentID, component);
        }
    }

    public List<String> getAvailableSlotIDs() {
        return this.mainWindow.getAvailableSlotIDs();
    }

    public JComponent removeComponentFromSlot(final String componentID) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Workbench.this.toret = Workbench.this.removeComponentFromSlot(componentID);
                    }
                });
                return this.toret;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        JComponent removed = this.mainWindow.removeComponentFromSlot(componentID);
        this.fireComponentRemoved(componentID, removed);
        return removed;
    }

    public JComponent getComponentAtSlot(String componentID) {
        return this.mainWindow.getComponentAtSlot(componentID);
    }

    public String getStatusText() {
        return this.mainWindow.getStatusBar().getText();
    }

    public void init() {
        this.createViewFactories();
        this.createWelcomeScreen();
        this.createOperationWrappers();
        this.createIconMappings();
        this.createInputGUIMappings();
        this.createOperationVisibility();
        if (System.getProperty("aibench.nogui") == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Workbench.this.createMainWindow();
                    Workbench.this.putCoreComponents();
                    Workbench.this.createComponents();
                    Workbench.this.mainWindow.pack();
                    Workbench.this.mainWindow.setLocationRelativeTo(null);
                }
            });
        }
    }

    public void update() {
        List<OperationWrapper> temp = this.interceptedOperations;
        for (OperationWrapper wrapper : temp) {
            wrapper.updateState();
        }
    }

    public void info(String info) {
        logger.info((Object)info);
        if (System.getProperty("aibench.nogui") != null) {
            return;
        }
        JOptionPane.showMessageDialog(null, info, "Information", 1);
    }

    public void warn(String info) {
        logger.warn((Object)info);
        if (System.getProperty("aibench.nogui") != null) {
            return;
        }
        JOptionPane.showMessageDialog(null, info, "Warning", 2);
    }

    public void error(final String message) {
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("Error message received: " + message));
        }
        logger.error((Object)message);
        if (System.getProperty("aibench.nogui") != null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message, "Error", 0);
            }
        });
    }

    public void error(Throwable exception) {
        logger.error((Object)exception.toString());
        ErrorNotifier notifier = this.errorNotifierProvider.createErrorNotifier();
        notifier.showError(this.mainWindow, exception);
    }

    public void error(Throwable exception, String message) {
        logger.error((Object)message, exception);
        ErrorNotifier notifier = this.errorNotifierProvider.createErrorNotifier();
        notifier.showError(this.mainWindow, exception, message);
    }

    public void setStatusText(final String text) {
        if (System.getProperty("aibench.nogui") != null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Workbench.this.mainWindow.getStatusBar().setText(text);
            }
        });
    }

    public void elementAdded(ClipboardItem item) {
        Datatype annotation;
        Object userData = item.getUserData();
        if (userData != null && (annotation = userData.getClass().getAnnotation(Datatype.class)) != null && annotation.autoOpen()) {
            Workbench.getInstance().showData(item);
        }
    }

    public void elementRemoved(ClipboardItem item) {
        if (this.openedItems.contains(item)) {
            this.hideData(item);
        }
        this.openedItems.remove(item);
        this.closedItems.add(item);
    }

    public void addWorkbenchListener(WorkbenchListener listener) {
        this.workbenchListeners.add(listener);
    }

    private List<IViewFactory> searchView(Object data) {
        if (data == null) {
            return null;
        }
        return this.getDataTypeViews(data.getClass());
    }

    private void fireDataShowed(ClipboardItem data) {
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.dataShowed(data);
        }
    }

    private void fireDataHided(ClipboardItem data) {
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.dataHidded(data);
        }
    }

    private void fireDataClosed(ClipboardItem data) {
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.dataClosed(data);
        }
    }

    private void fireComponentAdded(String slotID, String componentName, String componentID, JComponent component) {
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.componentAdded(slotID, componentName, componentID, component);
        }
    }

    private void fireComponentRemoved(String slotID, JComponent component) {
        for (WorkbenchListener listener : this.workbenchListeners) {
            listener.componentRemoved(slotID, component);
        }
    }

    public void showViewHelp(JComponent view) {
        Object value = view.getClientProperty(AIBENCH_HELP_PROPERTY);
        String help = null;
        if (value instanceof String) {
            help = (String)value;
        }
        this.showHelpTopic(help, "There's no help available for the view.");
    }

    public void showDatatypeHelp(Datatype datatype) {
        this.showHelpTopic(datatype.help(), "There's no help available for the datatype.");
    }

    public void showOperationHelp(OperationDefinition<?> operation) {
        this.showHelpTopic(operation.getHelp(), "There's no help available for the operation.");
    }

    public void showHelpTopic(String help) {
        this.showHelpTopic(help, "No help available.");
    }

    public void showHelpTopic(String help, String errorMessage) {
        if (help == null || help.trim().equals("")) {
            this.showHelp(errorMessage);
        } else if (CoreUtils.isValidURL((String)help)) {
            try {
                CoreUtils.openURL((String)help);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainWindow, errorMessage, "Help Unavailable", 0);
            }
        } else {
            HelpBroker helpBroker = Core.getInstance().getHelpBroker();
            if (helpBroker == null) {
                JOptionPane.showMessageDialog(this.mainWindow, errorMessage, "Help Unavailable", 0);
            } else {
                helpBroker.setCurrentID(help);
                helpBroker.setDisplayed(true);
            }
        }
    }

    public void showHelp() {
        this.showHelp("No help available.");
    }

    public void showHelp(String errorMessage) {
        String homeURL = Core.CONFIG.getProperty("help.homeurl");
        if (homeURL == null || homeURL.trim().equals("")) {
            HelpBroker helpBroker = Core.getInstance().getHelpBroker();
            if (helpBroker == null) {
                JOptionPane.showMessageDialog(this.mainWindow, errorMessage, "Help Unavailable", 0);
            } else {
                helpBroker.setDisplayed(true);
            }
        } else {
            try {
                CoreUtils.openURL((String)homeURL);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainWindow, errorMessage, "Help Unavailable", 0);
            }
        }
    }

    private void createMainWindow() {
        Container container;
        this.mainWindow = new MainWindow(this.interceptedOperations);
        if (this.welcomeScreen != null) {
            this.mainWindow.getDocumentTabbedPane().addTab(this.welcomeScreenTitle, this.welcomeScreen);
        }
        if (Boolean.parseBoolean(Core.CONFIG.getProperty("help.enabled", "false")) && (container = this.mainWindow.getContentPane()) instanceof JComponent) {
            final JComponent containerComponent = (JComponent)container;
            containerComponent.setFocusable(true);
            containerComponent.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), 112);
            containerComponent.getInputMap(1).put(KeyStroke.getKeyStroke(156, 0), 156);
            AbstractAction actionHelp = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object value = containerComponent.getClientProperty(Workbench.AIBENCH_HELP_PROPERTY);
                    String errorMessage = "There's no help available for the current view.";
                    Workbench.this.showHelpTopic((String)value, "There's no help available for the current view.");
                }
            };
            containerComponent.getActionMap().put(112, actionHelp);
            containerComponent.getActionMap().put(156, actionHelp);
        }
    }

    private void createOperationWrappers() {
        List operations = Core.getInstance().getOperations();
        for (OperationDefinition operation : operations) {
            OperationWrapper newWrapper = new OperationWrapper(operation);
            this.interceptedOperations.add(newWrapper);
            this.operationDefinition2Wrapper.put(operation, newWrapper);
        }
    }

    private void createIconMappings() {
        for (Extension extension : WorkbenchExtensionTools.getWorkbenchViewExtensions()) {
            for (PluginXmlNode node : extension.getExtensionXmlNode().getChildren()) {
                ImageIcon icon;
                String operationID;
                if (node.getName().equals("icon-operation")) {
                    operationID = node.getAttribute("operation");
                    icon = new ImageIcon(extension.getPlugin().getPluginClassLoader().getResource(node.getAttribute("icon")));
                    for (OperationWrapper wrapper : this.interceptedOperations) {
                        if (!wrapper.getOperationDefinition().getID().equals(operationID)) continue;
                        this.operationIcons.put(wrapper.getOperationDefinition(), icon);
                    }
                }
                if (node.getName().equals("big-icon-operation")) {
                    operationID = node.getAttribute("operation");
                    icon = new ImageIcon(extension.getPlugin().getPluginClassLoader().getResource(node.getAttribute("icon")));
                    for (OperationWrapper wrapper : this.interceptedOperations) {
                        if (!wrapper.getOperationDefinition().getID().equals(operationID)) continue;
                        this.operationBigIcons.put(wrapper.getOperationDefinition(), icon);
                    }
                }
                if (!node.getName().equals("icon-datatype")) continue;
                String dataType = node.getAttribute("datatype");
                icon = new ImageIcon(extension.getPlugin().getPluginClassLoader().getResource(node.getAttribute("icon")));
                try {
                    this.dataTypeIcon.put(extension.getPlugin().getPluginClassLoader().loadClass(dataType), icon);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void createOperationVisibility() {
        for (PluginXmlNode node : WorkbenchExtensionTools.getWorkbenchViewExtensionsChildren()) {
            if (!node.getName().equals("operation-visibility")) continue;
            String operationID = node.getAttribute("operation");
            String visibility = node.getAttribute("visibility");
            for (OperationWrapper wrapper : this.interceptedOperations) {
                if (!wrapper.getOperationDefinition().getID().equals(operationID)) continue;
                Vector<String> visibilityV = new Vector<String>();
                StringTokenizer tk = new StringTokenizer(visibility);
                while (tk.hasMoreTokens()) {
                    visibilityV.addElement(tk.nextToken());
                }
                this.operationVisibility.put(wrapper.getOperationDefinition(), visibilityV);
            }
        }
    }

    private void createComponents() {
        for (Extension extension : WorkbenchExtensionTools.getWorkbenchViewExtensions()) {
            for (PluginXmlNode node : extension.getExtensionXmlNode().getChildren()) {
                if (!node.getName().equals("component")) continue;
                String slotID = node.getAttribute("slotid");
                String className = node.getAttribute("class");
                String name = node.getAttribute("name");
                String componentID = node.getAttribute("componentID");
                String staticMethod = node.getAttribute("singletonMethod");
                try {
                    Class<?> c = extension.getPlugin().getPluginClassLoader().loadClass(className);
                    JComponent component = null;
                    if (staticMethod == null) {
                        component = (JComponent)c.newInstance();
                    } else {
                        Method m = c.getMethod(staticMethod, new Class[0]);
                        component = (JComponent)m.invoke(null, new Object[0]);
                    }
                    this.putItemInSlot(slotID, name, componentID, component);
                }
                catch (Exception e) {
                    logger.error((Object)"Error creating component", (Throwable)e);
                }
            }
        }
    }

    private void putCoreComponents() {
        String memoryVisible;
        String logAreaVisible;
        String clipboardTreeVisible;
        String sessionTreeVisible = CONFIG.getProperty("sessiontree.visible");
        if (sessionTreeVisible == null || !sessionTreeVisible.equals("false")) {
            JScrollPane sessionTreeSP = new JScrollPane(this.getTreeManager().getAIBenchTree());
            sessionTreeSP.setPreferredSize(new Dimension(200, 200));
            String sessionTreeSlot = CONFIG.getProperty("sessiontree.slot");
            String sessionTreeName = "Session";
            if (CONFIG.getProperty("sessiontree.name") != null) {
                sessionTreeName = CONFIG.getProperty("sessiontree.name");
            }
            if (sessionTreeSlot == null) {
                sessionTreeSlot = "left";
            }
            this.putItemInSlot(sessionTreeSlot, sessionTreeName, "aibench.sessiontree", sessionTreeSP);
        }
        if ((clipboardTreeVisible = CONFIG.getProperty("clipboardtree.visible")) == null || !clipboardTreeVisible.equals("false")) {
            JScrollPane clipboardTreeSP = new JScrollPane(this.getTreeManager().getAIBenchClipboardTree());
            clipboardTreeSP.setPreferredSize(new Dimension(200, 200));
            String clipboardTreeSlot = CONFIG.getProperty("clipboardtree.slot");
            String clipboardTreeName = "Clipboard";
            if (CONFIG.getProperty("clipboardtree.name") != null) {
                clipboardTreeName = CONFIG.getProperty("clipboardtree.name");
            }
            if (clipboardTreeSlot == null) {
                clipboardTreeSlot = "right";
            }
            this.putItemInSlot(clipboardTreeSlot, clipboardTreeName, "aibench.clipboardtree", clipboardTreeSP);
        }
        if ((logAreaVisible = CONFIG.getProperty("logarea.visible")) == null || !logAreaVisible.equals("false")) {
            String logAreaSlot = CONFIG.getProperty("logarea.slot");
            if (logAreaSlot == null) {
                logAreaSlot = "bottom";
            }
            this.putItemInSlot(logAreaSlot, "Log", "aibench.log", this.createLogTextArea());
            if (CONFIG.getProperty("logarea.maxsize") != null) {
                try {
                    int maxSize;
                    TextAreaAppender.MAXSIZE = maxSize = Integer.parseInt(CONFIG.getProperty("logarea.maxsize"));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"logarea.maxsize should be integer");
                }
            }
        }
        if ((memoryVisible = CONFIG.getProperty("memorymonitor.visible")) == null || !memoryVisible.equals("false")) {
            String memorySlot = CONFIG.getProperty("memorymonitor.slot");
            if (memorySlot == null) {
                memorySlot = "bottom";
            }
            this.putItemInSlot(memorySlot, "Memory", "aibench.memory", new MemoryMonitor());
        }
    }

    private JComponent createLogTextArea() {
        JComponent logArea = TextAreaAppender.getGUIComponent();
        logArea.setPreferredSize(new Dimension(200, 100));
        return logArea;
    }

    private void createInputGUIMappings() {
        for (Extension extension : WorkbenchExtensionTools.getWorkbenchViewExtensions()) {
            for (PluginXmlNode node : extension.getExtensionXmlNode().getChildren()) {
                if (!node.getName().equals("gui-operation")) continue;
                String operationID = node.getAttribute("operation");
                String className = node.getAttribute("class");
                for (OperationWrapper wrapper : this.interceptedOperations) {
                    if (!wrapper.getOperationDefinition().getID().equals(operationID)) continue;
                    try {
                        this.operationGUI.put(wrapper.getOperationDefinition(), extension.getPlugin().getPluginClassLoader().loadClass(className));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void createWelcomeScreen() {
        block4: for (Extension extension : WorkbenchExtensionTools.getWorkbenchViewExtensions()) {
            for (PluginXmlNode node : extension.getExtensionXmlNode().getChildren()) {
                String className;
                if (!node.getName().equals("welcomescreen") || (className = node.getAttribute("class")) == null) continue;
                String title = node.getAttribute("title");
                if (title == null) {
                    title = "Welcome screen";
                }
                try {
                    Class<?> extensionClass = extension.getPlugin().getPluginClassLoader().loadClass(className);
                    if (JComponent.class.isAssignableFrom(extensionClass)) {
                        try {
                            this.welcomeScreen = (JComponent)extensionClass.newInstance();
                            this.welcomeScreenTitle = title;
                            continue block4;
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            logger.warn((Object)(extensionClass + " can't be instantiated, ignoring extensiong point"));
                            continue;
                        }
                    }
                    logger.warn((Object)(extensionClass + " is not a JComponent, ignoring extensiong point"));
                }
                catch (ClassNotFoundException e) {
                    logger.warn((Object)(e.getMessage() + " ignoring extensiong point"));
                    continue block4;
                }
            }
        }
    }

    private void createViewFactories() {
        for (Extension extension : WorkbenchExtensionTools.getWorkbenchViewExtensions()) {
            for (PluginXmlNode node : extension.getExtensionXmlNode().getChildren()) {
                String className;
                if (!node.getName().equals("view") || (className = node.getAttribute("class")) == null) continue;
                try {
                    String iconAtt;
                    Class<?> extensionClass = extension.getPlugin().getPluginClassLoader().loadClass(className);
                    IViewFactory view = this.createViewFactory(extensionClass);
                    view.setPluginName(extension.getPlugin().getName());
                    view.setPluginUID(extension.getPlugin().getUID());
                    view.setViewName(node.getAttribute("name"));
                    view.setDataType(extension.getPlugin().getPluginClassLoader().loadClass(node.getAttribute("datatype")));
                    String helpAtt = node.getAttribute("help");
                    if (helpAtt != null) {
                        view.setHelp(helpAtt);
                    }
                    if ((iconAtt = node.getAttribute("icon")) != null) {
                        view.setViewIcon(new ImageIcon(extension.getPlugin().getPluginClassLoader().getResource(iconAtt)));
                    }
                    try {
                        view.setViewPreferredPosition(Integer.parseInt(node.getAttribute("order")));
                    }
                    catch (NumberFormatException e) {
                        view.setViewPreferredPosition(0);
                    }
                    if (view.getDataType() == null) continue;
                    List<IViewFactory> availableViewsForType = this.dataTypeViews.get(view.getDataType());
                    if (availableViewsForType == null) {
                        this.dataTypeViews.put(view.getDataType(), new ArrayList());
                    }
                    this.dataTypeViews.get(view.getDataType()).add(view);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private IViewFactory createViewFactory(Class<?> viewExtensionInstance) {
        return new IViewFactoryImpl(viewExtensionInstance);
    }

    private InputGUI getInputGUI(OperationDefinition<?> operation) {
        Class<?> c = this.operationGUI.get(operation);
        if (c != null) {
            try {
                return (InputGUI)c.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return new ParamsWindow();
    }

    private static void readConfig() {
        try {
            String path = System.getProperty("aibench.paths.workbench.conf", "conf/workbench.conf");
            CONFIG.load(Util.getGlobalResourceURL((String)path).openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Workbench.readConfig();
    }

    private class IViewFactoryImpl
    extends AbstractViewFactory {
        private Class<?> extensionClass;

        public IViewFactoryImpl(Class<?> extensionClass) {
            if (JComponent.class.isAssignableFrom(extensionClass)) {
                this.extensionClass = extensionClass;
            } else {
                System.err.println(extensionClass + "is not a JComponent");
                System.exit(0);
            }
        }

        @Override
        public JComponent getComponent(Object data) {
            Object extensionInstance = null;
            try {
                try {
                    for (Constructor<?> c : this.extensionClass.getConstructors()) {
                        if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(data.getClass())) continue;
                        extensionInstance = c.newInstance(data);
                    }
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (extensionInstance == null) {
                    extensionInstance = this.extensionClass.newInstance();
                }
                for (Field field : this.extensionClass.getDeclaredFields()) {
                    Data dataAnnotation = field.getAnnotation(Data.class);
                    if (dataAnnotation == null) continue;
                    try {
                        BeanInfo info = Introspector.getBeanInfo(extensionInstance.getClass());
                        for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                            if (!desc.getName().equals(field.getName())) continue;
                            Method setMethod = desc.getWriteMethod();
                            setMethod.invoke(extensionInstance, data);
                        }
                    }
                    catch (IntrospectionException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                final JComponent componentExtensionIntance = (JComponent)extensionInstance;
                componentExtensionIntance.putClientProperty(Workbench.AIBENCH_HELP_PROPERTY, this.help);
                if (Boolean.parseBoolean(Core.CONFIG.getProperty("help.enabled", "false"))) {
                    final ComponentAdapter adapter = new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent e) {
                            Container container;
                            Frame parentFrame = Utilities.getParentFrame(componentExtensionIntance);
                            if (parentFrame instanceof JFrame && (container = ((JFrame)parentFrame).getContentPane()) instanceof JComponent) {
                                JComponent containerComponent = (JComponent)container;
                                if (IViewFactoryImpl.this.help != null && !IViewFactoryImpl.this.help.trim().equals("")) {
                                    containerComponent.putClientProperty(Workbench.AIBENCH_HELP_PROPERTY, IViewFactoryImpl.this.help);
                                } else {
                                    containerComponent.putClientProperty(Workbench.AIBENCH_HELP_PROPERTY, null);
                                }
                            }
                        }
                    };
                    componentExtensionIntance.addAncestorListener(new AncestorListener(){

                        @Override
                        public void ancestorAdded(AncestorEvent event) {
                            for (ComponentListener listener : (ComponentListener[])event.getAncestor().getListeners(ComponentListener.class)) {
                                if (listener == adapter) break;
                            }
                            event.getAncestor().addComponentListener(adapter);
                            if (event.getAncestor().isVisible()) {
                                adapter.componentShown(null);
                            }
                        }

                        @Override
                        public void ancestorMoved(AncestorEvent event) {
                        }

                        @Override
                        public void ancestorRemoved(AncestorEvent event) {
                        }
                    });
                }
                return componentExtensionIntance;
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            return null;
        }

        @Override
        public Class<?> getComponentClass() {
            return this.extensionClass;
        }
    }
}

