/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.tests;

import es.uvigo.ei.sing.math.ArrayUtils;
import es.uvigo.ei.sing.math.statistical.tests.AbstractTestOfIndependence;
import es.uvigo.ei.sing.math.statistical.tests.TestOfIndependence;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.inference.TestUtils;

public class CachedRandomizationTestOfIndependence
extends AbstractTestOfIndependence
implements TestOfIndependence {
    private static final long serialVersionUID = 1L;
    public static final String KEY_CACHE_FILE = "peptideanalysis.toi.randomization.cache_file";
    public static final String KEY_CACHE_SAVE_INTERVAL = "peptideanalysis.toi.randomization.cache_save_interval";
    public static final String KEY_CACHE_SAVE_TIME_INTERVAL = "peptideanalysis.toi.randomization.cache_save_time_interval";
    public static final String KEY_NUMBER_OF_THREADS = "peptideanalysis.toi.randomization.threads";
    public static final String KEY_NUMBER_OF_SIMULATIONS = "peptideanalysis.toi.randomization.simulations";
    private static final int CACHE_FILE_SAVE_INTERVAL;
    private static final int CACHE_FILE_SAVE_TIME_INTERVAL;
    protected static final Map<KeyInt, Double> CACHE_PVALUE;
    protected static final Map<KeyLong, Double> CACHE_CHI;
    protected static final AtomicInteger INTERVAL;
    protected static final CacheStoreTask CACHE_STORE_TASK;
    public static final long DEFAULT_SEED = 133337L;
    public static final int DEFAULT_SIMULATIONS = 10000;
    private static final int SHUFFLE_TIMES = 20;
    private int simulations;
    private long seed;
    private int shuffleTimes;

    static {
        ConcurrentHashMap<KeyLong, Double> cacheChi;
        ConcurrentHashMap<KeyInt, Double> cachePValue;
        block18: {
            INTERVAL = new AtomicInteger(Integer.MIN_VALUE);
            CACHE_FILE_SAVE_INTERVAL = Integer.parseInt(System.getProperty(KEY_CACHE_SAVE_INTERVAL, Integer.toString(Integer.MAX_VALUE)));
            CACHE_FILE_SAVE_TIME_INTERVAL = Integer.parseInt(System.getProperty(KEY_CACHE_SAVE_TIME_INTERVAL, "0"));
            String cache = System.getProperty(KEY_CACHE_FILE);
            if (cache == null || !new File(cache).isFile()) {
                cachePValue = new ConcurrentHashMap<KeyInt, Double>();
                cacheChi = new ConcurrentHashMap<KeyLong, Double>();
            } else {
                ObjectInputStream ois = null;
                try {
                    try {
                        ois = new ObjectInputStream(new FileInputStream(cache));
                        cachePValue = new ConcurrentHashMap((Map)ois.readObject());
                        cacheChi = new ConcurrentHashMap((Map)ois.readObject());
                    }
                    catch (Exception e) {
                        cachePValue = new ConcurrentHashMap();
                        cacheChi = new ConcurrentHashMap();
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        CACHE_PVALUE = cachePValue;
        CACHE_CHI = cacheChi;
        if (CACHE_FILE_SAVE_TIME_INTERVAL > 0) {
            CACHE_STORE_TASK = new CacheStoreTask();
            new Thread(CACHE_STORE_TASK).start();
        } else {
            CACHE_STORE_TASK = null;
        }
    }

    protected static final boolean isCacheEnabled() {
        return System.getProperties().containsKey(KEY_CACHE_FILE);
    }

    protected static final String getCacheFilePath() {
        return System.getProperty(KEY_CACHE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void addToPValueCache(int[][] counts, Double pValue) {
        if (CachedRandomizationTestOfIndependence.isCacheEnabled() && INTERVAL.incrementAndGet() % CACHE_FILE_SAVE_INTERVAL == 0) {
            Map<KeyInt, Double> map = CACHE_PVALUE;
            synchronized (map) {
                Map<KeyLong, Double> map2 = CACHE_CHI;
                synchronized (map2) {
                    CACHE_PVALUE.put(new KeyInt(counts), pValue);
                    CachedRandomizationTestOfIndependence.storeCacheAndClearPosposeTimeInterval();
                }
            }
        }
        Map<KeyInt, Double> map = CACHE_PVALUE;
        synchronized (map) {
            CACHE_PVALUE.put(new KeyInt(counts), pValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Double getFromPValueCache(int[][] counts) {
        Map<KeyInt, Double> map = CACHE_PVALUE;
        synchronized (map) {
            return CACHE_PVALUE.get(new KeyInt(counts));
        }
    }

    protected static final boolean isInPValueCache(int[][] counts) {
        return CACHE_PVALUE.containsKey(new KeyInt(counts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearPValueCache() {
        Map<KeyInt, Double> map = CACHE_PVALUE;
        synchronized (map) {
            CACHE_PVALUE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void addToChiCache(long[][] counts, Double chiValue) {
        if (CachedRandomizationTestOfIndependence.isCacheEnabled() && INTERVAL.incrementAndGet() % CACHE_FILE_SAVE_INTERVAL == 0) {
            Map<KeyInt, Double> map = CACHE_PVALUE;
            synchronized (map) {
                Map<KeyLong, Double> map2 = CACHE_CHI;
                synchronized (map2) {
                    CACHE_CHI.put(new KeyLong(counts), chiValue);
                    CachedRandomizationTestOfIndependence.storeCacheAndClearPosposeTimeInterval();
                }
            }
        }
        Map<KeyLong, Double> map = CACHE_CHI;
        synchronized (map) {
            CACHE_CHI.put(new KeyLong(counts), chiValue);
        }
    }

    protected static final Double getFromChiCache(long[][] counts) {
        return CACHE_CHI.get(new KeyLong(counts));
    }

    protected static final boolean isInChiCache(long[][] counts) {
        return CACHE_CHI.containsKey(new KeyLong(counts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearChiCache() {
        Map<KeyLong, Double> map = CACHE_CHI;
        synchronized (map) {
            CACHE_CHI.clear();
        }
    }

    protected static double calculateChiSquared(long[][] inputCounts) {
        long[][] counts = CachedRandomizationTestOfIndependence.copy(inputCounts);
        CachedRandomizationTestOfIndependence.sort(counts);
        Double chiSquared = CachedRandomizationTestOfIndependence.getFromChiCache(counts);
        if (chiSquared == null) {
            double chi = TestUtils.chiSquare((long[][])counts);
            CachedRandomizationTestOfIndependence.addToChiCache(counts, chi);
            return chi;
        }
        return chiSquared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void storeCacheAndClearPosposeTimeInterval() {
        Map<KeyInt, Double> map = CACHE_PVALUE;
        synchronized (map) {
            Map<KeyLong, Double> map2 = CACHE_CHI;
            synchronized (map2) {
                if (CACHE_STORE_TASK != null) {
                    CACHE_STORE_TASK.pause();
                }
                CachedRandomizationTestOfIndependence.storeCache();
                if (CACHE_STORE_TASK != null) {
                    CACHE_STORE_TASK.pospose();
                    CACHE_STORE_TASK.resume();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void storeCacheAndClearInterval() {
        Map<KeyInt, Double> map = CACHE_PVALUE;
        synchronized (map) {
            Map<KeyLong, Double> map2 = CACHE_CHI;
            synchronized (map2) {
                INTERVAL.set(0);
                CachedRandomizationTestOfIndependence.storeCache();
            }
        }
    }

    protected static void storeCache() {
        block12: {
            ObjectOutputStream oos = null;
            try {
                try {
                    oos = new ObjectOutputStream(new FileOutputStream(CachedRandomizationTestOfIndependence.getCacheFilePath()));
                    oos.writeObject(CACHE_PVALUE);
                    oos.writeObject(CACHE_CHI);
                }
                catch (Exception exception) {
                    if (oos == null) break block12;
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public CachedRandomizationTestOfIndependence() {
        this(Integer.parseInt(System.getProperty(KEY_NUMBER_OF_SIMULATIONS, Integer.toString(10000))), 20, 133337L);
    }

    public CachedRandomizationTestOfIndependence(int simulations) {
        this(simulations, 20, 133337L);
    }

    public CachedRandomizationTestOfIndependence(int simulations, int shuffleTimes, long seed) {
        this.simulations = simulations;
        this.shuffleTimes = shuffleTimes;
        this.seed = seed;
    }

    public int getSimulations() {
        return this.simulations;
    }

    public void setSimulations(int simulations) {
        this.simulations = simulations;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public int getShuffleTimes() {
        return this.shuffleTimes;
    }

    public void setShuffleTimes(int shuffleTimes) {
        this.shuffleTimes = shuffleTimes;
    }

    @Override
    public double test(int[][] inputCounts) throws InterruptedException {
        int[][] counts = CachedRandomizationTestOfIndependence.copy(inputCounts);
        CachedRandomizationTestOfIndependence.sort(counts);
        if (CachedRandomizationTestOfIndependence.isInPValueCache(counts)) {
            return CachedRandomizationTestOfIndependence.getFromPValueCache(counts);
        }
        Random random = new Random(this.seed);
        double chiValue = CachedRandomizationTestOfIndependence.calculateChiSquared(ArrayUtils.intToLong(counts));
        ExecutorService executor = Executors.newFixedThreadPool(Integer.getInteger(KEY_NUMBER_OF_THREADS, 1));
        try {
            if (Double.isNaN(chiValue)) {
                CachedRandomizationTestOfIndependence.addToPValueCache(counts, Double.NaN);
                return Double.NaN;
            }
            AtomicLong equalsOrGreaterCounter = new AtomicLong(0L);
            int i = 0;
            while (i < this.simulations) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                executor.execute(new TestTask(chiValue, equalsOrGreaterCounter, counts, this.shuffleTimes, random.nextLong()));
                ++i;
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            double pValue = equalsOrGreaterCounter.doubleValue() / (double)this.simulations;
            CachedRandomizationTestOfIndependence.addToPValueCache(counts, pValue);
            double d = pValue;
            return d;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static long[][] generateRandom(int[][] counts, int shuffleTimes, long seed) {
        if (Thread.interrupted()) {
            return null;
        }
        ArrayList<Boolean> presenceAbsence = new ArrayList<Boolean>();
        int i = 0;
        while (i < counts[0].length) {
            long j = 0L;
            while (j < (long)counts[0][i]) {
                presenceAbsence.add(Boolean.FALSE);
                ++j;
            }
            j = 0L;
            while (j < (long)counts[1][i]) {
                presenceAbsence.add(Boolean.TRUE);
                ++j;
            }
            ++i;
        }
        if (Thread.interrupted()) {
            return null;
        }
        Random shuffleRandom = new Random(seed);
        int i2 = 0;
        while (i2 < shuffleTimes) {
            Collections.shuffle(presenceAbsence, shuffleRandom);
            ++i2;
        }
        if (Thread.interrupted()) {
            return null;
        }
        long[][] randomCounts = new long[2][counts[0].length];
        int i3 = 0;
        while (i3 < counts[0].length) {
            long numSamples = counts[0][i3] + counts[1][i3];
            long j = 0L;
            while (j < numSamples) {
                Boolean isPresence = (Boolean)presenceAbsence.remove(presenceAbsence.size() - 1);
                long[] lArray = randomCounts[isPresence != false ? 1 : 0];
                int n = i3;
                lArray[n] = lArray[n] + 1L;
                ++j;
            }
            ++i3;
        }
        if (Thread.interrupted()) {
            return null;
        }
        return randomCounts;
    }

    private static long[][] copy(long[][] data) {
        long[][] copy = new long[data.length][];
        int i = 0;
        while (i < data.length) {
            copy[i] = new long[data[i].length];
            System.arraycopy(data[i], 0, copy[i], 0, data[i].length);
            ++i;
        }
        return copy;
    }

    private static int[][] copy(int[][] data) {
        int[][] copy = new int[data.length][];
        int i = 0;
        while (i < data.length) {
            copy[i] = new int[data[i].length];
            System.arraycopy(data[i], 0, copy[i], 0, data[i].length);
            ++i;
        }
        return copy;
    }

    private static void sort(long[][] data) {
        int i = 0;
        while (i < data[0].length - 1) {
            int j = i + 1;
            while (j < data[0].length) {
                boolean exchange = false;
                int k = 0;
                while (k < data.length) {
                    int cmp = Long.compare(data[k][i], data[k][j]);
                    if (cmp < 0) break;
                    if (cmp > 0) {
                        exchange = true;
                        break;
                    }
                    ++k;
                }
                if (exchange) {
                    k = 0;
                    while (k < data.length) {
                        long tmp = data[k][i];
                        data[k][i] = data[k][j];
                        data[k][j] = tmp;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void sort(int[][] data) {
        int i = 0;
        while (i < data[0].length - 1) {
            int j = i + 1;
            while (j < data[0].length) {
                boolean exchange = false;
                int k = 0;
                while (k < data.length) {
                    int cmp = Integer.compare(data[k][i], data[k][j]);
                    if (cmp < 0) break;
                    if (cmp > 0) {
                        exchange = true;
                        break;
                    }
                    ++k;
                }
                if (exchange) {
                    k = 0;
                    while (k < data.length) {
                        int tmp = data[k][i];
                        data[k][i] = data[k][j];
                        data[k][j] = tmp;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected static class CacheStoreTask
    implements Runnable {
        private AtomicLong nextUpdate = CachedRandomizationTestOfIndependence.access$0() > 0 ? new AtomicLong(System.currentTimeMillis() + (long)(CachedRandomizationTestOfIndependence.access$0() * 1000)) : null;
        private volatile boolean pause = false;

        public void pospose() {
            if (this.nextUpdate != null) {
                this.nextUpdate.set(System.currentTimeMillis() + (long)(CACHE_FILE_SAVE_TIME_INTERVAL * 1000));
            }
        }

        public synchronized void pause() {
            this.pause = true;
        }

        public synchronized void resume() {
            this.pause = false;
            this.notifyAll();
        }

        private synchronized void waitIfPause() {
            if (this.pause) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void run() {
            if (this.nextUpdate != null) {
                while (true) {
                    if (System.currentTimeMillis() < this.nextUpdate.get()) {
                        try {
                            Thread.sleep(this.nextUpdate.get() - System.currentTimeMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.waitIfPause();
                    CachedRandomizationTestOfIndependence.storeCacheAndClearInterval();
                    this.pospose();
                }
            }
        }
    }

    protected static final class KeyInt
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[][] value;
        private final int hashCode;

        public KeyInt(int[][] value) {
            this.value = value;
            this.hashCode = Arrays.deepHashCode((Object[])this.value);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof KeyInt) {
                return Arrays.deepEquals((Object[])this.value, (Object[])((KeyInt)object).value);
            }
            return super.equals(object);
        }
    }

    protected static final class KeyLong
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long[][] value;
        private final int hashCode;

        public KeyLong(long[][] value) {
            this.value = value;
            this.hashCode = Arrays.deepHashCode((Object[])this.value);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof KeyLong) {
                return Arrays.deepEquals((Object[])this.value, (Object[])((KeyLong)object).value);
            }
            return super.equals(object);
        }
    }

    private static final class TestTask
    implements Runnable {
        private final double chiValue;
        private final AtomicLong equalsOrGreaterCounter;
        private final int[][] counts;
        private final int shuffleTimes;
        private final long seed;

        public TestTask(double chiValue, AtomicLong equalsOrGreaterCounter, int[][] counts, int shuffleTimes, long seed) {
            this.chiValue = chiValue;
            this.equalsOrGreaterCounter = equalsOrGreaterCounter;
            this.counts = counts;
            this.shuffleTimes = shuffleTimes;
            this.seed = seed;
        }

        @Override
        public void run() {
            double randomChiValue;
            long[][] randomSamples = CachedRandomizationTestOfIndependence.generateRandom(this.counts, this.shuffleTimes, this.seed);
            if (randomSamples != null && (randomChiValue = CachedRandomizationTestOfIndependence.calculateChiSquared(randomSamples)) >= this.chiValue) {
                this.equalsOrGreaterCounter.incrementAndGet();
            }
        }
    }
}

