/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.components;

import es.uvigo.ei.sing.s2p.gui.components.ButtonTabComponent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ExtendedJTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private boolean hideTabBarWhenSingleTab = false;
    private LayoutManager defaultLayout;

    public void setHideTabBarWhenSingleTab(boolean hide) {
        if (this.hideTabBarWhenSingleTab != hide) {
            this.hideTabBarWhenSingleTab = hide;
            this.defaultLayout = this.getLayout();
            this.updateLayout();
        }
    }

    private void updateLayout() {
        this.setLayout(this.getProperLayout());
    }

    private LayoutManager getProperLayout() {
        if (this.getTabCount() == 1 && this.hideTabBarWhenSingleTab) {
            return new CardLayout();
        }
        return this.defaultLayout;
    }

    public void addTab(String title, Component component, boolean closeable) {
        super.addTab(title, component);
        if (closeable) {
            this.addCloseButton(component);
        }
        this.updateLayout();
    }

    private void addCloseButton(Component component) {
        super.setTabComponentAt(super.indexOfComponent(component), new ButtonTabComponent(this));
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, false);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        this.updateLayout();
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        this.updateLayout();
    }

    @Override
    public void removeTabAt(int index) {
        super.removeTabAt(index);
        this.updateLayout();
    }
}

