/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dtd.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.ContentModelValidator;
import com.sun.org.apache.xerces.internal.xni.QName;

public class MixedContentModel
implements ContentModelValidator {
    private int fCount;
    private QName[] fChildren;
    private int[] fChildrenType;
    private boolean fOrdered;

    public MixedContentModel(QName[] children, int[] type, int offset, int length, boolean ordered) {
        this.fCount = length;
        this.fChildren = new QName[this.fCount];
        this.fChildrenType = new int[this.fCount];
        for (int i = 0; i < this.fCount; ++i) {
            this.fChildren[i] = new QName(children[offset + i]);
            this.fChildrenType[i] = type[offset + i];
        }
        this.fOrdered = ordered;
    }

    @Override
    public int validate(QName[] children, int offset, int length) {
        if (this.fOrdered) {
            int inIndex = 0;
            for (int outIndex = 0; outIndex < length; ++outIndex) {
                String uri;
                QName curChild = children[offset + outIndex];
                if (curChild.localpart == null) continue;
                int type = this.fChildrenType[inIndex];
                if (type == 0 ? this.fChildren[inIndex].rawname != children[offset + outIndex].rawname : (type == 6 ? (uri = this.fChildren[inIndex].uri) != null && uri != children[outIndex].uri : (type == 8 ? children[outIndex].uri != null : type == 7 && this.fChildren[inIndex].uri == children[outIndex].uri))) {
                    return outIndex;
                }
                ++inIndex;
            }
        } else {
            for (int outIndex = 0; outIndex < length; ++outIndex) {
                String uri;
                int type;
                int inIndex;
                QName curChild = children[offset + outIndex];
                if (curChild.localpart == null) continue;
                for (inIndex = 0; inIndex < this.fCount && !((type = this.fChildrenType[inIndex]) == 0 ? curChild.rawname == this.fChildren[inIndex].rawname : (type == 6 ? (uri = this.fChildren[inIndex].uri) == null || uri == children[outIndex].uri : (type == 8 ? children[outIndex].uri == null : type == 7 && this.fChildren[inIndex].uri != children[outIndex].uri))); ++inIndex) {
                }
                if (inIndex != this.fCount) continue;
                return outIndex;
            }
        }
        return -1;
    }
}

