/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.visualization;

import es.uvigo.ei.sing.hlfernandez.ui.icons.ColorIcon;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorLegend
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Map<String, Color> colors;
    private Orientation orientation;

    public ColorLegend(Map<String, Color> colors) {
        this(colors, Orientation.HORIZONTAL);
    }

    public ColorLegend(Map<String, Color> colors, Orientation orientation) {
        this.colors = colors;
        this.orientation = orientation;
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(this.getNumRows(), this.getNumColumns()));
        this.colors.forEach((label, color) -> this.add(this.createLabel((String)label, (Color)color)));
    }

    private JLabel createLabel(String text, Color color) {
        JLabel label = new JLabel(text, new ColorIcon(16, 16, color), 2);
        if (this.isHorizontal()) {
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
        return label;
    }

    private int getNumColumns() {
        return this.isHorizontal() ? this.colors.size() : 0;
    }

    private boolean isHorizontal() {
        return this.orientation.equals((Object)Orientation.HORIZONTAL);
    }

    private int getNumRows() {
        return this.isHorizontal() ? 0 : this.colors.size();
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

