/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations;

import java.util.HashSet;
import java.util.Set;

public class StringSetComparison {
    private Set<String> set1;
    private Set<String> set2;
    private Set<String> intersection;
    private int set1Size;
    private int set2Size;
    private int intersectionSize;

    public StringSetComparison(Set<String> set1, Set<String> set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.initData();
    }

    private void initData() {
        this.intersection = new HashSet<String>(this.set1);
        this.intersection.retainAll(this.set2);
        this.intersectionSize = this.intersection.size();
        this.set1Size = this.set1.size();
        this.set2Size = this.set2.size();
    }

    public Set<String> getSet1() {
        return this.set1;
    }

    public Set<String> getSet1Unique() {
        return this.unique(this.set1);
    }

    private Set<String> unique(Set<String> set) {
        HashSet<String> unique = new HashSet<String>(set);
        unique.removeAll(this.intersection);
        return unique;
    }

    public Set<String> getSet2() {
        return this.set2;
    }

    public Set<String> getSet2Unique() {
        return this.unique(this.set2);
    }

    public Set<String> getIntersection() {
        return this.intersection;
    }

    public int getSet1Size() {
        return this.set1Size;
    }

    public int getSet1UniqueSize() {
        return this.set1Size - this.intersectionSize;
    }

    public int getSet2Size() {
        return this.set2Size;
    }

    public int getSet2UniqueSize() {
        return this.set2Size - this.intersectionSize;
    }

    public int getIntersectionSize() {
        return this.intersectionSize;
    }
}

