/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.AbstractRadioPropertyGroup;
import com.sun.deploy.panel.AndOrRadioPropertyGroup;
import com.sun.deploy.panel.ITreeNode;
import com.sun.deploy.panel.PropertyTreeModel;
import com.sun.deploy.panel.RadioProperty;
import com.sun.deploy.panel.RadioPropertyGroup;
import com.sun.deploy.panel.SimpleTreeNode;
import com.sun.deploy.panel.TextFieldProperty;
import com.sun.deploy.panel.ToggleProperty;
import com.sun.deploy.panel.TreeBuilder;
import com.sun.deploy.resources.ResourceManager;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTree;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class XMLDocumentHandler
extends DefaultHandler {
    private ArrayList elementStack = new ArrayList();
    private boolean addNode = true;

    XMLDocumentHandler() {
    }

    public void startDocument() throws SAXException {
        SimpleTreeNode simpleTreeNode = new SimpleTreeNode(this.getMessage("common.settings"));
        this.elementStack.add(0, simpleTreeNode);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("label")) {
            if (this.getShouldAdd()) {
                SimpleTreeNode simpleTreeNode = new SimpleTreeNode(attributes.getValue("text"));
                ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
                iTreeNode.addChildNode(simpleTreeNode);
                this.elementStack.add(0, simpleTreeNode);
            }
        } else if (string3.equalsIgnoreCase("checkbox")) {
            if (this.getShouldAdd()) {
                ToggleProperty toggleProperty = new ToggleProperty(attributes.getValue("propertyName"), attributes.getValue("checked"));
                toggleProperty.setDisabledProperty(attributes.getValue("disabledProperty"), attributes.getValue("disabledValue"));
                ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
                iTreeNode.addProperty(toggleProperty);
            }
        } else if (string3.equalsIgnoreCase("radiogroup")) {
            if (this.getShouldAdd()) {
                RadioPropertyGroup radioPropertyGroup = new RadioPropertyGroup(attributes.getValue("propertyName"), attributes.getValue("checked"));
                radioPropertyGroup.setDisabledProperty(attributes.getValue("disabledProperty"), attributes.getValue("disabledValue"));
                this.elementStack.add(0, radioPropertyGroup);
            }
        } else if (string3.equalsIgnoreCase("and_or_radiogroup")) {
            if (this.getShouldAdd()) {
                AndOrRadioPropertyGroup andOrRadioPropertyGroup = new AndOrRadioPropertyGroup(attributes.getValue("propertyName"), attributes.getValue("checked"), attributes.getValue("aProperty"), attributes.getValue("bProperty"));
                andOrRadioPropertyGroup.setDisabledProperty(attributes.getValue("disabledProperty"), attributes.getValue("disabledValue"));
                this.elementStack.add(0, andOrRadioPropertyGroup);
            }
        } else if (string3.equalsIgnoreCase("rButton")) {
            if (this.getShouldAdd()) {
                String string4 = attributes.getValue("text");
                AbstractRadioPropertyGroup abstractRadioPropertyGroup = (AbstractRadioPropertyGroup)this.elementStack.remove(0);
                String string5 = abstractRadioPropertyGroup.getPropertyName();
                RadioProperty radioProperty = new RadioProperty(string5, string4);
                radioProperty.setGroup(abstractRadioPropertyGroup);
                ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
                iTreeNode.addProperty(radioProperty);
                this.elementStack.add(0, abstractRadioPropertyGroup);
            }
        } else if (string3.equalsIgnoreCase("TextField")) {
            if (this.getShouldAdd()) {
                String string6 = attributes.getValue("propertyName");
                TextFieldProperty textFieldProperty = new TextFieldProperty(string6, "");
                ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
                iTreeNode.addProperty(textFieldProperty);
            }
        } else if (string3.equalsIgnoreCase("platform")) {
            String string7 = attributes.getValue("text");
            String string8 = attributes.getValue("exclude");
            boolean bl = false;
            if (string8 != null && string8.equals("true")) {
                bl = true;
            }
            String string9 = attributes.getValue("arch");
            Vector<String> vector = new Vector<String>();
            if (string7.indexOf(",") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string10 = stringTokenizer.nextToken();
                    vector.add(string10.trim());
                }
            } else {
                vector.add(string7.trim());
            }
            if (this.isNotValidForVersion(attributes)) {
                this.elementStack.add(0, string7);
                this.addNode = false;
            } else if (bl) {
                if (!this.setShouldAddIfNotInList(vector, string9)) {
                    this.elementStack.add(0, string7);
                }
            } else if (!this.setShouldAdd(vector, string9)) {
                this.elementStack.add(0, string7);
            }
        } else if (string3.equalsIgnoreCase("permission")) {
            String string11 = attributes.getValue("text");
            if (this.isNotValidForVersion(attributes)) {
                this.addNode = false;
            }
            if (string11.indexOf("admin") != -1 && !Platform.get().hasAdminPrivileges()) {
                this.addNode = false;
            }
            if (!this.addNode) {
                this.elementStack.add(0, string11);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("label")) {
            if (this.getShouldAdd()) {
                this.elementStack.remove(0);
            }
        } else if (string3.equalsIgnoreCase("radiogroup")) {
            if (this.getShouldAdd()) {
                this.elementStack.remove(0);
            }
        } else if (string3.equalsIgnoreCase("and_or_radiogroup")) {
            if (this.getShouldAdd()) {
                this.elementStack.remove(0);
            }
        } else if (string3.equalsIgnoreCase("platform")) {
            if (!this.getShouldAdd()) {
                this.elementStack.remove(0);
            }
            this.addNode = true;
        } else if (string3.equalsIgnoreCase("permission")) {
            if (!this.getShouldAdd()) {
                this.elementStack.remove(0);
            }
            this.addNode = true;
        }
    }

    private boolean getShouldAdd() {
        return this.addNode;
    }

    private boolean setShouldAdd(Vector vector, String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = ((String)vector.get(i)).toLowerCase();
            if (string4.indexOf("gnome") != -1 && Platform.get().isLocalInstallSupported()) {
                this.addNode = true;
                break;
            }
            if (string != null) {
                if (string2.indexOf(string4) != -1 && string3.equals(string)) {
                    this.addNode = true;
                    break;
                }
            } else if (string2.indexOf(string4) != -1) {
                this.addNode = true;
                break;
            }
            this.addNode = false;
        }
        return this.addNode;
    }

    private boolean setShouldAddIfNotInList(Vector vector, String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = ((String)vector.get(i)).toLowerCase();
            if (string != null) {
                if (string2.indexOf(string4) != -1 && string3.equals(string)) {
                    this.addNode = false;
                    break;
                }
            } else if (string2.indexOf(string4) != -1) {
                this.addNode = false;
                break;
            }
            this.addNode = true;
        }
        return this.addNode;
    }

    public void endDocument() throws SAXException {
        ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("Error: " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        System.err.println("FatalError: " + sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("Warning: " + sAXParseException);
    }

    JTree getJTree() {
        ITreeNode iTreeNode = (ITreeNode)this.elementStack.get(0);
        JTree jTree = TreeBuilder.createTree(new PropertyTreeModel(iTreeNode));
        jTree.setFont(ResourceManager.getUIFont());
        return jTree;
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private boolean isNotValidForVersion(Attributes attributes) {
        String string = attributes.getValue("ifLessThanJDK8");
        boolean bl = false;
        if (string != null && string.equals("true")) {
            bl = true;
        }
        boolean bl2 = Config.isDeployVersionAtLeast11();
        return bl && bl2;
    }
}

