/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.input;

import es.uvigo.ei.sing.hlfernandez.input.InputParameter;
import es.uvigo.ei.sing.hlfernandez.ui.icons.Icons;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InputParametersPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<InputParameter> parameters;
    private Map<InputParameter, JComponent> descriptionLabels;
    private Map<InputParameter, JComponent> inputComponents;
    private Map<InputParameter, JComponent> helpLabels;

    public InputParametersPanel(InputParameter ... parameters) {
        this.parameters = Arrays.asList(parameters);
        this.initComponent();
    }

    private void initComponent() {
        this.initInputComponents();
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        this.setLayout(groupLayout);
        GroupLayout.SequentialGroup horizontalGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup first = groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup second = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup third = groupLayout.createParallelGroup();
        this.parameters.forEach(c -> {
            first.addComponent(this.descriptionLabels.get(c));
            second.addComponent(this.inputComponents.get(c));
            third.addComponent(this.helpLabels.get(c));
        });
        horizontalGroup.addGroup(first).addGroup(second).addGroup(third);
        groupLayout.setHorizontalGroup(horizontalGroup);
        GroupLayout.SequentialGroup verticalGroup = groupLayout.createSequentialGroup();
        this.parameters.forEach(c -> {
            GroupLayout.ParallelGroup current = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
            current.addComponent(this.descriptionLabels.get(c));
            current.addComponent(this.inputComponents.get(c));
            current.addComponent(this.helpLabels.get(c));
            verticalGroup.addGroup(current);
        });
        groupLayout.setVerticalGroup(verticalGroup);
    }

    private void initInputComponents() {
        this.descriptionLabels = new HashMap<InputParameter, JComponent>();
        this.inputComponents = new HashMap<InputParameter, JComponent>();
        this.helpLabels = new HashMap<InputParameter, JComponent>();
        this.parameters.forEach(c -> {
            this.descriptionLabels.put((InputParameter)c, new JLabel(c.getLabel()));
            this.inputComponents.put((InputParameter)c, c.getInput());
            JLabel helpLabel = new JLabel(Icons.ICON_INFO_2_16);
            helpLabel.setToolTipText(c.getHelpLabel());
            this.helpLabels.put((InputParameter)c, helpLabel);
        });
    }
}

