/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class TextAreaAppender
extends AppenderSkeleton {
    private static final Font DEBUGFont = new Font("monospaced", 1, 12);
    private static final Color DEBUGColor = Color.BLUE;
    private static final Font INFOFont = new Font("monospaced", 1, 12);
    private static final Color INFOColor = Color.GREEN;
    private static final Font WARNFont = new Font("monospaced", 1, 12);
    private static final Color WARNColor = new Color(255, 153, 51);
    private static final Font ERRORFont = new Font("monospaced", 1, 12);
    private static final Color ERRORColor = Color.RED;
    private static final Font FATALFont = new Font("monospaced", 1, 12);
    private static final Color FATALColor = Color.RED;
    private static LogTextArea _textArea;
    private static Color defaultColor;
    private static Font defaultFont;
    public static int MAXSIZE;

    public static JComponent getGUIComponent() {
        return _textArea;
    }

    public static void clearGUIComponent() {
        TextAreaAppender._textArea.clearLog();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    @Override
    protected void append(LoggingEvent arg0) {
        JTextPane pane = _textArea.jTextPane;
        Font f = defaultFont;
        Color c = defaultColor;
        if (pane != null) {
            this.layout.format(arg0);
            if (arg0.getLevel().equals(Level.DEBUG)) {
                f = DEBUGFont;
                c = DEBUGColor;
            } else if (arg0.getLevel().equals(Level.INFO)) {
                f = INFOFont;
                c = INFOColor;
            } else if (arg0.getLevel().equals(Level.WARN)) {
                f = WARNFont;
                c = WARNColor;
            } else if (arg0.getLevel().equals(Level.ERROR)) {
                f = ERRORFont;
                c = ERRORColor;
            } else if (arg0.getLevel().equals(Level.FATAL)) {
                f = FATALFont;
                c = FATALColor;
            }
            this.appendText(this.getLayout().format(arg0), f, c);
        }
    }

    private void appendText(String text, Font font, Color c) {
        JTextPane pane = _textArea.jTextPane;
        Document d = pane.getDocument();
        int oldPosition = d.getEndPosition().getOffset();
        try {
            d.insertString(oldPosition, text, null);
            MutableAttributeSet attrs = pane.getInputAttributes();
            StyleConstants.setFontFamily(attrs, font.getFamily());
            StyleConstants.setFontSize(attrs, font.getSize());
            StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
            StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
            StyleConstants.setForeground(attrs, c);
            StyledDocument doc = pane.getStyledDocument();
            doc.setCharacterAttributes(oldPosition, doc.getLength() + 1, attrs, false);
            pane.setCaretPosition(pane.getDocument().getLength());
            if (MAXSIZE > 0 && d.getLength() > MAXSIZE) {
                d.remove(0, d.getLength() - MAXSIZE);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    static {
        defaultColor = Color.BLACK;
        defaultFont = new Font("monospaced", 1, 12);
        MAXSIZE = -1;
        _textArea = new LogTextArea();
    }

    private static class LogTextArea
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JScrollPane jScrollPane = null;
        private JTextPane jTextPane = null;

        public LogTextArea() {
            this.initialize();
        }

        private JScrollPane getJScrollPane() {
            if (this.jScrollPane == null) {
                this.jScrollPane = new JScrollPane();
                this.jScrollPane.setViewportView(this.getJTextPane());
            }
            return this.jScrollPane;
        }

        private JTextPane getJTextPane() {
            if (this.jTextPane == null) {
                this.jTextPane = new JTextPane();
                this.jTextPane.setBackground(Color.LIGHT_GRAY);
                this.jTextPane.setEditable(false);
                this.jTextPane.setBackground(Color.BLACK);
                this.jTextPane.setComponentPopupMenu(this.createPopup());
            }
            return this.jTextPane;
        }

        private void clearLog() {
            this.jTextPane.setText("");
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            this.setSize(100, 200);
            this.add((Component)this.getJScrollPane(), "Center");
        }

        private JPopupMenu createPopup() {
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction("Clear log"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogTextArea.this.clearLog();
                }
            });
            return popup;
        }
    }
}

