/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io.samespots;

import es.uvigo.ei.sing.commons.csv.entities.CsvData;
import es.uvigo.ei.sing.commons.csv.entities.CsvEntry;
import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.commons.csv.io.CsvWriter;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.entities.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SameSpotsCsvWriter {
    public static void write(File tempFile, List<Sample> samples, CsvFormat csvFormat) throws IOException {
        SameSpotsCsvWriter.write(tempFile, samples, csvFormat, new HashMap<Sample, String>());
    }

    public static void write(File file, List<Sample> samples, CsvFormat csvFormat, Map<Sample, String> samplesConditions) throws IOException {
        CsvWriter csvWriter = CsvWriter.of((CsvFormat)csvFormat);
        CsvData data = SameSpotsCsvWriter.createData(samples, csvFormat, samplesConditions);
        csvWriter.write(data, file);
    }

    private static CsvData createData(List<Sample> samples, CsvFormat csvFormat, Map<Sample, String> samplesConditions) {
        ArrayList<CsvEntry> entries = new ArrayList<CsvEntry>();
        if (!samplesConditions.isEmpty()) {
            entries.add(SameSpotsCsvWriter.sampleConditions(samples, samplesConditions));
        }
        entries.add(SameSpotsCsvWriter.sampleNames(samples));
        Util.getProteins(samples).stream().sorted().forEach(p -> entries.add(SameSpotsCsvWriter.proteinValues(p, samples, csvFormat)));
        CsvData data = SameSpotsCsvWriter.createData(entries, csvFormat);
        return data;
    }

    private static CsvData createData(List<CsvEntry> entries, CsvFormat format) {
        return CsvData.CsvDataBuilder.newCsvDataBuilder((CsvFormat)format).withEntries(entries).build();
    }

    private static CsvEntry sampleNames(List<Sample> samples) {
        CsvEntry toret = SameSpotsCsvWriter.csvEntry(samples.stream().map(Sample::getName));
        toret.add(0, (Object)"");
        return toret;
    }

    public static CsvEntry csvEntry(Stream<String> stream) {
        return new CsvEntry((Collection)stream.collect(Collectors.toList()));
    }

    private static CsvEntry sampleConditions(List<Sample> samples, Map<Sample, String> sampleConditions) {
        CsvEntry toret = SameSpotsCsvWriter.csvEntry(samples.stream().map(sampleConditions::get));
        toret.add(0, (Object)"");
        return toret;
    }

    private static CsvEntry proteinValues(String spot, List<Sample> samples, CsvFormat csvFormat) {
        LinkedList<String> proteinValues = new LinkedList<String>();
        proteinValues.add(spot);
        for (Sample s : samples) {
            Double value = s.getSpotValues().getOrDefault(spot, Double.NaN);
            if (Double.isNaN(value)) {
                proteinValues.add("");
                continue;
            }
            proteinValues.add(csvFormat.getDecimalFormatter().format(value));
        }
        return SameSpotsCsvWriter.csvEntry(proteinValues.stream());
    }
}

