/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.io;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import es.uvigo.ei.sing.s2p.core.entities.MaldiPlate;
import es.uvigo.ei.sing.s2p.core.entities.MaldiPlateInformation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.stream.IntStream;

public class MaldiPlateWriter {
    private static final Font FONT = new Font(Font.FontFamily.COURIER, 10.0f);

    public static void toPdf(MaldiPlate plate, File f) throws FileNotFoundException, DocumentException {
        Document document = new Document(PageSize.A3.rotate(), 10.0f, 10.0f, 10.0f, 10.0f);
        document.setMargins(50.0f, 50.0f, 50.0f, 50.0f);
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(f));
        document.open();
        document.add(MaldiPlateWriter.getExperimentInfo(plate));
        document.add(MaldiPlateWriter.getPdfTable(plate));
        document.close();
    }

    private static Element getPdfTable(MaldiPlate plate) {
        PdfPTable table = new PdfPTable(plate.getColNames().size() + 1);
        table.setWidthPercentage(100.0f);
        MaldiPlateWriter.addHeader(table, plate);
        MaldiPlateWriter.addData(table, plate);
        return table;
    }

    private static void addHeader(PdfPTable table, MaldiPlate plate) {
        MaldiPlateWriter.addHeaderCell(table, "");
        plate.getColNames().forEach(c -> MaldiPlateWriter.addHeaderCell(table, c));
        table.setHeaderRows(1);
    }

    private static void addHeaderCell(PdfPTable table, String c) {
        Font font = new Font(FONT);
        font.setColor(BaseColor.WHITE);
        PdfPCell cell = new PdfPCell(new Phrase(c, font));
        cell.setBackgroundColor(BaseColor.BLACK);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
    }

    private static void addData(PdfPTable table, MaldiPlate plate) {
        IntStream.range(0, plate.getRowNames().size()).forEach(i -> MaldiPlateWriter.addRow(plate, table, i));
    }

    private static void addRow(MaldiPlate plate, PdfPTable table, int row) {
        MaldiPlateWriter.addHeaderCell(table, plate.getRowNames().get(row));
        IntStream.range(0, plate.getColNames().size()).forEach(column -> MaldiPlateWriter.addCell(plate, table, row, column));
    }

    private static void addCell(MaldiPlate plate, PdfPTable table, int row, int column) {
        String value = plate.getData()[row][column];
        table.addCell(new PdfPCell(new Phrase(value == null ? "" : value, FONT)));
    }

    private static Element getExperimentInfo(MaldiPlate plate) {
        MaldiPlateInformation info = plate.getInfo();
        String maldiTarget = info.getMaldiTarget().isPresent() ? info.getMaldiTarget().get().toString() : "";
        String sep = ": ";
        String fieldSep = "    ";
        StringBuilder infoSb = new StringBuilder();
        infoSb.append("User").append(sep).append(info.getUser()).append(fieldSep).append("Date").append(sep).append(info.getDate()).append(fieldSep).append("Type of sample").append(sep).append(info.getSampleType()).append("\n").append("Type of MALDI target").append(sep).append(maldiTarget).append(fieldSep).append("Mascot experiment").append(sep).append(info.getMascotExperiment());
        Paragraph toret = new Paragraph(infoSb.toString());
        toret.setSpacingAfter(10.0f);
        return toret;
    }

    public static void toFile(MaldiPlate plate, File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(plate);
        oos.close();
    }
}

