/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import es.uvigo.ei.aibench.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.platonos.pluginengine.Dependency;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.ExtensionPoint;
import org.platonos.pluginengine.PluginClassLoader;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginEngineException;
import org.platonos.pluginengine.PluginLifecycle;
import org.platonos.pluginengine.PluginXmlNode;
import org.platonos.pluginengine.event.PluginEngineEvent;
import org.platonos.pluginengine.event.PluginEngineEventType;
import org.platonos.pluginengine.logging.LoggerLevel;
import org.platonos.pluginengine.version.PluginInstanceVersion;
import org.platonos.pluginengine.version.PluginVersion;

public class Plugin
implements Comparable<Object> {
    private final boolean isArchive;
    private final URL pluginURL;
    private final PluginEngine pluginEngine;
    PluginClassLoader pluginClassloader;
    private final Map<String, ExtensionPoint> extensionPoints = new HashMap<String, ExtensionPoint>(5);
    private final List<Extension> extensions = new ArrayList<Extension>(8);
    private final Map<String, Dependency> dependencies = new HashMap<String, Dependency>(8);
    private final List<Plugin> dependentPlugins = new ArrayList<Plugin>(8);
    private String uid;
    private String name;
    private String lifecycleClassName;
    PluginLifecycle lifecycleInstance;
    private PluginXmlNode metadataXmlNode;
    private boolean isStarted = false;
    boolean isDisabled = false;
    boolean isActive = true;
    boolean isResolved = false;
    boolean isLoaded = false;
    private boolean startWhenResolved = false;
    private int startOrder = Integer.MAX_VALUE;
    private boolean dependentPluginLookup = false;
    private PluginVersion version = new PluginInstanceVersion();
    private final long constructionTime = System.currentTimeMillis();

    public Plugin(PluginEngine pluginEngine) {
        this(pluginEngine, null);
    }

    public Plugin(PluginEngine pluginEngine, URL pluginURL) {
        if (pluginEngine == null) {
            throw new NullPointerException("Invalid argument: pluginEngine");
        }
        this.pluginEngine = pluginEngine;
        this.pluginURL = pluginURL;
        if (pluginURL == null) {
            this.isArchive = false;
        } else {
            File file = Util.urlToFile(pluginURL);
            if (!file.exists()) {
                throw new IllegalArgumentException("Plugin URL location does not exist: " + pluginURL);
            }
            this.isArchive = !file.isDirectory();
        }
        this.pluginClassloader = PluginClassLoader.createClassLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean start() {
        if (this.isDisabled || !this.isResolved) {
            return false;
        }
        if (this.isStarted) {
            return true;
        }
        PluginClassLoader pluginClassLoader = this.pluginClassloader;
        synchronized (pluginClassLoader) {
            this.getPluginEngine().getLogger().log(LoggerLevel.FINE, "Starting Plugin: " + this, null);
            this.isStarted = true;
            if (this.lifecycleInstance == null && this.lifecycleClassName != null) {
                Class<?> pluginLifecycleClass;
                try {
                    pluginLifecycleClass = this.pluginClassloader.loadClassFromClassPath(this.lifecycleClassName);
                    if (pluginLifecycleClass == null) {
                        throw new ClassNotFoundException("Unable to find lifecycle class: " + this.lifecycleClassName);
                    }
                }
                catch (ClassNotFoundException ex) {
                    this.isStarted = false;
                    this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Unable to find lifecycle class for Plugin \"" + this + "\" during start: " + this.lifecycleClassName, ex);
                    return false;
                }
                if (!PluginLifecycle.class.isAssignableFrom(pluginLifecycleClass)) {
                    this.isStarted = false;
                    this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Lifecycle class for Plugin \"" + this + "\" does not extend PluginLifecycle: " + this.lifecycleClassName, null);
                    return false;
                }
                if (this.isActive) {
                    try {
                        this.lifecycleInstance = (PluginLifecycle)pluginLifecycleClass.newInstance();
                    }
                    catch (Exception ex) {
                        this.isStarted = false;
                        this.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Error creating lifecycle class for Plugin \"" + this + "\": " + this.lifecycleClassName, ex);
                        return false;
                    }
                }
            }
            if (this.lifecycleInstance != null) {
                this.lifecycleInstance.initialize();
            }
        }
        this.getPluginEngine().startPluginQueue.add(this);
        return true;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        PluginEngineEvent engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_STOPPED, this.getPluginEngine());
        engineEvent.setPayload(this);
        this.getPluginEngine().firePluginEngineEvent(engineEvent);
        if (this.lifecycleInstance != null) {
            this.lifecycleInstance.stop();
        }
        this.isStarted = false;
    }

    public void load() throws PluginEngineException {
        this.getPluginEngine().loadPlugin(this);
    }

    public void unload() {
        this.getPluginEngine().unloadPlugin(this);
    }

    public void disable() {
        this.getPluginEngine().disablePlugin(this);
    }

    public void enable() {
        this.getPluginEngine().enablePlugin(this);
    }

    public synchronized void addExtensionPoint(ExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            throw new NullPointerException("Invalid argument: extensionPoint");
        }
        String name = extensionPoint.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid ExtensionPoint name:" + name);
        }
        if (this.extensionPoints.containsKey(name)) {
            throw new IllegalArgumentException("ExtensionPoint already exists in plugin:" + name);
        }
        this.extensionPoints.put(name, extensionPoint);
    }

    public synchronized void removeExtensionPoint(ExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            throw new NullPointerException("Invalid argument: extensionPoint");
        }
        if (!this.extensionPoints.containsValue(extensionPoint)) {
            return;
        }
        for (Extension extension : extensionPoint.getExtensions()) {
            extension.unresolve();
        }
        this.extensionPoints.remove(extensionPoint.getName());
    }

    public synchronized ExtensionPoint getExtensionPoint(String name) {
        if (name == null) {
            throw new NullPointerException("Invalid argument: name");
        }
        return this.extensionPoints.get(name);
    }

    public synchronized List<ExtensionPoint> getExtensionPoints() {
        return new ArrayList<ExtensionPoint>(this.extensionPoints.values());
    }

    public synchronized void addExtension(Extension extension) {
        if (extension == null) {
            throw new NullPointerException("Invalid argument: extension");
        }
        this.extensions.add(extension);
        if (this.getDependency(extension.getExtensionPointPluginUID()) == null) {
            Dependency dependency = new Dependency(this, extension.getExtensionPointPluginUID());
            dependency.setOptional(true);
            this.addDependency(dependency);
        }
    }

    public synchronized void removeExtension(Extension extension) {
        if (extension == null) {
            throw new NullPointerException("Invalid argument: extension");
        }
        if (!this.extensions.contains(extension)) {
            return;
        }
        if (extension.getExtensionPoint() != null) {
            extension.unresolve();
        }
        this.extensions.remove(extension);
        Dependency dependency = this.getDependency(extension.getExtensionPointPluginUID());
        if (dependency.isOptional()) {
            for (Extension otherExtension : this.getExtensions()) {
                if (!otherExtension.getExtensionPointPluginUID().equals(dependency.resolveToPluginUID)) continue;
                return;
            }
            this.removeDependency(dependency);
        }
    }

    public synchronized List<Extension> getExtensions() {
        return new ArrayList<Extension>(this.extensions);
    }

    public synchronized void addDependency(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("Invalid argument: dependency");
        }
        if (dependency.getDependentPlugin() != this) {
            throw new IllegalArgumentException("Dependency can only be applied to Plugin: " + dependency.getDependentPlugin());
        }
        if (dependency.isCompatible(this)) {
            throw new IllegalArgumentException("Plugin cannot depend on itself.");
        }
        this.dependencies.put(dependency.resolveToPluginUID, dependency);
    }

    public synchronized void removeDependency(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("Invalid argument: dependency");
        }
        if (!this.dependencies.containsKey(dependency.resolveToPluginUID)) {
            return;
        }
        if (!dependency.isOptional() && dependency.isResolved()) {
            this.getPluginEngine().unresolvePlugin(this, true);
        } else {
            dependency.unresolve();
            for (Extension extension : this.getExtensions()) {
                if (!extension.getExtensionPointPluginUID().equals(dependency.resolveToPluginUID)) continue;
                Dependency optionalDependency = new Dependency(this, dependency.resolveToPluginUID);
                optionalDependency.setOptional(true);
                this.addDependency(optionalDependency);
            }
        }
        this.dependencies.remove(dependency.resolveToPluginUID);
    }

    public synchronized List<Dependency> getDependencies() {
        return new ArrayList<Dependency>(this.dependencies.values());
    }

    public synchronized Dependency getDependency(String pluginUID) {
        if (pluginUID == null) {
            throw new NullPointerException("Invalid argument: pluginUID");
        }
        return this.dependencies.get(pluginUID);
    }

    public synchronized List<Plugin> getDependentPlugins() {
        return new ArrayList<Plugin>(this.dependentPlugins);
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassloader;
    }

    public boolean isCompatible(Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("Invalid argument: plugin");
        }
        Dependency dependency = this.getDependency(plugin.getUID());
        if (dependency == null) {
            return true;
        }
        return dependency.isVersionCompatible(plugin.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExtractedResourcePath(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("Invalid argument: name");
        }
        if (!this.isArchive()) {
            URL resource = this.pluginClassloader.getResource(name);
            if (resource == null) {
                return null;
            }
            File file = new File(resource.getFile());
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to find resource in plugin \"" + this + "\": " + name);
            }
            return file.getAbsolutePath();
        }
        String extractedPath = this.getPluginEngine().getTempDirectory() + this.getUID() + '-' + this.getVersion().getFullVersion() + File.separator + name;
        File extractedFile = new File(extractedPath);
        if (!extractedFile.exists() || extractedFile.lastModified() < this.constructionTime) {
            InputStream resourceStream = this.pluginClassloader.getResourceAsStream(name);
            if (resourceStream == null) {
                throw new FileNotFoundException("Unable to find resource in plugin \"" + this + "\": " + name);
            }
            try {
                File outputDirectory = extractedFile.getParentFile();
                if (outputDirectory != null) {
                    outputDirectory.mkdirs();
                }
                try (FileOutputStream outputStream = new FileOutputStream(extractedPath);){
                    int bytes;
                    byte[] buffer = new byte[1024];
                    while ((bytes = resourceStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytes);
                    }
                }
            }
            finally {
                resourceStream.close();
            }
            this.getPluginEngine().getLogger().log(LoggerLevel.FINE, "Extracted resource from Plugin \"" + this + "\": " + name, null);
        }
        return extractedPath;
    }

    public String replaceToken(String token) {
        if (token == null) {
            return null;
        }
        if (token.length() < 5) {
            return token;
        }
        String tokenKey = token.substring(2, token.length() - 2);
        if (token.startsWith("%%") && token.endsWith("%%")) {
            String value = this.getPluginEngine().getToken(tokenKey);
            if (value != null) {
                return value;
            }
            value = System.getProperty(tokenKey.toLowerCase());
            if (value != null) {
                return value;
            }
        } else if (token.startsWith("$$") && token.endsWith("$$")) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("plugin", Locale.getDefault(), this.pluginClassloader);
                if (bundle != null) {
                    return bundle.getString(tokenKey.toLowerCase());
                }
            }
            catch (Exception ex) {
                this.getPluginEngine().getLogger().log(LoggerLevel.WARNING, "Error finding token properties in Plugin property file:" + tokenKey, ex);
            }
        }
        return token;
    }

    public void setLifecycleClassName(String lifecycleClassName) {
        if (lifecycleClassName == null) {
            throw new NullPointerException("Invalid argument: lifecycleClassName");
        }
        this.lifecycleClassName = lifecycleClassName;
    }

    public String getLifecycleClassName() {
        return this.lifecycleClassName;
    }

    public PluginLifecycle getLifecycleInstance() {
        if (!this.start()) {
            this.getPluginEngine().getLogger().log(LoggerLevel.WARNING, "Unable to start Plugin \"" + this + "\". Lifecycle instance cannot be acquired.", null);
            return null;
        }
        return this.lifecycleInstance;
    }

    public void setMetadataXmlNode(PluginXmlNode metadataXmlNode) {
        this.metadataXmlNode = metadataXmlNode;
    }

    public PluginXmlNode getMetadataXmlNode() {
        return this.metadataXmlNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            return this.uid;
        }
        return this.name;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public URL getPluginURL() {
        return this.pluginURL;
    }

    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public String getUID() {
        return this.uid;
    }

    public void setUID(String uid) {
        if (uid == null) {
            throw new NullPointerException("Invalid argument: uid");
        }
        this.uid = uid;
    }

    public void setStartWhenResolved(boolean startWhenResolved) {
        this.startWhenResolved = startWhenResolved;
    }

    public boolean getStartWhenResolved() {
        return this.startWhenResolved;
    }

    public void setStartOrder(int startOrder) {
        this.startOrder = startOrder;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public void setDependentPluginLookup(boolean dependentPluginLookup) {
        this.dependentPluginLookup = dependentPluginLookup;
    }

    public boolean getDependentPluginLookup() {
        return this.dependentPluginLookup;
    }

    public void setVersion(PluginVersion version) {
        if (version == null) {
            throw new NullPointerException("Invalid argument: version");
        }
        this.version = version;
    }

    public PluginVersion getVersion() {
        return this.version;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash += hash * 23 + this.getName().hashCode();
        hash += hash * 17 + this.getVersion().getFullVersion().hashCode();
        hash += hash * 11 + this.getUID().hashCode();
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    public PluginEngine getPluginEngine() {
        return this.pluginEngine;
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((Plugin)object);
    }

    @Override
    public int compareTo(Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("Invalid argument: plugin");
        }
        return this.getVersion().compareTo(plugin.getVersion());
    }

    void extensionResolved(Extension extension) {
        if (this.isStarted && this.lifecycleInstance != null) {
            this.lifecycleInstance.extensionResolved(extension.getExtensionPoint(), extension);
        }
    }

    void extensionUnresolved(Extension extension) {
        if (this.isStarted && this.lifecycleInstance != null) {
            this.lifecycleInstance.extensionUnresolved(extension.getExtensionPoint(), extension);
        }
    }

    void dependentPluginResolved(Plugin plugin) {
        this.dependentPlugins.add(plugin);
    }

    void dependentPluginUnresolved(Plugin plugin) {
        this.dependentPlugins.remove(plugin);
    }
}

