/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AbstractGraphChart;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.parameters.ChartType;
import java.util.List;

public class VennDiagram
extends AbstractGraphChart {
    private Color circle1Color;
    private Color circle2Color;
    private Color circle3Color;
    private String circle1Legend;
    private String circle2Legend;
    private String circle3Legend;
    private final double[] data;

    VennDiagram(double circle1Size, double circle2Size, double circle3Size, double abIntersect, double caIntersect, double bcIntersect, double abcIntersect) {
        double[] data;
        for (double d : data = new double[]{circle1Size, circle2Size, circle3Size, abIntersect, caIntersect, bcIntersect, abcIntersect}) {
            Preconditions.checkArgument(d >= 0.0 && d <= 100.0, "Venn diagram values must be between 0 and 100: %s", d);
        }
        this.data = data;
    }

    public final void setCircleColors(Color circle1Color, Color circle2Color, Color circle3Color) {
        Preconditions.checkNotNull(circle1Color);
        Preconditions.checkNotNull(circle2Color);
        Preconditions.checkNotNull(circle3Color);
        this.circle1Color = circle1Color;
        this.circle2Color = circle2Color;
        this.circle3Color = circle3Color;
    }

    public final void setCircleLegends(String circle1Legend, String circle2Legend, String circle3Legend) {
        Preconditions.checkNotNull(circle1Legend);
        Preconditions.checkNotNull(circle2Legend);
        Preconditions.checkNotNull(circle3Legend);
        this.circle1Legend = circle1Legend;
        this.circle2Legend = circle2Legend;
        this.circle3Legend = circle3Legend;
    }

    protected void prepareData() {
        super.prepareData();
        if (this.circle1Color != null && this.circle2Color != null && this.circle3Color != null) {
            List<ImmutableList<Color>> colors = Lists.newArrayList();
            colors.add(Lists.of(this.circle1Color));
            colors.add(Lists.of(this.circle2Color));
            colors.add(Lists.of(this.circle3Color));
            this.parameterManager.addColors(Lists.copyOf(colors));
        }
        if (this.circle1Legend != null && this.circle2Legend != null && this.circle3Legend != null) {
            this.parameterManager.addLegends(Lists.of(this.circle1Legend, this.circle2Legend, this.circle3Legend));
        }
        this.parameterManager.setChartTypeParameter(ChartType.VENN_DIAGRAM);
        this.parameterManager.addData(Data.newData(this.data));
    }
}

