/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core;

import es.uvigo.ei.aibench.Launcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import org.platonos.pluginengine.Plugin;

class PluginsObjectInputStream
extends ObjectInputStream {
    public PluginsObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        Class<?> c = null;
        String descName = desc.getName();
        if (descName.matches("\\[L.*;")) {
            String className = descName.substring(2, descName.length() - 1);
            c = Array.newInstance(this.loadClass(className), 0).getClass();
        } else {
            c = this.loadClass(descName);
        }
        if (c == null) {
            throw new ClassNotFoundException(descName);
        }
        return c;
    }

    private Class<?> loadClass(String descName) {
        for (Object o : Launcher.pluginEngine.getPlugins()) {
            Plugin p = (Plugin)o;
            try {
                return p.getPluginClassLoader().loadClass(descName);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

