/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.pipespecification.storage;

import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.IncompatibleConstraintsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PipeDefinition {
    private final List<Class<?>> outcomeTypes;
    private final List<Class<?>> incomeTypes;

    protected PipeDefinition(List<Class<?>> incomeTypes, List<Class<?>> outcomeTypes) {
        this.outcomeTypes = Collections.unmodifiableList(new ArrayList(outcomeTypes));
        this.incomeTypes = Collections.unmodifiableList(new ArrayList(incomeTypes));
    }

    public abstract PipeDefinition join(PipeDefinition var1) throws IncompatibleConstraintsException;

    public abstract int length();

    public abstract int totalLength();

    protected abstract Executable instantiate_(Map<String, Object> var1);

    public final Executable instantiate(Map<String, Object> args) {
        HashMap argsSpecification = new HashMap();
        for (Map.Entry<String, Object> argument : args.entrySet()) {
            argsSpecification.put(argument.getKey(), argument.getValue().getClass());
        }
        this.checkArguments(argsSpecification);
        return this.instantiate_(args);
    }

    public final Executable instantiate() {
        return this.instantiate(new HashMap<String, Object>());
    }

    public final void checkArguments(Map<String, Class<?>> args) throws IllegalArgumentException {
        Map<String, Class<?>> specification = this.getArgumentsSpecification();
        for (Map.Entry<String, Class<?>> entry : specification.entrySet()) {
            Class<?> receivedType;
            if (!args.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("it's necessary to receive the argument with name " + entry.getKey());
            }
            Class<?> requiredType = entry.getValue();
            if (requiredType.isAssignableFrom(receivedType = args.get(entry.getKey()))) continue;
            throw new IllegalArgumentException("The type of the argument " + entry.getKey() + ", " + receivedType + ", is incompatible with the required type " + requiredType);
        }
    }

    public abstract Map<String, Class<?>> getArgumentsSpecification();

    public final List<Class<?>> getIncomeTypes() {
        return this.incomeTypes;
    }

    public final List<Class<?>> getOutcomeTypes() {
        return this.outcomeTypes;
    }
}

