/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AxisLabels;
import com.googlecode.charts4j.AxisStyle;
import com.googlecode.charts4j.AxisTextAlignment;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.RadialAxisLabels;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AxisLabelsImpl
implements AxisLabels,
RadialAxisLabels {
    private AxisStyle axisStyle;
    private final List<Number> positions = Lists.newLinkedList();
    private final List<String> labels = Lists.newLinkedList();
    private Range range;

    AxisLabelsImpl(double minRange, double maxRange, double interval) {
        this.range = new Range(minRange, maxRange, interval);
    }

    private AxisLabelsImpl(AxisLabelsImpl axisLabels) {
        this.positions.addAll(axisLabels.positions);
        this.labels.addAll(axisLabels.labels);
        if (axisLabels.getAxisStyle() != null) {
            this.axisStyle = axisLabels.getAxisStyle().klone();
        }
        this.range = axisLabels.range;
    }

    @Override
    public AxisLabelsImpl klone() {
        return new AxisLabelsImpl(this);
    }

    AxisLabelsImpl(List<? extends String> labels, List<? extends Number> positions) {
        this.labels.addAll(labels);
        this.positions.addAll(positions);
    }

    AxisStyle getAxisStyle() {
        return this.axisStyle;
    }

    @Override
    public void setAxisStyle(AxisStyle axisStyle) {
        this.axisStyle = axisStyle.klone();
    }

    @Override
    public void setRadialAxisStyle(Color color, int fontSize) {
        this.axisStyle = AxisStyle.newAxisStyle(color, fontSize, AxisTextAlignment.CENTER);
    }

    ImmutableList<String> getLabels() {
        return Lists.copyOf(this.labels);
    }

    ImmutableList<Number> getPositions() {
        return Lists.copyOf(this.positions);
    }

    Range getRange() {
        return this.range;
    }

    static final class Range {
        private final double min;
        private final double max;
        private final double interval;

        Range(double min, double max, double interval) {
            this.min = min;
            this.max = max;
            this.interval = interval;
        }

        double getMax() {
            return this.max;
        }

        double getMin() {
            return this.min;
        }

        double getInterval() {
            return this.interval;
        }
    }
}

