/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.input;

import es.uvigo.ei.sing.hlfernandez.combobox.ComboBoxItem;
import es.uvigo.ei.sing.hlfernandez.input.InputParameter;
import es.uvigo.ei.sing.hlfernandez.input.InputParametersPanel;
import es.uvigo.ei.sing.hlfernandez.utilities.FontUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class FontConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<ComboBoxItem<Font>> fontsCmb;
    private JSpinner fontSize;
    private Map<String, ComboBoxItem<Font>> fontsMap = new HashMap<String, ComboBoxItem<Font>>();

    public FontConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new InputParametersPanel(this.getParameters()), "Center");
    }

    private InputParameter[] getParameters() {
        InputParameter[] parameters = new InputParameter[]{this.getFontParameter(), this.getFontSizeParameter()};
        return parameters;
    }

    private InputParameter getFontParameter() {
        this.fontsCmb = new JComboBox();
        this.getFontItems().forEach(this.fontsCmb::addItem);
        return new InputParameter("Font type", this.fontsCmb, "The font type.");
    }

    private List<ComboBoxItem<Font>> getFontItems() {
        return Stream.of(FontUtils.getAvailableFonts()).map(f -> new ComboBoxItem<Font>((Font)f, f.getName())).peek(i -> this.fontsMap.put(i.toString(), (ComboBoxItem<Font>)i)).collect(Collectors.toList());
    }

    private InputParameter getFontSizeParameter() {
        this.fontSize = new JSpinner(new SpinnerNumberModel(12, 1, 40, 1));
        return new InputParameter("Font size", this.fontSize, "The font size.");
    }

    public Font getSelectedFont() {
        ComboBoxItem selectedItem = (ComboBoxItem)this.fontsCmb.getSelectedItem();
        Font selected = (Font)selectedItem.getItem();
        return selected.deriveFont(this.getFontSize());
    }

    private float getFontSize() {
        return ((Integer)this.fontSize.getValue()).floatValue();
    }

    public void setSelectedFont(Font font) {
        if (this.fontsMap.containsKey(font.getName())) {
            this.fontsCmb.setSelectedItem(this.fontsMap.get(font.getName()));
            this.fontSize.setValue(font.getSize());
        }
    }
}

