/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.operation.execution;

import es.uvigo.ei.aibench.core.operation.execution.AbstractExecutable;
import es.uvigo.ei.aibench.core.operation.execution.CompositedCollector;
import es.uvigo.ei.aibench.core.operation.execution.CompositedExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.Executable;
import es.uvigo.ei.aibench.core.operation.execution.ExecutionSession;
import es.uvigo.ei.aibench.core.operation.execution.OffsetCollector;
import es.uvigo.ei.aibench.core.operation.execution.ResultsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Parallelizer
extends AbstractExecutable {
    private final List<Executable> branches;
    private final List<Class<?>> incomeArgumentTypes;
    private final List<Class<?>> outcomeArgumentTypes;

    public Parallelizer(Executable ... branches) throws IllegalArgumentException {
        if (branches == null) {
            throw new IllegalArgumentException("branches can't be null");
        }
        this.branches = Collections.unmodifiableList(Arrays.asList((Object[])branches.clone()));
        Parallelizer.checkElementsNotNull(this.branches);
        ArrayList incomeArgsTypes = new ArrayList();
        ArrayList outcomeArgsTypes = new ArrayList();
        for (Executable branch : branches) {
            incomeArgsTypes.addAll(branch.getIncomeArgumentTypes());
            outcomeArgsTypes.addAll(branch.getOutcomeArgumentTypes());
        }
        this.incomeArgumentTypes = Collections.unmodifiableList(incomeArgsTypes);
        this.outcomeArgumentTypes = Collections.unmodifiableList(outcomeArgsTypes);
    }

    @Override
    public ExecutionSession openExecutionSession(ResultsCollector collector) {
        ExecutionSession[] sessions = new ExecutionSession[this.branches.size()];
        CompositedCollector compositedCollector = new CompositedCollector(collector, this.branches.size());
        int offset = 0;
        for (int i = 0; i < sessions.length; ++i) {
            Executable branch = this.branches.get(i);
            sessions[i] = branch.openExecutionSession(new OffsetCollector(offset, compositedCollector));
            offset += branch.getIncomeArgumentTypes().size();
        }
        return new CompositedExecutionSession(collector, sessions);
    }

    @Override
    public List<Class<?>> getIncomeArgumentTypes() {
        return this.incomeArgumentTypes;
    }

    @Override
    public List<Class<?>> getOutcomeArgumentTypes() {
        return this.outcomeArgumentTypes;
    }
}

