/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots.summary;

import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.ConditionSummary;
import es.uvigo.ei.sing.s2p.core.entities.ConditionsSummary;
import es.uvigo.ei.sing.s2p.core.entities.SpotSummary;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import es.uvigo.ei.sing.s2p.core.operations.ConditionsSummarizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.table.AbstractTableModel;

public class ConditionsSummaryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final SpotSummary NA = new SpotSummary(0, 0, Double.NaN, Double.NaN, Collections.emptyList());
    private static final Map<Integer, String> SUMMARY_FIELD = new HashMap<Integer, String>();
    private static final int OFFSET = 1;
    public static final int SUMMARY_FIELDS = 4;
    private List<String> spots;
    private ConditionsSummary summary;
    private SpotsData data;

    public ConditionsSummaryTableModel(SpotsData data) {
        this.data = data;
        this.spots = data.getSpots();
        this.summary = ConditionsSummarizer.summary((List)data.getSpots(), (SpotsData)data);
    }

    @Override
    public int getRowCount() {
        return this.data.getSpots().size();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.data.getConditions().size() * 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Spot";
        }
        return SUMMARY_FIELD.get((columnIndex - 1) % 4);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.spots.get(rowIndex);
        }
        int fieldIndex = (columnIndex - 1) % 4;
        Condition c = this.getConditionAt(columnIndex).get();
        String spot = this.spots.get(rowIndex);
        return ConditionsSummaryTableModel.field(fieldIndex, this.getSpotSummary(spot, c));
    }

    public SpotSummary getSpotSummary(String spot, Condition c) {
        return (SpotSummary)((ConditionSummary)this.summary.get((Object)c)).getOrDefault((Object)spot, (Object)NA);
    }

    public Optional<Condition> getConditionAt(int columnIndex) {
        if (columnIndex == 0) {
            return Optional.empty();
        }
        int conditionIndex = (columnIndex - 1) / 4;
        return Optional.of(this.data.getConditions().get(conditionIndex));
    }

    public String getSpotAt(int rowIndex) {
        return this.spots.get(rowIndex);
    }

    private static Object field(int field, SpotSummary spotSummary) {
        int samples = spotSummary.getTotalSamples();
        int presentSamples = spotSummary.getNumSamples();
        switch (field) {
            case 0: {
                return spotSummary.getPop();
            }
            case 1: {
                return presentSamples + "/" + samples;
            }
            case 2: {
                return spotSummary.getMean();
            }
            case 3: {
                return spotSummary.getStdDev();
            }
        }
        return null;
    }

    static {
        SUMMARY_FIELD.put(0, "Presence (%)");
        SUMMARY_FIELD.put(1, "Presence");
        SUMMARY_FIELD.put(2, "Mean");
        SUMMARY_FIELD.put(3, "Std. Dev.");
    }
}

