/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.spots;

import es.uvigo.ei.sing.hlfernandez.input.RangeInputPanel;
import es.uvigo.ei.sing.hlfernandez.menu.HamburgerMenu;
import es.uvigo.ei.sing.hlfernandez.ui.UIUtils;
import es.uvigo.ei.sing.hlfernandez.ui.icons.Icons;
import es.uvigo.ei.sing.hlfernandez.utilities.ExtendedAbstractAction;
import es.uvigo.ei.sing.hlfernandez.utilities.builder.JButtonBuilder;
import es.uvigo.ei.sing.hlfernandez.utilities.builder.JToggleButtonBuilder;
import es.uvigo.ei.sing.s2p.core.entities.Condition;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.entities.Pair;
import es.uvigo.ei.sing.s2p.core.entities.Sample;
import es.uvigo.ei.sing.s2p.core.entities.SpotsCount;
import es.uvigo.ei.sing.s2p.core.entities.SpotsData;
import es.uvigo.ei.sing.s2p.core.operations.SpotSummaryOperations;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import es.uvigo.ei.sing.s2p.gui.components.ExtendedJTabbedPane;
import es.uvigo.ei.sing.s2p.gui.components.dialog.ConditionSelectionDialog;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonEvent;
import es.uvigo.ei.sing.s2p.gui.event.ProteinDataComparisonListener;
import es.uvigo.ei.sing.s2p.gui.mascot.LoadMascotIdentificationsDialog;
import es.uvigo.ei.sing.s2p.gui.mascot.MascotIdentificationsDialog;
import es.uvigo.ei.sing.s2p.gui.mascot.MascotIdentificationsSummaryDialog;
import es.uvigo.ei.sing.s2p.gui.samples.SampleComparisonView;
import es.uvigo.ei.sing.s2p.gui.spots.comparison.ConditionVsConditionComparisonView;
import es.uvigo.ei.sing.s2p.gui.spots.condition.ConditionComparisonTable;
import es.uvigo.ei.sing.s2p.gui.spots.summary.ConditionsSummaryTable;
import es.uvigo.ei.sing.s2p.gui.util.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SpotsDataViewer
extends JPanel
implements ProteinDataComparisonListener {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon VERSUS = new ImageIcon(SpotsDataViewer.class.getResource("icons/versus.png"));
    private static final ImageIcon TABLE = new ImageIcon(SpotsDataViewer.class.getResource("icons/table.png"));
    private static final ImageIcon CONDITION = new ImageIcon(SpotsDataViewer.class.getResource("icons/condition.png"));
    private static final String TOOLTIP_VISUALIZATION_UNSELECTED = "Select this option to show protein identifications along with spot numbers in the table view.";
    private static final String TOOLTIP_VISUALIZATION_SELECTED = "Select this option to hide protein identifications along with spot numbers in the table view.";
    private static final String TOOLTIP_IDENTIFIED_SPOTS_UNSELECTED = "Select this option to show only spots with associated Mascot identifications.";
    private static final String TOOLTIP_IDENTIFIED_SPOTS_SELECTED = "Select this option to disable this filter.";
    private static final String TOOLTIP_DIFFERENTIAL_SPOTS_UNSELECTED = "Select this option to show only spots that are expressed differentially in two conditions.";
    private static final String TOOLTIP_DIFFERENTIAL_SPOTS_SELECTED = "Select this option to disable this filter.";
    private static final String TOOLTIP_CONDITION_FILTERS_UNSELECTED = "Select this option to show conditions' presence filters.";
    private static final String TOOLTIP_CONDITION_FILTERS_SELECTED = "Select this option to hide conditions' presence filters.";
    private ExtendedJTabbedPane tabbedPane;
    private JPanel northPanel;
    private JPanel toolbar;
    private JPanel conditionFilteringPanel;
    private JToggleButton toggleVisualizationMode;
    private JToggleButton toggleFilterSpots;
    private JToggleButton toggleViewConditionFilters;
    private Action showProteinIdentificationsAction;
    private JToggleButton togleFilterDiferentialSpots;
    private Action showProteinIdentificationsSummaryAction;
    private JButton clearIdentificationsBtn;
    protected SpotsData data;
    private Set<String> allSpots;
    private Map<Condition, SpotsCount> conditionsCount;
    private Map<Condition, Range> conditionsThreshold;
    private Map<Condition, Color> conditionsColors;
    private Map<Sample, Color> samplesColors;
    private Map<Sample, String> samplesLabels;
    protected Optional<Map<String, MascotIdentifications>> mascotIdentifications = Optional.empty();
    protected Optional<Set<String>> differentialSpots = Optional.empty();
    private ConditionComparisonTable conditionComparisonsTable;
    private ConditionsSummaryTable conditionsSummaryTable;
    private ConditionVsConditionComparisonView proteinComparisonView;

    public SpotsDataViewer(SpotsData data) {
        this.data = data;
        this.initData();
        this.initComponent();
    }

    private void initData() {
        this.allSpots = SpotsDataViewer.getSpots(this.getConditions());
        this.conditionsCount = new HashMap<Condition, SpotsCount>();
        this.conditionsThreshold = new HashMap<Condition, Range>();
        this.conditionsColors = new HashMap<Condition, Color>();
        this.samplesColors = new HashMap<Sample, Color>();
        this.samplesLabels = new HashMap<Sample, String>();
        this.getConditions().forEach(c -> {
            this.conditionsCount.put((Condition)c, new SpotsCount(c, this.allSpots));
            this.conditionsThreshold.put((Condition)c, new Range(0, c.getSamples().size()));
            Color conditionColor = ColorUtils.getSoftColor(this.getConditions().indexOf(c));
            this.conditionsColors.put((Condition)c, conditionColor);
            c.getSamples().forEach(s -> {
                this.samplesColors.put((Sample)s, conditionColor);
                this.samplesLabels.put((Sample)s, c.getName());
            });
        });
    }

    private List<Condition> getConditions() {
        return this.data.getConditions();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.add((Component)this.getNorthPanel(), "North");
        this.add(this.getTabbedPane(), "Center");
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel(new BorderLayout());
            this.northPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
            this.northPanel.setBackground(UISettings.BG_COLOR);
            this.northPanel.add((Component)this.getToolbar(), "North");
            this.northPanel.add((Component)this.getConditionFilteringPanel(), "Center");
        }
        return this.northPanel;
    }

    private JPanel getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JPanel();
            this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
            this.toolbar.setOpaque(false);
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.toolbar.add(Box.createHorizontalStrut(10));
            this.toolbar.add(this.getAddMascotIdentificationsButton());
            this.toolbar.add(this.getClearMascotIdentificationsButton());
            this.toolbar.add(Box.createHorizontalStrut(5));
            this.toolbar.add(this.getVisualizationModeToggleButton());
            this.toolbar.add(this.getFilterSpotsToggleButton());
            this.toolbar.add(this.getFilterDifferentialSpotsButton());
            this.toolbar.add(this.getConditionFiltersVisibilityButton());
            this.toolbar.add(Box.createHorizontalGlue());
            this.toolbar.add(this.getHamburgerMenu());
        }
        return this.toolbar;
    }

    private JButton getAddMascotIdentificationsButton() {
        return JButtonBuilder.newJButtonBuilder().thatDoes(this.getAddMascotIdentificationsAction()).build();
    }

    private JButton getClearMascotIdentificationsButton() {
        this.clearIdentificationsBtn = JButtonBuilder.newJButtonBuilder().thatDoes(this.getClearMascotIdentificationsAction()).disabled().build();
        return this.clearIdentificationsBtn;
    }

    private Action getClearMascotIdentificationsAction() {
        return new ExtendedAbstractAction("Clear identifications", (Icon)Icons.ICON_TRASH_16, this::clearMascotIdentifications);
    }

    private void clearMascotIdentifications() {
        this.removeMascotIdentifications();
        this.differentialSpots = Optional.empty();
        this.togleFilterDiferentialSpots.setSelected(false);
        this.enableIdentificationButtons(false);
        this.updateVisibleSpots();
    }

    private void removeMascotIdentifications() {
        this.mascotIdentifications = Optional.empty();
        this.conditionComparisonsTable.removeMascotIdentifications();
        this.conditionsSummaryTable.removeMascotIdentifications();
        this.proteinComparisonView.removeMascotIdentifications();
    }

    private Action getAddMascotIdentificationsAction() {
        return new ExtendedAbstractAction("Identifications", (Icon)Icons.ICON_ADD_16, this::addMascotIdentifications);
    }

    protected void addMascotIdentifications() {
        LoadMascotIdentificationsDialog dialog = this.getMascotIdentificationsDialog();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.addMascotIdentifications(dialog.getMascotIdentifications());
            this.setMascotIdentificationsVisible();
        }
    }

    private void setMascotIdentificationsVisible() {
        if (!this.toggleVisualizationMode.isSelected()) {
            this.toggleVisualizationMode.doClick();
        }
    }

    private void addMascotIdentifications(Map<String, MascotIdentifications> identifications) {
        if (identifications != null) {
            if (this.mascotIdentifications.isPresent()) {
                for (String key : this.mascotIdentifications.get().keySet()) {
                    if (identifications.containsKey(key)) {
                        identifications.get(key).addAll((Collection)this.mascotIdentifications.get().get(key));
                        continue;
                    }
                    identifications.put(key, this.mascotIdentifications.get().get(key));
                }
            }
            this.setMascotIdentifications(identifications);
        }
    }

    private void setMascotIdentifications(Map<String, MascotIdentifications> identifications) {
        this.mascotIdentifications = Optional.of(identifications);
        this.sortMascotIdentifications();
        this.conditionComparisonsTable.setMascotIdentifications(identifications);
        this.conditionsSummaryTable.setMascotIdentifications(identifications);
        this.proteinComparisonView.setMascotIdentifications(identifications);
        this.enableIdentificationButtons(true);
        this.updateVisibleSpots();
    }

    private void enableIdentificationButtons(boolean enabled) {
        this.clearIdentificationsBtn.setEnabled(enabled);
        this.toggleVisualizationMode.setEnabled(enabled);
        this.toggleFilterSpots.setEnabled(enabled);
        this.togleFilterDiferentialSpots.setEnabled(enabled);
        this.showProteinIdentificationsAction.setEnabled(enabled);
        this.showProteinIdentificationsSummaryAction.setEnabled(enabled);
    }

    protected LoadMascotIdentificationsDialog getMascotIdentificationsDialog() {
        return new LoadMascotIdentificationsDialog(this.getDialogParent());
    }

    private void sortMascotIdentifications() {
        this.mascotIdentifications.get().values().forEach(list -> Collections.sort(list, (o1, o2) -> o2.getMascotScore() - o1.getMascotScore()));
    }

    private JToggleButton getVisualizationModeToggleButton() {
        if (this.toggleVisualizationMode == null) {
            this.toggleVisualizationMode = JToggleButtonBuilder.newJToggleButton().withLabel("Identifications").withSelectedIcon(Icons.ICON_EYE_16).withUnselectedIcon(Icons.ICON_EYE_HIDDEN_16).setSelected(Boolean.valueOf(false)).setEnabled(false).withTooltip(selected -> selected != false ? TOOLTIP_VISUALIZATION_SELECTED : TOOLTIP_VISUALIZATION_UNSELECTED).thatDoes(this::toggleVisualizationMode).build();
        }
        return this.toggleVisualizationMode;
    }

    private void toggleVisualizationMode(ItemEvent e) {
        boolean show = this.toggleVisualizationMode.isSelected();
        this.conditionComparisonsTable.setShowProteinIdentifications(show);
        this.conditionsSummaryTable.setShowProteinIdentifications(show);
        this.proteinComparisonView.setShowProteinIdentifications(show);
    }

    private JToggleButton getFilterSpotsToggleButton() {
        if (this.toggleFilterSpots == null) {
            this.toggleFilterSpots = JToggleButtonBuilder.newJToggleButton().withLabel("Identified spots").withSelectedIcon(Icons.ICON_EYE_16).withUnselectedIcon(Icons.ICON_EYE_HIDDEN_16).setSelected(Boolean.valueOf(false)).setEnabled(false).withTooltip(selected -> selected != false ? "Select this option to disable this filter." : TOOLTIP_IDENTIFIED_SPOTS_UNSELECTED).thatDoes(this::toggleFilterSpots).build();
        }
        return this.toggleFilterSpots;
    }

    private void toggleFilterSpots(ItemEvent e) {
        this.updateVisibleSpots();
    }

    private JToggleButton getFilterDifferentialSpotsButton() {
        if (this.togleFilterDiferentialSpots == null) {
            this.togleFilterDiferentialSpots = JToggleButtonBuilder.newJToggleButton().withLabel("Differential spots").withSelectedIcon(Icons.ICON_EYE_16).withUnselectedIcon(Icons.ICON_EYE_HIDDEN_16).setSelected(Boolean.valueOf(false)).setEnabled(false).withTooltip(selected -> selected != false ? "Select this option to disable this filter." : TOOLTIP_DIFFERENTIAL_SPOTS_UNSELECTED).thatDoes(this::toggleViewDifferentialSpots).build();
        }
        return this.togleFilterDiferentialSpots;
    }

    private void toggleViewDifferentialSpots(ItemEvent e) {
        if (e.getStateChange() == 1) {
            SwingUtilities.invokeLater(this::setDifferentialSpotsFilter);
        } else {
            this.setDiferentialSpotsFilter(Collections.emptySet());
        }
    }

    private JToggleButton getConditionFiltersVisibilityButton() {
        if (this.toggleViewConditionFilters == null) {
            this.toggleViewConditionFilters = JToggleButtonBuilder.newJToggleButton().withLabel("Presence filters").withSelectedIcon(Icons.ICON_EYE_16).withUnselectedIcon(Icons.ICON_EYE_HIDDEN_16).setSelected(Boolean.valueOf(true)).setEnabled(true).withTooltip(selected -> selected != false ? TOOLTIP_CONDITION_FILTERS_SELECTED : TOOLTIP_CONDITION_FILTERS_UNSELECTED).thatDoes(this::toggleViewConditionFilters).build();
        }
        return this.toggleViewConditionFilters;
    }

    private void toggleViewConditionFilters(ItemEvent e) {
        boolean visible = e.getStateChange() == 1;
        this.conditionFilteringPanel.setVisible(visible);
    }

    private void setDifferentialSpotsFilter() {
        ConditionSelectionDialog dialog = new ConditionSelectionDialog(this.getDialogParent(), this.getConditions());
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            Pair<Condition, Condition> selection = dialog.getSelectedConditions();
            this.setDiferentialSpotsFilter(this.findDifferentialSpots((Condition)selection.getFirst(), (Condition)selection.getSecond(), dialog.getDiferentialSpotFunction(), dialog.getSelectedPvalue(), dialog.isCorrectPvalue()));
        } else {
            this.togleFilterDiferentialSpots.setSelected(false);
        }
    }

    private void setDiferentialSpotsFilter(Set<String> differentialSpots) {
        this.differentialSpots = Optional.of(differentialSpots);
        this.updateVisibleSpots();
    }

    private boolean isDifferentialSpotFilterEnabled() {
        return this.mascotIdentifications.isPresent() && this.togleFilterDiferentialSpots.isSelected() && this.differentialSpots.isPresent();
    }

    private Set<String> findDifferentialSpots(Condition first, Condition second, SpotSummaryOperations.DifferentialSpotFunction function, double pValue, boolean correctP) {
        return SpotSummaryOperations.findDifferentialSpots(this.allSpots, (Condition)first, (Condition)second, this.conditionsSummaryTable::getSpotSummary, (SpotSummaryOperations.DifferentialSpotFunction)function, (double)pValue, (boolean)correctP);
    }

    private JToggleButton getHamburgerMenu() {
        HamburgerMenu menu = new HamburgerMenu(HamburgerMenu.Size.SIZE16);
        menu.add(this.getShowProteinIdentificationsButton());
        menu.add(this.getShowProteinIdentificationsSummaryButton());
        return menu;
    }

    private Action getShowProteinIdentificationsButton() {
        if (this.showProteinIdentificationsAction == null) {
            this.showProteinIdentificationsAction = new ExtendedAbstractAction("Identifications detail", (Icon)Icons.ICON_LOOKUP_16, this::showProteinIdentifications);
        }
        this.showProteinIdentificationsAction.setEnabled(false);
        return this.showProteinIdentificationsAction;
    }

    private void showProteinIdentifications() {
        MascotIdentificationsDialog dialog = new MascotIdentificationsDialog(this.getDialogParent(), this.getVisibleSpots(), this.mascotIdentifications.get());
        dialog.setVisible(true);
    }

    private Window getDialogParent() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private Action getShowProteinIdentificationsSummaryButton() {
        if (this.showProteinIdentificationsSummaryAction == null) {
            this.showProteinIdentificationsSummaryAction = new ExtendedAbstractAction("Summary", (Icon)Icons.ICON_INFO_16, this::showProteinIdentificationsSummary);
        }
        this.showProteinIdentificationsSummaryAction.setEnabled(false);
        return this.showProteinIdentificationsSummaryAction;
    }

    private void showProteinIdentificationsSummary() {
        MascotIdentificationsSummaryDialog dialog = new MascotIdentificationsSummaryDialog(this.getDialogParent(), this.allSpots, this.mascotIdentifications.get());
        dialog.setVisible(true);
    }

    private JPanel getConditionFilteringPanel() {
        this.conditionFilteringPanel = new JPanel();
        this.conditionFilteringPanel.setLayout(new GridLayout(0, 2));
        this.getConditions().forEach(c -> {
            if (c.getSamples().size() > 1) {
                this.conditionFilteringPanel.add(this.createConditionFilteringPanel((Condition)c));
            }
        });
        return this.conditionFilteringPanel;
    }

    private Component createConditionFilteringPanel(Condition condition) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(condition.getName()));
        panel.setBackground(UISettings.BG_COLOR);
        RangeInputPanel rangeInput = new RangeInputPanel(0, condition.getSamples().size(), "Minimum number of samples", "Maximum number of samples");
        UIUtils.setOpaqueRecursive((JComponent)rangeInput, (boolean)false);
        rangeInput.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        rangeInput.setBackground(UISettings.BG_COLOR);
        int numSamples = condition.getSamples().size();
        JLabel label = new JLabel(SpotsDataViewer.getLabelText(0, numSamples, numSamples));
        label.setFont(label.getFont().deriveFont(1));
        rangeInput.addChangeListener(e -> this.conditionFilterChanged(condition, rangeInput.getMinValue(), rangeInput.getMaxValue(), label));
        panel.add((Component)label, "North");
        panel.add((Component)rangeInput, "Center");
        return panel;
    }

    private static String getLabelText(int min, int max, int samples) {
        StringBuilder sb = new StringBuilder();
        sb.append("Show spots present in at least ").append(min).append(" (").append(String.format("%.2f%n", 100.0 * (double)min / (double)samples)).append("%) and at maximum ").append(max).append(" (of ").append(samples).append(") samples:");
        return sb.toString();
    }

    private static Set<String> getSpots(List<Condition> conditions) {
        HashSet<String> all = new HashSet<String>();
        conditions.forEach(c -> all.addAll(c.getSpots()));
        return all;
    }

    private void conditionFilterChanged(Condition condition, int min, int max, JLabel label) {
        label.setText(SpotsDataViewer.getLabelText(min, max, condition.getSamples().size()));
        this.conditionsThreshold.put(condition, new Range(min, max));
        this.updateVisibleSpots();
    }

    private void updateVisibleSpots() {
        Set<String> visibleSpots = this.getVisibleSpots();
        this.conditionComparisonsTable.setVisibleProteins(visibleSpots);
        this.conditionsSummaryTable.setVisibleSpots(visibleSpots);
    }

    protected Set<String> getVisibleSpots() {
        HashSet<String> visibleSpots = new HashSet<String>(this.allSpots);
        this.getConditions().forEach(c -> {
            Set proteins = this.conditionsCount.get(c).getSpots(this.conditionsThreshold.get(c).getMin(), this.conditionsThreshold.get(c).getMax());
            visibleSpots.retainAll(proteins);
        });
        if (this.isShowOnlyIdentifiedSpots()) {
            visibleSpots.retainAll(this.getIdentifiedspots());
        }
        if (this.isDifferentialSpotFilterEnabled()) {
            visibleSpots.retainAll((Collection)this.differentialSpots.get());
        }
        return visibleSpots;
    }

    private Set<String> getIdentifiedspots() {
        return this.allSpots.stream().filter(this::isIdentifiedSpot).collect(Collectors.toSet());
    }

    private boolean isIdentifiedSpot(String spot) {
        return this.mascotIdentifications.isPresent() && this.mascotIdentifications.get().containsKey(spot);
    }

    private boolean isShowOnlyIdentifiedSpots() {
        return this.mascotIdentifications.isPresent() && this.toggleFilterSpots.isSelected();
    }

    private Component getTabbedPane() {
        this.tabbedPane = new ExtendedJTabbedPane();
        this.tabbedPane.setHideTabBarWhenSingleTab(true);
        this.addTabs();
        return this.tabbedPane;
    }

    private void addTabs() {
        this.addFullComparisonTable();
        this.addConditionsSummaryTable();
        this.addConditionComparisonView();
    }

    private void addFullComparisonTable() {
        this.tabbedPane.addTab("", this.getConditionsComparisonTable());
        this.tabbedPane.setTabComponentAt(0, SpotsDataViewer.label("Table view", TABLE));
    }

    private void addConditionsSummaryTable() {
        this.tabbedPane.addTab("", this.getConditionsSummaryTable());
        this.tabbedPane.setTabComponentAt(1, SpotsDataViewer.label("Conditions summary", CONDITION));
    }

    private void addConditionComparisonView() {
        this.proteinComparisonView = new ConditionVsConditionComparisonView(this.data);
        this.proteinComparisonView.addTableListener(this);
        this.tabbedPane.addTab("", this.proteinComparisonView);
        this.tabbedPane.setTabComponentAt(2, SpotsDataViewer.label("Comparison view", VERSUS));
    }

    private static Component label(String string, ImageIcon table2) {
        JLabel toret = new JLabel(string);
        toret.setIcon(table2);
        toret.setIconTextGap(5);
        return toret;
    }

    private Component getConditionsComparisonTable() {
        this.conditionComparisonsTable = new ConditionComparisonTable(this.getConditions(), this.samplesColors, this.samplesLabels);
        return this.conditionComparisonsTable;
    }

    private Component getConditionsSummaryTable() {
        this.conditionsSummaryTable = new ConditionsSummaryTable(this.data);
        return this.conditionsSummaryTable;
    }

    @Override
    public void onSampleSelection(ProteinDataComparisonEvent event) {
        Sample[] samples = (Sample[])event.getSource();
        this.tabbedPane.addTab(this.getSampleComparisonTabTitle(samples[0], samples[1]), new SampleComparisonView(samples[0], samples[1]), true);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getComponentCount() - 2);
    }

    private String getSampleComparisonTabTitle(Sample sample1, Sample sample2) {
        return sample1.getName() + " vs. " + sample2.getName();
    }

    @Override
    public void onSampleSelectionCleared(ProteinDataComparisonEvent event) {
    }

    static class Range {
        private int max;
        private int min;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }
    }
}

