/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.jrockit.jfr.ActiveRecordingEvent;
import oracle.jrockit.jfr.ActiveSettingEvent;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.settings.EventSetting;

@Deprecated
final class MetaProducer {
    private final JFRImpl jfr;
    private boolean hasChunk;
    private Producer prod;
    private EventToken activeRecording;
    private EventToken activeSetting;

    MetaProducer(JFRImpl jFRImpl) {
        this.jfr = jFRImpl;
    }

    void createProducer() throws InvalidEventDefinitionException, InvalidValueException, URISyntaxException {
        Producer producer = new Producer("JFR Metadata", "Information about Recordings and Settings", "http://www.oracle.com/hotspot/jfr-info/");
        this.activeRecording = producer.addEvent(ActiveRecordingEvent.class);
        this.activeSetting = producer.addEvent(ActiveSettingEvent.class);
        this.prod = producer;
        producer.register();
    }

    void unregister() {
        if (this.prod != null && this.prod.isRegistered()) {
            try {
                this.prod.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void onNewChunk() {
        InstantEvent instantEvent;
        Collection<Object> collection;
        this.hasChunk = true;
        if (this.prod == null) {
            return;
        }
        if (this.activeRecording.isEnabled()) {
            collection = this.jfr.getRecordings();
            for (Object object : collection) {
                if (!((Recording)object).isStarted() || ((Recording)object).isStoppingDone()) continue;
                instantEvent = new ActiveRecordingEvent();
                ((ActiveRecordingEvent)instantEvent).id = ((Recording)object).getId();
                ((ActiveRecordingEvent)instantEvent).name = ((Recording)object).getName();
                ((ActiveRecordingEvent)instantEvent).destination = ((Recording)object).getDestination();
                ((ActiveRecordingEvent)instantEvent).duration = ((Recording)object).getDuration(TimeUnit.MILLISECONDS);
                ((ActiveRecordingEvent)instantEvent).maxAge = ((Recording)object).getMaxAge(TimeUnit.MILLISECONDS);
                ((ActiveRecordingEvent)instantEvent).maxSize = ((Recording)object).getMaxSize();
                ((ActiveRecordingEvent)instantEvent).startTime = ((Recording)object).getStartTime().getTime();
                ((ActiveRecordingEvent)instantEvent).compress = ((Recording)object).isDestinationCompressed();
                instantEvent.commit();
            }
        }
        if (this.activeSetting.isEnabled()) {
            collection = this.jfr.getEventSettings().getSettings();
            for (Object object : collection) {
                instantEvent = new ActiveSettingEvent();
                ((ActiveSettingEvent)instantEvent).id = ((EventSetting)object).getId();
                ((ActiveSettingEvent)instantEvent).enabled = ((EventSetting)object).isEnabled();
                ((ActiveSettingEvent)instantEvent).stacktrace = ((EventSetting)object).isStacktraceEnabled();
                long l = ((EventSetting)object).getThreshold();
                ((ActiveSettingEvent)instantEvent).threshold = l == -1L ? Long.MIN_VALUE : l;
                long l2 = ((EventSetting)object).getPeriod();
                ((ActiveSettingEvent)instantEvent).period = l2 == -1L ? Long.MIN_VALUE : l2;
                try {
                    ((ActiveSettingEvent)instantEvent).name = this.jfr.getEvent(((EventSetting)object).getId()).getName();
                    ((ActiveSettingEvent)instantEvent).path = this.jfr.getEvent(((EventSetting)object).getId()).getPath();
                }
                catch (NoSuchEventException noSuchEventException) {
                    // empty catch block
                }
                instantEvent.commit();
            }
        }
    }

    void chunkDone() {
        this.hasChunk = false;
    }

    void settingsChanged(Collection<EventSetting> collection, Map<Integer, EventSetting> map) {
        if (this.prod == null) {
            return;
        }
        if (this.activeSetting.isEnabled() && this.hasChunk) {
            for (EventSetting eventSetting : collection) {
                EventSetting eventSetting2 = map.get(eventSetting.getId());
                if (eventSetting2 != null && eventSetting2.equals(eventSetting)) continue;
                ActiveSettingEvent activeSettingEvent = new ActiveSettingEvent();
                activeSettingEvent.id = eventSetting.getId();
                activeSettingEvent.enabled = eventSetting.isEnabled();
                activeSettingEvent.stacktrace = eventSetting.isStacktraceEnabled();
                long l = eventSetting.getThreshold();
                activeSettingEvent.threshold = l == -1L ? Long.MIN_VALUE : l;
                long l2 = eventSetting.getPeriod();
                activeSettingEvent.period = l2 == -1L ? Long.MIN_VALUE : l2;
                try {
                    activeSettingEvent.name = this.jfr.getEvent(eventSetting.getId()).getName();
                    activeSettingEvent.path = this.jfr.getEvent(eventSetting.getId()).getPath();
                }
                catch (NoSuchEventException noSuchEventException) {
                    // empty catch block
                }
                activeSettingEvent.commit();
            }
        }
    }
}

