/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.lang.reflect.Method;
import org.w3c.dom.Element;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.xml.MethodHandler;

public class XMLSerializationMethodHandler
implements RevisionHandler {
    protected MethodHandler m_ReadMethods = null;
    protected MethodHandler m_WriteMethods = null;
    protected Object owner = null;

    public XMLSerializationMethodHandler(Object owner) throws Exception {
        this.owner = owner;
        this.m_ReadMethods = new MethodHandler();
        this.m_WriteMethods = new MethodHandler();
        this.clear();
    }

    protected void addMethods(MethodHandler handler, Method template, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (template.equals(method) || !template.getReturnType().equals(method.getReturnType()) || template.getParameterTypes().length != method.getParameterTypes().length) continue;
            boolean equal = true;
            for (int n = 0; n < template.getParameterTypes().length; ++n) {
                if (template.getParameterTypes()[n].equals(method.getParameterTypes()[n])) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            String name = method.getName();
            name = name.replaceAll("read|write", "");
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
            handler.add(name, method);
        }
    }

    protected void addMethods() throws Exception {
        Class[] params = new Class[]{Element.class};
        Method method = this.owner.getClass().getMethod("readFromXML", params);
        this.addMethods(this.m_ReadMethods, method, this.owner.getClass().getMethods());
        params = new Class[]{Element.class, Object.class, String.class};
        method = this.owner.getClass().getMethod("writeToXML", params);
        this.addMethods(this.m_WriteMethods, method, this.owner.getClass().getMethods());
    }

    public static Method findReadMethod(Object o, String name) {
        Method result = null;
        Class[] params = new Class[]{Element.class};
        try {
            result = o.getClass().getMethod(name, params);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static Method findWriteMethod(Object o, String name) {
        Method result = null;
        Class[] params = new Class[]{Element.class, Object.class, String.class};
        try {
            result = o.getClass().getMethod(name, params);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public void clear() {
        this.m_ReadMethods.clear();
        this.m_WriteMethods.clear();
        try {
            this.addMethods();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MethodHandler read() {
        return this.m_ReadMethods;
    }

    public MethodHandler write() {
        return this.m_WriteMethods;
    }

    public void register(Object handler, Class cls, String name) {
        this.read().add(cls, XMLSerializationMethodHandler.findReadMethod(handler, "read" + name));
        this.write().add(cls, XMLSerializationMethodHandler.findWriteMethod(handler, "write" + name));
    }

    public String toString() {
        return "Read Methods:\n" + this.read() + "\n\n" + "Write Methods:\n" + this.write();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

