/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class KMeansInpiredMethod
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -866783749124714304L;

    public String globalInfo() {
        return "The class that splits a node into two such that the overall sum of squared distances of points to their centres on both sides of the (axis-parallel) splitting plane is minimum.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    public void splitNode(KDTreeNode node, int numNodesCreated, double[][] nodeRanges, double[][] universe) throws Exception {
        this.correctlyInitialized();
        int splitDim = -1;
        double splitVal = Double.NEGATIVE_INFINITY;
        double[] leftAttSum = new double[this.m_Instances.numAttributes()];
        double[] rightAttSum = new double[this.m_Instances.numAttributes()];
        double[] leftAttSqSum = new double[this.m_Instances.numAttributes()];
        double[] rightAttSqSum = new double[this.m_Instances.numAttributes()];
        double minSum = Double.POSITIVE_INFINITY;
        for (int dim = 0; dim < this.m_Instances.numAttributes(); ++dim) {
            double val;
            int i;
            if (node.m_NodeRanges[dim][2] == 0.0 || dim == this.m_Instances.classIndex()) continue;
            KMeansInpiredMethod.quickSort(this.m_Instances, this.m_InstList, dim, node.m_Start, node.m_End);
            for (i = node.m_Start; i <= node.m_End; ++i) {
                for (int j = 0; j < this.m_Instances.numAttributes(); ++j) {
                    if (j == this.m_Instances.classIndex()) continue;
                    val = this.m_Instances.instance(this.m_InstList[i]).value(j);
                    if (this.m_NormalizeNodeWidth) {
                        val = Double.isNaN(universe[j][0]) || universe[j][0] == universe[j][1] ? 0.0 : (val - universe[j][0]) / universe[j][2];
                    }
                    if (i == node.m_Start) {
                        rightAttSqSum[j] = 0.0;
                        leftAttSqSum[j] = 0.0;
                        rightAttSum[j] = 0.0;
                        leftAttSum[j] = 0.0;
                    }
                    int n = j;
                    rightAttSum[n] = rightAttSum[n] + val;
                    int n2 = j;
                    rightAttSqSum[n2] = rightAttSqSum[n2] + val * val;
                }
            }
            for (i = node.m_Start; i <= node.m_End - 1; ++i) {
                Instance inst = this.m_Instances.instance(this.m_InstList[i]);
                double rightSqSum = 0.0;
                double leftSqSum = 0.0;
                for (int j = 0; j < this.m_Instances.numAttributes(); ++j) {
                    if (j == this.m_Instances.classIndex()) continue;
                    val = inst.value(j);
                    if (this.m_NormalizeNodeWidth) {
                        val = Double.isNaN(universe[j][0]) || universe[j][0] == universe[j][1] ? 0.0 : (val - universe[j][0]) / universe[j][2];
                    }
                    int n = j;
                    leftAttSum[n] = leftAttSum[n] + val;
                    int n3 = j;
                    rightAttSum[n3] = rightAttSum[n3] - val;
                    int n4 = j;
                    leftAttSqSum[n4] = leftAttSqSum[n4] + val * val;
                    int n5 = j;
                    rightAttSqSum[n5] = rightAttSqSum[n5] - val * val;
                    double leftSqMean = leftAttSum[j] / (double)(i - node.m_Start + 1);
                    leftSqMean *= leftSqMean;
                    double rightSqMean = rightAttSum[j] / (double)(node.m_End - i);
                    rightSqMean *= rightSqMean;
                    leftSqSum += leftAttSqSum[j] - (double)(i - node.m_Start + 1) * leftSqMean;
                    rightSqSum += rightAttSqSum[j] - (double)(node.m_End - i) * rightSqMean;
                }
                if (!(minSum > leftSqSum + rightSqSum)) continue;
                minSum = leftSqSum + rightSqSum;
                splitVal = i < node.m_End ? (this.m_Instances.instance(this.m_InstList[i]).value(dim) + this.m_Instances.instance(this.m_InstList[i + 1]).value(dim)) / 2.0 : this.m_Instances.instance(this.m_InstList[i]).value(dim);
                splitDim = dim;
            }
        }
        int rightStart = this.rearrangePoints(this.m_InstList, node.m_Start, node.m_End, splitDim, splitVal);
        if (rightStart == node.m_Start || rightStart > node.m_End) {
            System.out.println("node.m_Start: " + node.m_Start + " node.m_End: " + node.m_End + " splitDim: " + splitDim + " splitVal: " + splitVal + " node.min: " + node.m_NodeRanges[splitDim][0] + " node.max: " + node.m_NodeRanges[splitDim][1] + " node.numInstances: " + node.numInstances());
            if (rightStart == node.m_Start) {
                throw new Exception("Left child is empty in node " + node.m_NodeNumber + ". Not possible with " + "KMeanInspiredMethod splitting method. Please " + "check code.");
            }
            throw new Exception("Right child is empty in node " + node.m_NodeNumber + ". Not possible with " + "KMeansInspiredMethod splitting method. Please " + "check code.");
        }
        node.m_SplitDim = splitDim;
        node.m_SplitValue = splitVal;
        node.m_Left = new KDTreeNode(numNodesCreated + 1, node.m_Start, rightStart - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, rightStart - 1));
        node.m_Right = new KDTreeNode(numNodesCreated + 2, rightStart, node.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, rightStart, node.m_End));
    }

    protected static int partition(Instances insts, int[] index, int attidx, int l, int r) {
        double pivot = insts.instance(index[(l + r) / 2]).value(attidx);
        while (l < r) {
            while (insts.instance(index[l]).value(attidx) < pivot && l < r) {
                ++l;
            }
            while (insts.instance(index[r]).value(attidx) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && insts.instance(index[r]).value(attidx) > pivot) {
            --r;
        }
        return r;
    }

    protected static void quickSort(Instances insts, int[] indices, int attidx, int left, int right) {
        if (left < right) {
            int middle = KMeansInpiredMethod.partition(insts, indices, attidx, left, right);
            KMeansInpiredMethod.quickSort(insts, indices, attidx, left, middle);
            KMeansInpiredMethod.quickSort(insts, indices, attidx, middle + 1, right);
        }
    }

    private static void checkSort(Instances insts, int[] indices, int attidx, int start, int end) throws Exception {
        for (int i = start + 1; i <= end; ++i) {
            if (!(insts.instance(indices[i - 1]).value(attidx) > insts.instance(indices[i]).value(attidx))) continue;
            System.out.println("value[i-1]: " + insts.instance(indices[i - 1]).value(attidx));
            System.out.println("value[i]: " + insts.instance(indices[i]).value(attidx));
            System.out.println("indices[i-1]: " + indices[i - 1]);
            System.out.println("indices[i]: " + indices[i]);
            System.out.println("i: " + i);
            if (insts.instance(indices[i - 1]).value(attidx) > insts.instance(indices[i]).value(attidx)) {
                System.out.println("value[i-1] > value[i]");
            }
            throw new Exception("Indices not sorted correctly.");
        }
    }

    protected int rearrangePoints(int[] indices, int startidx, int endidx, int splitDim, double splitVal) {
        int left = startidx - 1;
        for (int i = startidx; i <= endidx; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(indices[i]), splitDim, splitVal)) continue;
            int tmp = indices[++left];
            indices[left] = indices[i];
            indices[i] = tmp;
        }
        return left + 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

