/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.event.PluginEngineEvent;
import org.platonos.pluginengine.event.PluginEngineEventType;
import org.platonos.pluginengine.logging.LoggerLevel;

final class StartPluginQueue {
    private final PluginEngine pluginEngine;
    private final Thread[] threads;
    private final LinkedList<Plugin> pluginQueue = new LinkedList();
    private boolean shutdown = false;
    private int currentMaximumOrder = -1;
    private int startingCounter = 0;
    static final Comparator<Plugin> PLUGIN_START_ORDER_COMPARATOR = new Comparator<Plugin>(){

        @Override
        public int compare(Plugin o1, Plugin o2) {
            if (o1.getStartOrder() == o2.getStartOrder()) {
                return o1.getUID().compareTo(o2.getUID());
            }
            return o1.getStartOrder() < o2.getStartOrder() ? -1 : 1;
        }
    };

    StartPluginQueue(PluginEngine pluginEngine) {
        this.pluginEngine = pluginEngine;
        this.threads = new Thread[pluginEngine.startPluginThreadCount];
        for (int i = 0; i < pluginEngine.startPluginThreadCount; ++i) {
            this.threads[i] = new Thread((Runnable)new PoolWorker(), "PluginStart" + i);
            this.threads[i].start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canExecute(Plugin plugin) {
        LinkedList<Plugin> linkedList = this.pluginQueue;
        synchronized (linkedList) {
            return plugin.getStartOrder() == this.currentMaximumOrder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginStarting(Plugin plugin) {
        LinkedList<Plugin> linkedList = this.pluginQueue;
        synchronized (linkedList) {
            ++this.startingCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pluginStarted(Plugin plugin) {
        LinkedList<Plugin> linkedList = this.pluginQueue;
        synchronized (linkedList) {
            --this.startingCounter;
            if (this.startingCounter == 0) {
                this.currentMaximumOrder = this.pluginQueue.isEmpty() ? -1 : this.pluginQueue.getFirst().getStartOrder();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Plugin plugin) {
        if (this.threads.length == 0) {
            return;
        }
        LinkedList<Plugin> linkedList = this.pluginQueue;
        synchronized (linkedList) {
            this.pluginQueue.addLast(plugin);
            Collections.sort(this.pluginQueue, PLUGIN_START_ORDER_COMPARATOR);
            if (this.startingCounter == 0) {
                this.currentMaximumOrder = this.pluginQueue.getFirst().getStartOrder();
            }
            this.pluginQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.shutdown = true;
        LinkedList<Plugin> linkedList = this.pluginQueue;
        synchronized (linkedList) {
            this.pluginQueue.notifyAll();
        }
    }

    public class PoolWorker
    implements Runnable {
        Plugin plugin;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList linkedList = StartPluginQueue.this.pluginQueue;
                synchronized (linkedList) {
                    while (StartPluginQueue.this.pluginQueue.isEmpty() || !StartPluginQueue.this.canExecute((Plugin)StartPluginQueue.this.pluginQueue.getFirst())) {
                        try {
                            StartPluginQueue.this.pluginQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!StartPluginQueue.this.shutdown) continue;
                        return;
                    }
                    this.plugin = (Plugin)StartPluginQueue.this.pluginQueue.removeFirst();
                    StartPluginQueue.this.pluginStarting(this.plugin);
                }
                try {
                    PluginEngineEvent engineEvent;
                    if (!this.plugin.isStarted()) {
                        return;
                    }
                    if (this.plugin.lifecycleInstance != null) {
                        engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_STARTING, StartPluginQueue.this.pluginEngine);
                        engineEvent.setPayload(this.plugin);
                        StartPluginQueue.this.pluginEngine.firePluginEngineEvent(engineEvent);
                        this.plugin.lifecycleInstance.start();
                    }
                    engineEvent = new PluginEngineEvent(PluginEngineEventType.PLUGIN_STARTED, StartPluginQueue.this.pluginEngine);
                    engineEvent.setPayload(this.plugin);
                    StartPluginQueue.this.pluginEngine.firePluginEngineEvent(engineEvent);
                }
                catch (RuntimeException ex) {
                    StartPluginQueue.this.pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Uncaught exception during Plugin start: " + this.plugin, ex);
                }
                if (this.plugin == null) continue;
                StartPluginQueue.this.pluginStarted(this.plugin);
            }
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

