/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.mascot;

import es.uvigo.ei.sing.commons.csv.entities.CsvFormat;
import es.uvigo.ei.sing.hlfernandez.filechooser.JFileChooserPanel;
import es.uvigo.ei.sing.hlfernandez.input.InputParameter;
import es.uvigo.ei.sing.hlfernandez.input.InputParametersPanel;
import es.uvigo.ei.sing.hlfernandez.text.JIntegerTextField;
import es.uvigo.ei.sing.s2p.core.entities.MascotIdentifications;
import es.uvigo.ei.sing.s2p.core.io.MaldiPlateLoader;
import es.uvigo.ei.sing.s2p.core.io.MascotCsvLoader;
import es.uvigo.ei.sing.s2p.core.operations.SpotMascotEntryPositionJoiner;
import es.uvigo.ei.sing.s2p.gui.components.dialog.AbstractFileInputJDialog;
import es.uvigo.ei.sing.s2p.gui.util.CommonFileChooser;
import es.uvigo.ei.sing.s2p.gui.util.CsvPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class LoadMascotIdentificationsDialog
extends AbstractFileInputJDialog {
    private static final long serialVersionUID = 1L;
    private JPanel inputComponentsPane;
    private JFileChooserPanel mascotFile;
    private JIntegerTextField mascotScoreThreshold;
    private CsvPanel mascotFileFormat;
    private JCheckBox mascotRemoveDuplicates;
    private JFileChooserPanel maldiPlateFile;
    protected Map<String, String> maldi;
    private MascotIdentifications mascotIdentifications;

    public LoadMascotIdentificationsDialog(Window parent) {
        super(parent);
    }

    protected String getDialogTitle() {
        return "Load Mascot identifications";
    }

    protected String getDescription() {
        return "This dialog allows you to load a set of Mascot identifications along with the MALDI plate.";
    }

    protected JPanel getInputComponentsPane() {
        this.inputComponentsPane = new InputParametersPanel(this.getInputParameters());
        return this.inputComponentsPane;
    }

    protected InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getMascotFileInput());
        parameters.add(this.getMascotFileFormatInput());
        InputParameter mascotThresholdInput = LoadMascotIdentificationsDialog.getMascotThresholdInput();
        this.mascotScoreThreshold = (JIntegerTextField)mascotThresholdInput.getInput();
        parameters.add(mascotThresholdInput);
        InputParameter mascotRemoveDuplicates = LoadMascotIdentificationsDialog.getMascotRemoveDuplicatesInput();
        this.mascotRemoveDuplicates = (JCheckBox)mascotRemoveDuplicates.getInput();
        parameters.add(mascotRemoveDuplicates);
        InputParameter maldiPlateFileInput = LoadMascotIdentificationsDialog.getMaldiPlateFileInput();
        this.maldiPlateFile = (JFileChooserPanel)maldiPlateFileInput.getInput();
        this.maldiPlateFile.addFileChooserListener(this::onMaldiFileSelection);
        parameters.add(maldiPlateFileInput);
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getMascotFileInput() {
        this.mascotFile = new JFileChooserPanel(JFileChooserPanel.Mode.OPEN, CommonFileChooser.getInstance().getFilechooser());
        this.mascotFile.getComponentLabelFile().setVisible(false);
        this.mascotFile.addFileChooserListener(this::onMascotFileSelection);
        return new InputParameter("Mascot identifications", (JComponent)this.mascotFile, "A .CSV file containing the Mascot identifications.");
    }

    private InputParameter getMascotFileFormatInput() {
        this.mascotFileFormat = new CsvPanel();
        this.mascotFileFormat.addCsvListener(this::onCsvFormatChanged);
        return new InputParameter("CSV format", (JComponent)((Object)this.mascotFileFormat), "The format of the .CSV file.");
    }

    protected static InputParameter getMascotRemoveDuplicatesInput() {
        JCheckBox mascotRemoveDuplicates = new JCheckBox();
        return new InputParameter("Remove duplicates", (JComponent)mascotRemoveDuplicates, "Check this option to remove duplicated entries.");
    }

    protected static InputParameter getMascotThresholdInput() {
        JIntegerTextField mascotScoreThreshold = new JIntegerTextField(Integer.valueOf(0));
        return new InputParameter("Minimum Mascot Score", (JComponent)mascotScoreThreshold, "The minimum Mascot Score.");
    }

    protected static InputParameter getMaldiPlateFileInput() {
        JFileChooserPanel maldiPlateFile = new JFileChooserPanel(JFileChooserPanel.Mode.OPEN, CommonFileChooser.getInstance().getFilechooser());
        maldiPlateFile.getComponentLabelFile().setVisible(false);
        return new InputParameter("Maldi plate", (JComponent)maldiPlateFile, "A .mpl file containing the Maldi plate.");
    }

    private void onMascotFileSelection(ChangeEvent e) {
        this.checkOkButton();
    }

    private void onCsvFormatChanged(ChangeEvent e) {
        this.pack();
        this.checkOkButton();
    }

    private MascotIdentifications loadMascotIdentifications() throws IOException {
        File selectedFile = this.mascotFile.getSelectedFile();
        int mascotThreshold = this.mascotScoreThreshold.getValue();
        CsvFormat csvFormat = this.mascotFileFormat.getConvertedCsvFormat();
        boolean removeDuplicates = this.mascotRemoveDuplicates.isSelected();
        return MascotCsvLoader.load((File)selectedFile, (CsvFormat)csvFormat, (int)mascotThreshold, (boolean)removeDuplicates);
    }

    private void onMaldiFileSelection(ChangeEvent e) {
        File selectedFile = this.maldiPlateFile.getSelectedFile();
        try {
            this.maldi = MaldiPlateLoader.readFile((File)selectedFile).asMap();
        }
        catch (IOException | ClassNotFoundException e1) {
            this.maldi = null;
            this.showError("Can't load the maldi plate from " + selectedFile + " (" + e1.toString() + ")");
        }
        this.checkOkButton();
    }

    protected void checkOkButton() {
        boolean enabled = this.mascotFileFormat.isValidFormat() && this.mascotFile.getSelectedFile() != null && this.mascotFile.getSelectedFile().isFile() && this.maldi != null;
        this.okButton.setEnabled(enabled);
    }

    public void setVisible(boolean b) {
        this.pack();
        super.setVisible(b);
    }

    public Map<String, MascotIdentifications> getMascotIdentifications() {
        return SpotMascotEntryPositionJoiner.join(this.getMaldiPlate(), (MascotIdentifications)this.getMascotEntries());
    }

    protected Map<String, String> getMaldiPlate() {
        return this.maldi;
    }

    protected MascotIdentifications getMascotEntries() {
        return this.mascotIdentifications;
    }

    protected JIntegerTextField getMascotScoreThresholdTextField() {
        return this.mascotScoreThreshold;
    }

    protected JCheckBox getMascotRemoveDuplicatesCheckbox() {
        return this.mascotRemoveDuplicates;
    }

    protected void onOkButtonEvent(ActionEvent event) {
        try {
            this.mascotIdentifications = this.loadMascotIdentifications();
            super.onOkButtonEvent(event);
        }
        catch (IOException e) {
            this.showError("Can't load mascot identifications.");
        }
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog((Component)((Object)this), message, "Error", 0);
    }
}

