/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.math.statistical.tests;

import es.uvigo.ei.sing.math.statistical.UnsupportedMatrixException;
import es.uvigo.ei.sing.math.statistical.corrections.Correction;
import es.uvigo.ei.sing.math.statistical.tests.TestOfIndependence;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractTestOfIndependence
implements TestOfIndependence,
Serializable {
    private static final long serialVersionUID = 1L;

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public double[] multiTest(int[][] ... matrices) throws UnsupportedMatrixException, InterruptedException {
        this.checkInterrupted();
        double[] pValues = new double[matrices.length];
        int i = 0;
        while (i < pValues.length) {
            pValues[i] = this.test(matrices[i]);
            this.checkInterrupted();
            ++i;
        }
        return pValues;
    }

    @Override
    public double[] multiTest(List<int[][]> matrices) throws UnsupportedMatrixException, InterruptedException {
        return this.multiTest((int[][][])matrices.toArray((T[])new int[matrices.size()][][]));
    }

    @Override
    public TestOfIndependence.Probabilities[] correctedMultiTest(Correction correction, int[][] ... matrices) throws UnsupportedMatrixException, InterruptedException {
        this.checkInterrupted();
        double[] pValues = this.multiTest(matrices);
        this.checkInterrupted();
        double[] qValues = correction.correct(pValues);
        TestOfIndependence.Probabilities[] probabilities = new TestOfIndependence.Probabilities[pValues.length];
        int i = 0;
        while (i < probabilities.length) {
            probabilities[i] = new DefaultProbabilities(pValues[i], qValues[i]);
            this.checkInterrupted();
            ++i;
        }
        return probabilities;
    }

    @Override
    public TestOfIndependence.Probabilities[] correctedMultiTest(Correction correction, List<int[][]> matrices) throws UnsupportedMatrixException, InterruptedException {
        return this.correctedMultiTest(correction, (int[][][])matrices.toArray((T[])new int[matrices.size()][][]));
    }

    private final class DefaultProbabilities
    implements TestOfIndependence.Probabilities,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final double pValue;
        private final double qValue;

        public DefaultProbabilities(double pValue, double qValue) {
            this.pValue = pValue;
            this.qValue = qValue;
        }

        @Override
        public double getPValue() {
            return this.pValue;
        }

        @Override
        public double getQValue() {
            return this.qValue;
        }

        public String toString() {
            return "[" + this.pValue + ", " + this.qValue + "]";
        }
    }
}

