/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.CoreUtils;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.core.operation.annotation.Direction;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.InputGUI;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.ParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ParamProviderFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class ParamsWindow
extends JDialog
implements InputGUI {
    private static final long serialVersionUID = 1L;
    private static final String BUTTONICON_CANCEL = "paramswindow.buttonicon.cancel";
    private static final String BUTTONTEXT_CANCEL = "paramswindow.buttontext.cancel";
    private static final String BUTTONTEXT_OK = "paramswindow.buttontext.ok";
    private static final String BUTTONICON_OK = "paramswindow.buttonicon.ok";
    private static final String BUTTONTEXT_HELP = "paramswindow.buttontext.help";
    private static final String BUTTONICON_HELP = "paramswindow.buttonicon.help";
    static Logger logger = Logger.getLogger((String)ParamsWindow.class.getName());
    JTextArea textArea = null;
    JPanel buttonsPanel = null;
    private OperationDefinition<?> operation;
    private Object operationObject;
    private List<ParamProvider> providers = new ArrayList<ParamProvider>();
    private boolean wasCancelled = false;
    private ParamsReceiver receiver;
    public static ClipboardItem preferredClipboardItem;
    private JPanel inputComponents;
    private JButton okButton;
    private boolean finished = false;
    private boolean autoresize = true;

    public ParamsWindow() {
        super(Workbench.getInstance().getMainFrame());
    }

    public JPanel createInputComponents() {
        if (this.inputComponents != null) {
            throw new RuntimeException("Can't create input components twice (app bug)");
        }
        List<Port> incomingPorts = this.getIncomingPorts();
        Map<Port, Class<?>> portClass = this.getPortClasses(incomingPorts);
        ArrayList<Port> incomingVisiblePorts = new ArrayList<Port>();
        ArrayList<Port> incomingAdvancedPorts = new ArrayList<Port>();
        for (Port p : incomingPorts) {
            if (p.advanced()) {
                incomingAdvancedPorts.add(p);
                continue;
            }
            incomingVisiblePorts.add(p);
        }
        JPanel advancedPortsPane = null;
        if (!incomingAdvancedPorts.isEmpty()) {
            advancedPortsPane = this.createParamsPanel(incomingAdvancedPorts, portClass);
        }
        JPanel basicPortsPane = this.createParamsPanel(incomingVisiblePorts, portClass);
        JPanel toret = new JPanel(new BorderLayout());
        toret.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        toret.add((Component)basicPortsPane, "North");
        if (!incomingAdvancedPorts.isEmpty()) {
            toret.add(this.createAdvancedOptionsTaskPaneContainer(advancedPortsPane), "Center");
        }
        return toret;
    }

    protected List<Port> getIncomingPorts() {
        ArrayList<Port> incomingPorts = new ArrayList<Port>();
        for (Port p : this.operation.getPorts()) {
            if (p.direction() == Direction.OUTPUT) continue;
            incomingPorts.add(p);
        }
        return incomingPorts;
    }

    private Map<Port, Class<?>> getPortClasses(List<Port> incomingPorts) {
        HashMap portClass = new HashMap();
        int i = 0;
        for (Class clazz : this.operation.getIncomingArgumentTypes()) {
            portClass.put(incomingPorts.get(i++), clazz);
        }
        return portClass;
    }

    private Component createAdvancedOptionsTaskPaneContainer(JPanel advancedPortsPane) {
        JXTaskPaneContainer advancedOptionsTaskPaneContainer = new JXTaskPaneContainer();
        advancedOptionsTaskPaneContainer.setOpaque(false);
        JXTaskPane advancedOptionsTaskPane = new JXTaskPane();
        advancedOptionsTaskPane.setTitle(this.getAdvancedOptionsTitle());
        advancedOptionsTaskPane.setCollapsed(true);
        advancedOptionsTaskPane.addPropertyChangeListener("collapsed", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ParamsWindow.this._pack();
            }
        });
        advancedOptionsTaskPane.add((Component)advancedPortsPane, (Object)"Center");
        advancedOptionsTaskPaneContainer.add((Component)advancedOptionsTaskPane);
        return advancedOptionsTaskPaneContainer;
    }

    private String getAdvancedOptionsTitle() {
        String showHelp = Workbench.CONFIG.getProperty("paramswindow.advancedoptionstitle");
        if (showHelp != null) {
            return showHelp;
        }
        return "Advanced options";
    }

    protected final JPanel createParamsPanel(List<Port> ports, Map<Port, Class<?>> portClass) {
        JPanel toret = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        toret.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        int i = 0;
        boolean first = true;
        for (Port incomingPort : ports) {
            JLabel nameLabel = new JLabel(incomingPort.name());
            nameLabel.setHorizontalAlignment(4);
            nameLabel.setVerticalAlignment(1);
            nameLabel.setAlignmentX(0.0f);
            c.gridx = 0;
            c.gridy = i + 1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(10, 12, 5, 5);
            layout.setConstraints(nameLabel, c);
            toret.add(nameLabel);
            ParamProvider provider = this.getParamProvider(incomingPort, portClass.get(incomingPort), this.operationObject);
            if (provider == null) continue;
            provider.init();
            this.providers.add(provider);
            JComponent component = provider.getComponent();
            if (component == null) continue;
            component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent arg0) {
                    ParamsWindow.this._pack();
                }
            });
            c.gridx = 1;
            c.gridy = i + 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(5, 12, 5, 5);
            layout.setConstraints(component, c);
            toret.add(component);
            if (first) {
                component.requestFocus();
                first = false;
            }
            JLabel descriptionComponent = null;
            String showHelp = Workbench.CONFIG.getProperty("paramswindow.showhelpicon");
            if (showHelp != null && showHelp.equalsIgnoreCase("true") && incomingPort.description() != null && incomingPort.description().length() > 0) {
                JLabel iconLabel = new JLabel();
                String iconFile = Workbench.CONFIG.getProperty("paramswindow.helpicon");
                URL imageURL = Util.getGlobalResourceURL((String)iconFile);
                iconLabel.setIcon(new ImageIcon(iconFile == null ? this.getClass().getResource("dialog-help.png") : imageURL));
                iconLabel.setToolTipText(incomingPort.description());
                descriptionComponent = iconLabel;
            } else {
                descriptionComponent = new JLabel(incomingPort.description());
            }
            c.gridx = 2;
            c.gridy = i + 1;
            c.anchor = 10;
            c.weightx = 0.0;
            layout.setConstraints(descriptionComponent, c);
            toret.add(descriptionComponent);
            this.setResizable(true);
            ++i;
        }
        return toret;
    }

    protected ParamProvider getParamProvider(Port p, Class<?> c, Object op) {
        return ParamProviderFactory.createParamProvider(this.receiver, p, c, op);
    }

    private JTextArea getDescriptionPane() {
        if (this.textArea == null) {
            this.textArea = new JTextArea(this.operation.getDescription());
            this.textArea.setMargin(new Insets(10, 10, 10, 10));
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setEditable(false);
            this.textArea.setBackground(Color.WHITE);
            this.textArea.setOpaque(true);
        }
        return this.textArea;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new FlowLayout());
            JButton okButton = this.getOKButton();
            this.getRootPane().setDefaultButton(okButton);
            String cancelButtonLabel = Workbench.CONFIG.getProperty(BUTTONTEXT_CANCEL);
            if (cancelButtonLabel == null) {
                cancelButtonLabel = "Cancel";
            }
            JButton cancelButton = new JButton(cancelButtonLabel);
            String iconFile = Workbench.CONFIG.getProperty(BUTTONICON_CANCEL);
            if (iconFile != null) {
                URL imageURL = Util.getGlobalResourceURL((String)iconFile);
                cancelButton.setIcon(new ImageIcon(imageURL));
            }
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamsWindow.this.wasCancelled = true;
                    ParamsWindow.this.dispose();
                    ParamsWindow.this.receiver.cancel();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ParamsWindow.this.wasCancelled = true;
                }
            });
            this.buttonsPanel.add(okButton);
            this.buttonsPanel.add(cancelButton);
            if (this.operation.getHelp() != null && !this.operation.getHelp().trim().equals("")) {
                JButton helpButton;
                String helpButtonLabel = Workbench.CONFIG.getProperty(BUTTONTEXT_HELP);
                if (helpButtonLabel == null) {
                    helpButtonLabel = "Help";
                }
                if (CoreUtils.isValidURL((String)this.operation.getHelp())) {
                    helpButton = new JButton(new AbstractAction(helpButtonLabel){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                CoreUtils.openURL((String)ParamsWindow.this.operation.getHelp());
                            }
                            catch (Exception e1) {
                                JOptionPane.showMessageDialog(Workbench.getInstance().getMainFrame(), "The help URL(" + ParamsWindow.this.operation.getHelp() + ") couldn't be opened.", "Help Unavailable", 0);
                            }
                        }
                    });
                    this.buttonsPanel.add(helpButton);
                } else {
                    helpButton = new JButton(helpButtonLabel);
                    HelpBroker helpBroker = Core.getInstance().getHelpBroker();
                    if (helpBroker != null) {
                        helpBroker.enableHelpOnButton((Component)helpButton, this.operation.getHelp(), helpBroker.getHelpSet());
                        helpBroker.enableHelpKey((Component)this.getContentPane(), this.operation.getHelp(), helpBroker.getHelpSet());
                        this.buttonsPanel.add(helpButton);
                    }
                }
                String helpIconFile = Workbench.CONFIG.getProperty(BUTTONICON_HELP);
                if (helpIconFile != null) {
                    URL imageURL = Util.getGlobalResourceURL((String)helpIconFile);
                    helpButton.setIcon(new ImageIcon(imageURL));
                }
            }
        }
        return this.buttonsPanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescriptionPane(), "North");
        this.inputComponents = this.createInputComponents();
        JScrollPane scroll = new JScrollPane(this.inputComponents);
        this.add((Component)scroll, "Center");
        this.add((Component)this.getButtonsPane(), "South");
    }

    private JButton getOKButton() {
        if (this.okButton == null) {
            String okButtonLabel = Workbench.CONFIG.getProperty(BUTTONTEXT_OK);
            if (okButtonLabel == null) {
                okButtonLabel = "OK";
            }
            this.okButton = new JButtonOk(okButtonLabel);
            String iconFile = Workbench.CONFIG.getProperty(BUTTONICON_OK);
            if (iconFile != null) {
                URL imageURL = Util.getGlobalResourceURL((String)iconFile);
                this.okButton.setIcon(new ImageIcon(imageURL));
            }
            ((JButtonOk)this.okButton).checkEnabled();
        }
        return this.okButton;
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamsWindow.this.wasCancelled = true;
                ParamsWindow.this.dispose();
            }
        }, stroke, 2);
        return rootPane;
    }

    private ParamSpec[] getParamSpec() {
        if (this.wasCancelled) {
            return null;
        }
        ParamSpec[] ret = new ParamSpec[this.providers.size()];
        int i = 0;
        for (ParamProvider provider : this.providers) {
            ret[i++] = provider.getParamSpec();
        }
        return ret;
    }

    private void centerOnOwner() {
        Rectangle rectOwner = this.getParent().getBounds();
        Rectangle rectDialog = this.getBounds();
        this.setLocation(rectOwner.x + rectOwner.width / 2 - rectDialog.width / 2, rectOwner.y + rectOwner.height / 2 - rectDialog.height / 2);
    }

    @Override
    public synchronized void finish() {
        if (!this.finished) {
            this.finished = true;
            this.setVisible(false);
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"finishing params window");
            }
            for (ParamProvider p : this.providers) {
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)("finishing param provider of class " + p.getClass()));
                }
                p.finish();
            }
        }
    }

    @Override
    public void init(ParamsReceiver receiver, OperationDefinition<?> operation) {
        this.receiver = receiver;
        this.operation = operation;
        this.setTitle(operation.getName());
        this.setModal(true);
        this.initialize();
        this._pack();
        this.setSize(new Dimension(this.getWidth() + 20, this.getHeight() + 40));
        this.centerOnOwner();
        if (operation.getIncomingArgumentTypes().isEmpty()) {
            this.getOKButton().doClick();
        } else {
            this.setVisible(true);
        }
    }

    @Override
    public void onValidationError(Throwable t) {
        JOptionPane.showMessageDialog(this, t.getMessage(), "Input not valid", 2);
        this.okButton.setEnabled(true);
    }

    private void _pack() {
        if (!this.autoresize) {
            return;
        }
        this.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (this.getHeight() > ge.getMaximumWindowBounds().height - 100) {
            this.autoresize = false;
            this.setSize(this.getWidth() + 50, ge.getMaximumWindowBounds().height - 100);
        }
        if (this.getWidth() > ge.getMaximumWindowBounds().width - 100) {
            this.autoresize = false;
            this.setSize(ge.getMaximumWindowBounds().width - 100, this.getHeight() + 50);
        }
    }

    private class JButtonOk
    extends JButton
    implements Observer,
    ActionListener,
    ClipboardListener {
        private static final long serialVersionUID = 1L;

        public JButtonOk(String label) {
            super(label);
            this.addActionListener(this);
            for (ParamProvider provider : ParamsWindow.this.providers) {
                if (!(provider instanceof Observable)) continue;
                ((Observable)((Object)provider)).addObserver(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 2) == 0) {
                ParamsWindow.this.okButton.setEnabled(false);
                ParamSpec[] spec = ParamsWindow.this.getParamSpec();
                ParamsWindow.this.receiver.paramsIntroduced(spec);
            }
        }

        public void checkEnabled() {
            boolean enabled = true;
            for (ParamProvider provider : ParamsWindow.this.providers) {
                if (provider.isValidValue()) continue;
                enabled = false;
            }
            this.setEnabled(enabled);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.checkEnabled();
        }

        public void elementAdded(ClipboardItem item) {
            this.checkEnabled();
        }

        public void elementRemoved(ClipboardItem item) {
            this.checkEnabled();
        }
    }
}

