/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import jdk.internal.instrumentation.ClassInstrumentation;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.Logger;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class Tracer {
    private final List<InstrumentationData> items = new ArrayList<InstrumentationData>();
    private static final Tracer singleton;

    private Tracer() {
    }

    @CallerSensitive
    public static Tracer getInstance() {
        Class<?> clazz = Reflection.getCallerClass();
        if (!VM.isSystemDomainLoader(clazz.getClassLoader())) {
            throw new SecurityException("Only classes in the system domain can get a Tracer instance");
        }
        return singleton;
    }

    public synchronized void addInstrumentations(List<Class<?>> list, Logger logger) throws ClassNotFoundException {
        if (logger == null) {
            throw new IllegalArgumentException("logger can't be null");
        }
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz : list) {
            InstrumentationTarget instrumentationTarget = clazz.getAnnotation(InstrumentationTarget.class);
            InstrumentationData instrumentationData = new InstrumentationData();
            instrumentationData.instrumentation = clazz;
            instrumentationData.target = Class.forName(instrumentationTarget.value(), true, clazz.getClassLoader());
            instrumentationData.logger = logger;
            arrayList.add(instrumentationData.target);
            this.items.add(instrumentationData);
        }
        Tracer.retransformClasses0(arrayList.toArray(new Class[0]));
    }

    private byte[] transform(Class<?> clazz, byte[] byArray) {
        byte[] byArray2 = byArray;
        for (InstrumentationData instrumentationData : this.items) {
            if (!instrumentationData.target.equals(clazz)) continue;
            try {
                instrumentationData.logger.trace("Processing instrumentation class: " + instrumentationData.instrumentation);
                byArray2 = new ClassInstrumentation(instrumentationData.instrumentation, clazz.getName(), byArray2, instrumentationData.logger).getNewBytes();
            }
            catch (Throwable throwable) {
                instrumentationData.logger.error("Failure during class instrumentation:", throwable);
            }
        }
        if (byArray2 == byArray) {
            return null;
        }
        return byArray2;
    }

    private static native void retransformClasses0(Class<?>[] var0);

    private static byte[] retransformCallback(Class<?> clazz, byte[] byArray) {
        return singleton.transform(clazz, byArray);
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("bci");
                return null;
            }
        }, null, new RuntimePermission("loadLibrary.bci"));
        singleton = new Tracer();
        Tracer.init();
    }

    private final class InstrumentationData {
        Class<?> instrumentation;
        Class<?> target;
        Logger logger;

        private InstrumentationData() {
        }
    }
}

