/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine.version;

import org.platonos.pluginengine.version.PluginDependencyMinMaxVersion;
import org.platonos.pluginengine.version.PluginDependencySingleVersion;
import org.platonos.pluginengine.version.PluginSingleVersion;

public final class PluginInstanceVersion
extends PluginSingleVersion {
    private final String buildVersion;

    public PluginInstanceVersion() {
        this(0, 0, 0, "");
    }

    public PluginInstanceVersion(int releaseVersion) {
        this(releaseVersion, 0, 0, "");
    }

    public PluginInstanceVersion(int releaseVersion, int updateVersion) {
        this(releaseVersion, updateVersion, 0, "");
    }

    public PluginInstanceVersion(int releaseVersion, int updateVersion, int patchVersion) {
        this(releaseVersion, updateVersion, patchVersion, "");
    }

    public PluginInstanceVersion(int releaseVersion, int updateVersion, int patchVersion, String buildVersion) {
        super(releaseVersion, updateVersion, patchVersion);
        this.buildVersion = buildVersion.trim();
    }

    public final String getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    public String getFullVersion() {
        return String.format("%d.%d.%d", this.getReleaseVersion(), this.getUpdateVersion(), this.getPatchVersion());
    }

    @Override
    public int compareTo(PluginDependencyMinMaxVersion version) {
        return -version.compareTo(this);
    }

    @Override
    public int compareTo(PluginDependencySingleVersion version) {
        return -version.compareTo(this);
    }

    @Override
    public int compareTo(PluginInstanceVersion version) {
        int otherRelease;
        int thisRelease = this.getReleaseVersion();
        if (thisRelease == (otherRelease = version.getReleaseVersion())) {
            int otherUpdate;
            int thisUptade = this.getUpdateVersion();
            if (thisUptade == (otherUpdate = version.getUpdateVersion())) {
                int otherPatch;
                int thisPatch = this.getPatchVersion();
                if (thisPatch == (otherPatch = version.getPatchVersion())) {
                    return 0;
                }
                return thisPatch < otherPatch ? -1 : 1;
            }
            return thisUptade < otherUpdate ? -1 : 1;
        }
        return thisRelease < otherRelease ? -1 : 1;
    }

    public boolean equals(Object object) {
        if (object instanceof PluginInstanceVersion) {
            PluginInstanceVersion version = (PluginInstanceVersion)object;
            return version.getReleaseVersion() == this.getReleaseVersion() && version.getUpdateVersion() == this.getUpdateVersion() && version.getPatchVersion() == this.getPatchVersion() && version.getBuildVersion().equals(this.getBuildVersion());
        }
        return false;
    }

    public String toString() {
        String release = this.getReleaseVersion() <= 0 ? "0" : Integer.toString(this.getReleaseVersion());
        String update = this.getUpdateVersion() <= 0 ? "0" : Integer.toString(this.getUpdateVersion());
        String patch = this.getPatchVersion() <= 0 ? "0" : Integer.toString(this.getPatchVersion());
        String build = this.getBuildVersion().trim();
        if (build == null || build.length() == 0) {
            return String.format("%s.%s.%s", release, update, patch);
        }
        return String.format("%s.%s.%s %s", release, update, patch, build);
    }
}

