/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.table;

import es.uvigo.ei.sing.s2p.gui.table.BasicTransferable;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

public class CSVTransferHandler
extends TransferHandler
implements UIResource {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Converter> converters = new Hashtable<Integer, Converter>();

    public void setConverter(int modelColumn, Converter format) {
        this.converters.put(modelColumn, format);
    }

    public Converter getConverter(int modelColumn) {
        return this.converters.get(modelColumn);
    }

    public void removeConverter(int modelColumn) {
        this.converters.remove(modelColumn);
    }

    @Override
    protected BasicTransferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            int[] cols;
            int counter;
            int[] rows;
            JTable table = (JTable)c;
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                int rowCount = table.getRowCount();
                rows = new int[rowCount];
                for (counter = 0; counter < rowCount; ++counter) {
                    rows[counter] = counter;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (!table.getColumnSelectionAllowed()) {
                int colCount = table.getColumnCount();
                cols = new int[colCount];
                for (counter = 0; counter < colCount; ++counter) {
                    cols[counter] = counter;
                }
            } else {
                cols = table.getSelectedColumns();
            }
            if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                return null;
            }
            StringBuilder plainSB = new StringBuilder();
            StringBuilder htmlSB = new StringBuilder();
            htmlSB.append("<html>\n<body>\n<table>\n");
            htmlSB.append("<tr>\n");
            for (int col : cols) {
                String columnName = table.getColumnName(col);
                plainSB.append(columnName).append(',');
                htmlSB.append("  <th>" + columnName + "</th>\n");
            }
            htmlSB.append("</tr>\n");
            plainSB.replace(plainSB.length() - 1, plainSB.length(), "\n");
            for (int row = 0; row < rows.length; ++row) {
                htmlSB.append("<tr>\n");
                for (int col = 0; col < cols.length; ++col) {
                    Object obj = table.getValueAt(rows[row], cols[col]);
                    int modelIndex = table.convertColumnIndexToModel(cols[col]);
                    if (this.converters.containsKey(modelIndex)) {
                        obj = this.converters.get(modelIndex).convert(obj);
                    }
                    String val = obj == null ? "" : obj.toString();
                    plainSB.append(val + ",");
                    htmlSB.append("  <td>" + val + "</td>\n");
                }
                plainSB.deleteCharAt(plainSB.length() - 1).append("\n");
                htmlSB.append("</tr>\n");
            }
            plainSB.deleteCharAt(plainSB.length() - 1);
            htmlSB.append("</table>\n</body>\n</html>");
            return new BasicTransferable(plainSB.toString(), htmlSB.toString());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    public static interface Converter {
        public Object convert(Object var1);
    }
}

