/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.hlfernandez.filechooser;

import es.uvigo.ei.sing.hlfernandez.ComponentFactory;
import es.uvigo.ei.sing.hlfernandez.filechooser.FileChooserListener;
import es.uvigo.ei.sing.hlfernandez.utilities.FileDrop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JFileChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ICON_BROWSE = new ImageIcon(JFileChooserPanel.class.getResource("icons/browse.png"));
    private JFileChooser filechooser;
    private Mode mode;
    private AbstractAction browseAction;
    private JButton btnBrowse;
    private JLabel lblFile;
    private String lblFileText;
    private JTextField fileName;
    private File selectedFile = null;
    private String requiredFileExtension = null;

    public JFileChooserPanel(Mode mode) {
        this(mode, new JFileChooser(), ICON_BROWSE, "File: ", null);
    }

    public JFileChooserPanel(Mode mode, String requiredFileExtension) {
        this(mode, new JFileChooser(), ICON_BROWSE, "File: ", requiredFileExtension);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, String requiredFileExtension) {
        this(mode, filechooser, ICON_BROWSE, "File: ", requiredFileExtension);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser) {
        this(mode, filechooser, ICON_BROWSE, "File: ", null);
    }

    public JFileChooserPanel(Mode mode, JFileChooser filechooser, ImageIcon browseIcon, String labelFileText, String requiredFileExtension) {
        this.filechooser = filechooser;
        this.lblFileText = labelFileText;
        if (mode.equals((Object)Mode.SAVE)) {
            this.requiredFileExtension = requiredFileExtension;
        }
        this.mode = mode;
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.lblFile = new JLabel(this.lblFileText);
        this.fileName = new JTextField("", 20);
        this.fileName.setEditable(false);
        this.fileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JFileChooserPanel.this.fileNameUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.fileName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 3) {
                    JFileChooserPanel.this.onBrowse();
                }
            }
        });
        new FileDrop(this.fileName, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                if (files.length > 0) {
                    JFileChooserPanel.this.setSelectedFile(files[0]);
                }
            }
        });
        this.browseAction = new AbstractAction("Browse", ICON_BROWSE){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooserPanel.this.onBrowse();
            }
        };
        this.btnBrowse = ComponentFactory.createButton(this.browseAction, true, "Browse file", false);
        this.add((Component)this.lblFile, "West");
        this.add((Component)this.fileName, "Center");
        this.add((Component)this.btnBrowse, "East");
    }

    private void fileNameUpdated() {
        this.fireFileChoosedEvent();
    }

    private void fireFileChoosedEvent() {
        Arrays.asList(this.getFileChooserListeners()).forEach(l -> l.onFileChoosed(new ChangeEvent(this)));
    }

    private void onBrowse() {
        int returnVal;
        JFileChooser fileChooser = this.getFilechooser();
        int n = returnVal = this.mode.equals((Object)Mode.SAVE) ? fileChooser.showSaveDialog(this) : fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.setSelectedFile(fileChooser.getSelectedFile());
        }
    }

    public void setSelectedFile(File file) {
        this.selectedFile = file;
        if (this.requiredFileExtension != null && !file.getName().toLowerCase().endsWith("." + this.requiredFileExtension)) {
            this.selectedFile = new File(file.getAbsolutePath() + "." + this.requiredFileExtension);
        }
        this.fileName.setText(this.selectedFile.getAbsolutePath());
        this.fileName.setToolTipText(this.selectedFile.getAbsolutePath());
        this.filechooser.setSelectedFile(file);
    }

    public JFileChooser getFilechooser() {
        return this.filechooser;
    }

    public AbstractAction getBrowseAction() {
        return this.browseAction;
    }

    public JLabel getComponentLabelFile() {
        return this.lblFile;
    }

    public JTextField getComponentFileName() {
        return this.fileName;
    }

    public JButton getComponentButtonBrowse() {
        return this.btnBrowse;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public synchronized void addFileChooserListener(FileChooserListener l) {
        this.listenerList.add(FileChooserListener.class, l);
    }

    public synchronized FileChooserListener[] getFileChooserListeners() {
        return (FileChooserListener[])this.listenerList.getListeners(FileChooserListener.class);
    }

    public static enum Mode {
        OPEN,
        SAVE;

    }
}

