/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.Launcher;
import es.uvigo.ei.aibench.Util;
import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.CoreListener;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import es.uvigo.ei.aibench.workbench.Data;
import es.uvigo.ei.aibench.workbench.OperationWrapper;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.interfaces.IViewFactory;
import es.uvigo.ei.aibench.workbench.tablelayout.TableLayout;
import es.uvigo.ei.aibench.workbench.utilities.CloseableJTabbedPane;
import es.uvigo.ei.aibench.workbench.utilities.TabCloseAdapter;
import es.uvigo.ei.aibench.workbench.utilities.TabCloseEvent;
import es.uvigo.ei.aibench.workbench.utilities.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MainWindow.class);
    private final int MAX_TAB_TITLE = 20;
    private List<OperationWrapper> interceptedOperations = null;
    private HashMap<ClipboardItem, Integer> tabIndexByData = new HashMap();
    private HashMap<Integer, ClipboardItem> dataByTab = new HashMap();
    private HashMap<String, JComponent> componentMappings = new HashMap();
    private HashMap<String, TableLayout.Slot> slotMappings = new HashMap();
    String STATUS_DEFAULT_TEXT = Workbench.CONFIG.getProperty("mainwindow.statusbar.text");
    private JLabel statusBar = new JLabel(this.STATUS_DEFAULT_TEXT);
    private JToolBar toolbar = null;
    private TableLayout tableLayout;
    private String DEFAULT_LAYOUT = "<table><row><cell><components id='left'/></cell><cell><table><row><cell><document_viewer /></cell><cell><components id='right'/></cell></row><row><cell><components id='bottom'/></cell></row></table></cell><!--<cell><components id='left'/></cell>--></row></table>";
    private JMenuBar jJMenuBar = null;
    private CloseableJTabbedPane documentTabbedPane = null;

    public MainWindow(List<OperationWrapper> operaciones) {
        logger.info((Object)"MainWindow creation");
        this.interceptedOperations = operaciones;
        String path = System.getProperty("aibench.paths.template.conf", "conf/template.xml");
        URL url = Util.getGlobalResourceURL((String)path);
        try {
            this.tableLayout = new TableLayout(url.openStream());
        }
        catch (IOException e) {
            logger.warn((Object)("Not found a template file, searching in: " + url + " Using default layout...."));
            this.tableLayout = new TableLayout(new ByteArrayInputStream(this.DEFAULT_LAYOUT.getBytes()));
            e.printStackTrace();
        }
        this.initialize();
        this.setSize(new Dimension(800, 600));
    }

    public void packSplitters() {
        this.tableLayout.packSplitters();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
    }

    private void initialize() {
        String toolbarVisible;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDialog dialog = new JDialog((Frame)null, "Shutdown");
                JLabel lbl = new JLabel("Shutting down AIBench...");
                int borderSize = 16;
                lbl.setOpaque(true);
                lbl.setBackground(Color.WHITE);
                lbl.setAlignmentY(0.5f);
                lbl.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
                dialog.getContentPane().add(lbl);
                dialog.pack();
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                e.getWindow().dispose();
                new Thread(){

                    @Override
                    public void run() {
                        Launcher.getPluginEngine().shutdown();
                        System.exit(0);
                    }
                }.start();
            }
        });
        String title = Workbench.CONFIG.getProperty("mainwindow.title");
        if (title == null) {
            title = "AIBench";
        }
        this.setTitle(title);
        JMenuBar menuBar = this.getJJMenuBar();
        if (Workbench.CONFIG.getProperty("mainwindow.menubar.visible") == null || !Workbench.CONFIG.getProperty("mainwindow.menubar.visible").equals("false")) {
            this.setJMenuBar(menuBar);
        }
        if ((toolbarVisible = Workbench.CONFIG.getProperty("toolbar.visible")) != null && toolbarVisible.equals("true")) {
            boolean shownames = Workbench.CONFIG.getProperty("toolbar.showOperationNames").equals("true");
            HashMap<Integer, 2> buttons = new HashMap<Integer, 2>();
            this.toolbar = new JToolBar("Operations Toolbar");
            for (final OperationDefinition op : Core.getInstance().getOperations()) {
                if (!Workbench.getInstance().isOperationViewableIn(op, "TOOLBAR")) continue;
                JButton button = new JButton(){
                    private static final long serialVersionUID = 1L;
                    {
                        Core.getInstance().addCoreListener(new CoreListener(){

                            public void operationDisabled(OperationDefinition<?> definition) {
                                if (definition == op) {
                                    this.setEnabled(false);
                                }
                            }

                            public void operationEnabled(OperationDefinition<?> definition) {
                                if (definition == op) {
                                    this.setEnabled(true);
                                }
                            }
                        });
                    }
                };
                button.setEnabled(op.isEnabled());
                if (shownames) {
                    button.setText(op.getName());
                }
                button.setToolTipText(op.getDescription());
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Workbench.getInstance().executeOperation(op);
                    }
                });
                ImageIcon bigicon = Workbench.getInstance().getOperationBigIcon(op);
                if (bigicon != null) {
                    button.setIcon(bigicon);
                } else {
                    button.setIcon(Workbench.getInstance().getOperationIcon(op));
                }
                if (op.getShortcut().replaceAll(" ", "").length() == 0) continue;
                buttons.put(Integer.parseInt(op.getShortcut().replaceAll(" ", "")), button);
            }
            String separatorString = Workbench.CONFIG.getProperty("toolbar.separators");
            ArrayList<Object> separators = new ArrayList<Object>();
            if (separatorString != null) {
                String[] separatorTokens = separatorString.replaceAll(" ", "").split(",");
                for (String sep : separatorTokens) {
                    if (sep.length() <= 0) continue;
                    separators.add(sep);
                }
            }
            Object[] buttonShortcuts = new Integer[buttons.size()];
            buttonShortcuts = buttons.keySet().toArray(buttonShortcuts);
            Arrays.sort(buttonShortcuts);
            block4: for (Object i : buttonShortcuts) {
                this.toolbar.add((Component)buttons.get(i));
                for (String string : separators) {
                    try {
                        if (Integer.parseInt(string) != (Integer)i) continue;
                        this.toolbar.addSeparator();
                        continue block4;
                    }
                    catch (NumberFormatException e) {
                        logger.error((Object)("The toolbar separators must be numbers!, found: " + string));
                    }
                }
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.tableLayout.getDocumentViewerPanel().setLayout(new BorderLayout());
        this.tableLayout.getDocumentViewerPanel().add((Component)this.getDocumentTabbedPane(), "Center");
        this.getContentPane().add((Component)this.tableLayout, "Center");
        if (Workbench.CONFIG.getProperty("mainwindow.statusbar.visible") == null || !Workbench.CONFIG.getProperty("mainwindow.statusbar.visible").equals("false")) {
            this.add((Component)this.statusBar, "South");
        }
        if (toolbarVisible != null && toolbarVisible.equals("true")) {
            String positionString = Workbench.CONFIG.getProperty("toolbar.position");
            String position = "North";
            int orientation = 0;
            if (positionString != null) {
                if (positionString.equalsIgnoreCase("SOUTH")) {
                    orientation = 0;
                    position = "South";
                } else if (positionString.equalsIgnoreCase("EAST")) {
                    orientation = 1;
                    position = "East";
                } else if (positionString.equalsIgnoreCase("WEST")) {
                    orientation = 1;
                    position = "West";
                }
            }
            this.toolbar.setOrientation(orientation);
            this.add((Component)this.toolbar, position);
        }
    }

    public CloseableJTabbedPane getDocumentTabbedPane() {
        if (this.documentTabbedPane == null) {
            this.documentTabbedPane = new CloseableJTabbedPane();
            this.documentTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ClipboardItem data;
                    int index = MainWindow.this.documentTabbedPane.getSelectedIndex();
                    if (index != -1 && (data = (ClipboardItem)MainWindow.this.dataByTab.get(index)) != null) {
                        Workbench.getInstance().setActiveData(data);
                    }
                }
            });
            this.documentTabbedPane.addTabCloseListener(new TabCloseAdapter(){

                @Override
                public void tabClosing(TabCloseEvent event) {
                    event.cancel();
                    ClipboardItem clipboardItem = (ClipboardItem)MainWindow.this.dataByTab.get(event.getTabIndex());
                    if (clipboardItem != null) {
                        Workbench.getInstance().hideData(clipboardItem);
                    } else {
                        MainWindow.this.documentTabbedPane.removeTabAt(event.getTabIndex());
                    }
                }
            });
            this.documentTabbedPane.setPreferredSize(new Dimension(640, 480));
        }
        return this.documentTabbedPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            List<OperationWrapper> operations = this.interceptedOperations;
            this.sortOperations(operations);
            for (OperationWrapper opw : operations) {
                if (!Workbench.getInstance().isOperationViewableIn(opw.getOperationDefinition(), "MENU")) continue;
                Utilities.putOperationInMenu(this.jJMenuBar, opw);
            }
        }
        return this.jJMenuBar;
    }

    private int getPositionForPathName(String pathElement) {
        String noAt = pathElement;
        int res = 0;
        if (pathElement.indexOf("@") != -1) {
            noAt = noAt.substring(noAt.indexOf("@") + 1);
        }
        if (Workbench.CONFIG.get("menu." + noAt) != null) {
            try {
                res = Integer.parseInt(Workbench.CONFIG.get("menu." + noAt).toString().trim());
            }
            catch (NumberFormatException ex) {
                logger.warn((Object)("Configuration error: Property menu." + noAt + " must be an integer"));
            }
        } else {
            res = pathElement.indexOf("@") != -1 ? Integer.parseInt(pathElement.substring(0, pathElement.indexOf("@"))) : 0;
        }
        return res;
    }

    private void sortOperations(List<OperationWrapper> operations) {
        Vector<OperationWrapper> res = new Vector<OperationWrapper>();
        while (operations.size() > 0) {
            int i;
            OperationWrapper currentOper = operations.remove(0);
            String path = currentOper.getOperationDefinition().getPath();
            if (path == null) continue;
            int currentNumber = 0;
            StringTokenizer tk = new StringTokenizer(path, "/");
            int pow_i = 5;
            while (tk.hasMoreTokens()) {
                String pathElement = tk.nextToken();
                if (pathElement.indexOf("@") != -1) {
                    currentNumber = (int)((double)currentNumber + (double)this.getPositionForPathName(pathElement) * Math.pow(10.0, pow_i));
                }
                --pow_i;
            }
            for (i = 0; i < res.size(); ++i) {
                String iPath = ((OperationWrapper)res.get(i)).getOperationDefinition().getPath();
                int iNumber = 0;
                StringTokenizer tk2 = new StringTokenizer(iPath, "/");
                int pow_j = 5;
                while (tk2.hasMoreTokens()) {
                    String pathElement = tk2.nextToken();
                    if (pathElement.indexOf("@") != -1) {
                        iNumber = (int)((double)iNumber + (double)this.getPositionForPathName(pathElement) * Math.pow(10.0, pow_j));
                    }
                    --pow_j;
                }
                if (iNumber > currentNumber) break;
            }
            res.insertElementAt(currentOper, i);
        }
        operations.addAll(res);
    }

    public void showViews(List<IViewFactory> views, final ClipboardItem data) {
        boolean hide_tabs;
        JComponent viewsComponent = null;
        boolean bl = hide_tabs = views.size() == 1 && Workbench.CONFIG.getProperty("documentviewer.hide_tabs_when_single_view") != null && Workbench.CONFIG.getProperty("documentviewer.hide_tabs_when_single_view").equals("true");
        if (hide_tabs) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            viewsComponent = panel;
        } else {
            JTabbedPane tabbedViews = new JTabbedPane();
            tabbedViews.setTabPlacement(3);
            viewsComponent = tabbedViews;
        }
        for (int i = 0; i < views.size(); ++i) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)("Adding view " + views.get(i)));
            }
            final IViewFactory view = views.get(i);
            class RenderingThread
            extends Thread {
                private JComponent viewsComponent;

                public RenderingThread(JComponent viewsComponent) {
                    this.viewsComponent = viewsComponent;
                }

                @Override
                public void run() {
                    final RenderingMessageComponent renderingMessage = new RenderingMessageComponent("Rendering view \"" + view.getViewName() + "\", please wait...");
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            JComponent jComponent = viewsComponent;
                            synchronized (jComponent) {
                                if (!hide_tabs) {
                                    ((JTabbedPane)viewsComponent).add((Component)renderingMessage, view.getViewName());
                                } else {
                                    viewsComponent.add((Component)renderingMessage, "Center");
                                    ((JPanel)viewsComponent).validate();
                                }
                            }
                        }
                    });
                    final JComponent component = view.getComponent(data.getUserData());
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            JComponent jComponent = viewsComponent;
                            synchronized (jComponent) {
                                if (!hide_tabs) {
                                    JTabbedPane tabbedViews = (JTabbedPane)viewsComponent;
                                    for (int i = 0; i < tabbedViews.getTabCount(); ++i) {
                                        if (tabbedViews.getComponentAt(i) != renderingMessage) continue;
                                        if (component instanceof Scrollable) {
                                            tabbedViews.setComponentAt(i, new JScrollPane(component));
                                            continue;
                                        }
                                        tabbedViews.setComponentAt(i, component);
                                    }
                                } else {
                                    ((JPanel)viewsComponent).remove(renderingMessage);
                                    if (component instanceof Scrollable) {
                                        ((JPanel)viewsComponent).add((Component)new JScrollPane(component), "Center");
                                    } else {
                                        ((JPanel)viewsComponent).add((Component)component, "Center");
                                        ((JPanel)viewsComponent).validate();
                                    }
                                }
                            }
                        }
                    });
                }
            }
            new RenderingThread(viewsComponent).start();
        }
        String title = data.getName();
        if (title.length() > 20) {
            title = title.substring(0, 20);
            title = title + "...";
        }
        this.getDocumentTabbedPane().addTab(title, null, viewsComponent);
        this.getDocumentTabbedPane().setSelectedIndex(this.getDocumentTabbedPane().indexOfComponent(viewsComponent));
        this.tabIndexByData.put(data, this.getDocumentTabbedPane().indexOfComponent(viewsComponent));
        this.dataByTab.put(this.getDocumentTabbedPane().indexOfComponent(viewsComponent), data);
    }

    public synchronized List<Component> getDataViews(ClipboardItem data) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.tabIndexByData.containsKey(data)) {
            int posicion = this.tabIndexByData.get(data);
            Component component = this.getDocumentTabbedPane().getComponentAt(posicion);
            if (component instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)component;
                for (int i = 0; i < pane.getComponentCount(); ++i) {
                    components.add(pane.getComponentAt(i));
                }
            } else {
                components.add(component);
            }
        }
        return components;
    }

    public synchronized void bringToFront(ClipboardItem data) {
        if (this.tabIndexByData.containsKey(data)) {
            int posicion = this.tabIndexByData.get(data);
            this.getDocumentTabbedPane().setSelectedIndex(posicion);
        }
    }

    public synchronized void hideData(ClipboardItem data) {
        if (this.tabIndexByData.containsKey(data)) {
            int index = this.tabIndexByData.get(data);
            this.getDocumentTabbedPane().remove(index);
            this.tabIndexByData.remove(data);
            for (int pos = index; pos < this.dataByTab.size() - 1; ++pos) {
                this.dataByTab.put(pos, this.dataByTab.get(pos + 1));
            }
            this.dataByTab.remove(this.dataByTab.size() - 1);
            for (Map.Entry<ClipboardItem, Integer> entry : this.tabIndexByData.entrySet()) {
                int posicion = entry.getValue();
                if (posicion <= index) continue;
                entry.setValue(--posicion);
            }
        } else {
            Core.getInstance().getGUI().warn("MainWindow.hideData(): Not opened data [ " + data.toString() + " ]");
        }
    }

    public void closeData(ClipboardItem data) {
    }

    public void dataActivated(Data data) {
    }

    public void dataSelected(boolean flag) {
    }

    public void dataChanged(Data data) {
    }

    public void dataUnloaded(Data data) {
    }

    public synchronized void putItemInSlot(String slotName, String componentName, String componentID, JComponent component) {
        if (this.slotMappings.get(componentID) != null) {
            this.slotMappings.get(componentID).remove(this.componentMappings.get(componentID));
            this.slotMappings.remove(componentID);
        }
        TableLayout.Slot slot = this.tableLayout.getSlotByID(slotName);
        this.slotMappings.put(componentID, slot);
        if (slot != null) {
            slot.addComponent(componentName, component);
            this.componentMappings.put(componentID, component);
            this.pack();
        } else {
            logger.warn((Object)("slot not found to place some component: " + slotName));
        }
    }

    public List<String> getAvailableSlotIDs() {
        return this.tableLayout.getAvailableSlots();
    }

    public JComponent getComponentAtSlot(String componentID) {
        return this.componentMappings.get(componentID);
    }

    public synchronized JComponent removeComponentFromSlot(String componentID) {
        JComponent component = this.componentMappings.get(componentID);
        if (component != null && component.getParent() instanceof JTabbedPane) {
            JTabbedPane theTabbed = (JTabbedPane)component.getParent();
            theTabbed.remove(component);
        }
        this.pack();
        return component;
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public final JToolBar getToolbar() {
        return this.toolbar;
    }

    class RenderingMessageComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public RenderingMessageComponent(String message) {
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel(message);
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
        }
    }
}

