/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.operation.OperationDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MonitorizeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int REFRESH_MILLIS = 10;
    private Object bean;
    private Object operationID;
    private OperationDefinition<?> definition;
    private boolean finish = false;
    private PropertyDescriptor[] descriptors;
    Timer t = null;
    private HashMap<PropertyDescriptor, RenderComponent> mapping = new HashMap();

    public MonitorizeDialog(JFrame parent) {
        this(parent, (Object)null, (Object)null, null);
    }

    public MonitorizeDialog(JFrame parent, Object bean, Object operationID, OperationDefinition<?> definition) {
        super(parent);
        this.bean = bean;
        this.operationID = operationID;
        this.definition = definition;
        this.initialize();
        this.setTitle("Progress...");
        this.setSize(new Dimension(300, 200));
        this.setDefaultCloseOperation(0);
        this.centerOnOwner();
        this.pack();
        this.setResizable(false);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JLabel working = new JLabel("Working");
        working.setOpaque(true);
        working.setBackground(Color.WHITE);
        working.setAlignmentY(0.5f);
        working.setPreferredSize(new Dimension(200, 50));
        working.setIcon(new ImageIcon(this.getClass().getResource("/images/longtask.gif")));
        this.add((Component)working, "North");
        if (this.bean != null) {
            this.putBeanInfo(this.bean);
        }
        if (this.definition.getCancelMethod() != null) {
            final JButton stopButton = new JButton("STOP");
            stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getInstance().cancelOperation(MonitorizeDialog.this.operationID);
                }
            });
            this.add((Component)new JPanel(){
                {
                    this.add(stopButton);
                }
            }, "South");
        }
    }

    private void putBeanInfo(Object bean) {
        try {
            JPanel beanInfoPanel = new JPanel();
            beanInfoPanel.setLayout(new GridLayout(2, 2));
            GridBagLayout newLayout = new GridBagLayout();
            beanInfoPanel.setLayout(newLayout);
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            this.descriptors = info.getPropertyDescriptors();
            int i = 0;
            for (PropertyDescriptor descriptor : this.descriptors) {
                GridBagConstraints c = new GridBagConstraints();
                if (descriptor.getReadMethod() == null || descriptor.getName().equals("class")) continue;
                JLabel label = new JLabel(descriptor.getName());
                c.fill = 2;
                c.gridx = 0;
                c.gridy = ++i;
                c.weightx = 0.0;
                c.anchor = 17;
                c.insets = new Insets(5, 5, 5, 5);
                newLayout.setConstraints(label, c);
                beanInfoPanel.add(label);
                JComponent component = null;
                component = descriptor.getPropertyType().equals(Float.TYPE) || descriptor.getPropertyType().equals(Float.class) ? new JProgressBarRenderer() : new JLabelRenderer();
                this.mapping.put(descriptor, (RenderComponent)((Object)component));
                c.gridx = 1;
                c.weightx = 1.0;
                newLayout.setConstraints(component, c);
                beanInfoPanel.add(component);
            }
            this.add((Component)beanInfoPanel, "Center");
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        Thread dummy = new Thread(){

            @Override
            public void run() {
                while (!MonitorizeDialog.this.finish) {
                    try {
                        3.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MonitorizeDialog.this.update();
                }
            }
        };
        dummy.setPriority(10);
        dummy.start();
    }

    private void update() {
        for (PropertyDescriptor descriptor : this.descriptors) {
            try {
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || descriptor.getName().equals("class") || this.mapping.get(descriptor) == null) continue;
                this.mapping.get(descriptor).updateValue(readMethod.invoke(this.bean, new Object[0]));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.pack();
    }

    private void centerOnOwner() {
        Rectangle rectOwner = this.getParent().getBounds();
        Rectangle rectDialog = this.getBounds();
        this.setLocation(rectOwner.x + rectOwner.width / 2 - rectDialog.width / 2, rectOwner.y + rectOwner.height / 2 - rectDialog.height / 2);
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag && this.t != null) {
            this.t.stop();
        }
        super.setVisible(flag);
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    private class JLabelRenderer
    extends JLabel
    implements RenderComponent {
        private static final long serialVersionUID = 1L;

        JLabelRenderer() {
            super("");
        }

        @Override
        public void updateValue(Object value) {
            if (value == null) {
                return;
            }
            this.setText(value.toString());
        }
    }

    private class JProgressBarRenderer
    extends JProgressBar
    implements RenderComponent {
        private static final long serialVersionUID = 1L;

        JProgressBarRenderer() {
            this.setMaximum(100);
            this.setValue(0);
        }

        @Override
        public void updateValue(Object value) {
            if (value instanceof Float) {
                if (((Float)value).floatValue() < 0.0f) {
                    this.setValue(0);
                    this.setIndeterminate(true);
                } else {
                    this.setIndeterminate(false);
                    this.setValue((int)(((Float)value).floatValue() * 100.0f));
                }
            }
        }
    }

    static interface RenderComponent {
        public void updateValue(Object var1);
    }
}

