/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.core.clipboard;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.datatypes.annotation.Datatype;
import es.uvigo.ei.aibench.core.datatypes.annotation.ListElements;
import es.uvigo.ei.aibench.core.datatypes.annotation.Structure;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Clipboard {
    static Logger logger = Logger.getLogger((String)Clipboard.class.getName());
    private HashMap<Class<?>, List<ClipboardItem>> items = new HashMap();
    private List<ClipboardListener> listeners = Collections.synchronizedList(new ArrayList());
    private int id = 0;
    private HashMap<ClipboardItem, List<ClipboardItem>> complexSubItems = new HashMap();
    private HashMap<ClipboardItem, List<ClipboardItem>> listSubItems = new HashMap();
    private HashMap<ClipboardItem, List<ClipboardItem>> arraySubItems = new HashMap();
    private HashMap<ClipboardItem, ClipboardItem> parents = new HashMap();
    private List<ClipboardItem> rootClipboardItems = new Vector<ClipboardItem>();
    private HashMap<ClipboardItem, Method> subItemsGetters = new HashMap();
    private HashMap<Integer, Integer> itemsOrdered = new HashMap();
    private Vector<ClipboardItem> itemsPutting = new Vector();
    private HashMap<Class<?>, List<ElemAndNumber>> uniqueItems = new HashMap();

    public List<ClipboardItem> getComplexSubItems(ClipboardItem item) {
        return this.complexSubItems.get(item);
    }

    public List<ClipboardItem> getArraySubItems(ClipboardItem item) {
        return this.arraySubItems.get(item);
    }

    public List<ClipboardItem> getListSubItems(ClipboardItem item) {
        return this.listSubItems.get(item);
    }

    public List<ClipboardItem> getRootItems() {
        return this.rootClipboardItems;
    }

    public ClipboardItem getParent(ClipboardItem item) {
        return this.parents.get(item);
    }

    public int getOrder(int id) {
        Integer order = this.itemsOrdered.get(id);
        return order != null ? order : -1;
    }

    public void setOrder(int id, int order) {
        this.itemsOrdered.put(new Integer(id), new Integer(order));
    }

    public void removeOrder(int id) {
        this.itemsOrdered.remove(new Integer(id));
    }

    public ClipboardItem getClipboardItem(Object o) {
        for (ClipboardItem item : this.getItemsByClass(o.getClass())) {
            if (item.getUserData() != o) continue;
            return item;
        }
        return null;
    }

    public List<ClipboardItem> getAllItems() {
        Vector<ClipboardItem> all = new Vector<ClipboardItem>();
        for (Class<?> key : this.items.keySet()) {
            all.addAll((Collection<ClipboardItem>)this.items.get(key));
        }
        return all;
    }

    public synchronized List<ClipboardItem> getItemsByClass(Class<?> type) {
        ArrayList<ClipboardItem> toret = new ArrayList<ClipboardItem>();
        for (Class<?> clazz : this.items.keySet()) {
            if (!type.isAssignableFrom(clazz)) continue;
            toret.addAll((Collection<ClipboardItem>)this.items.get(clazz));
        }
        return toret;
    }

    public void addClipboardListener(ClipboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeClipboardListener(ClipboardListener listener) {
        this.listeners.remove(listener);
    }

    private void prepareFireClipboardElementAdded(ClipboardItem item) {
        this.itemsPutting.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireClipboardElementAdded() {
        ArrayList<ClipboardListener> listeners;
        List<ClipboardListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<ClipboardListener>(this.listeners);
        }
        for (ClipboardItem item : this.itemsPutting) {
            for (ClipboardListener listener : listeners) {
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)("firing clipboard element added to listener of class: " + listener.getClass()));
                }
                listener.elementAdded(item);
                if (!logger.getEffectiveLevel().equals((Object)Level.DEBUG)) continue;
                logger.debug((Object)("listener of class: " + listener.getClass() + " finished"));
            }
        }
        this.itemsPutting.clear();
    }

    private ClipboardItem putItem_(Object data, String name) {
        ClipboardItemImpl toret = null;
        if (data == null) {
            List<ClipboardItem> classItems = this.items.get(Object.class);
            if (classItems == null) {
                classItems = new ArrayList<ClipboardItem>();
                this.items.put(Object.class, classItems);
            }
            toret = new ClipboardItemImpl(this.id++, data, name, Object.class);
            classItems.add(toret);
            this.prepareFireClipboardElementAdded(toret);
        } else {
            List<ClipboardItem> classItems;
            if (data != null && logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)("Putting a new object: Type: " + data.getClass() + " data: " + data + " name: " + name));
            }
            if ((classItems = this.items.get(data.getClass())) == null) {
                classItems = new ArrayList<ClipboardItem>();
                this.items.put(data.getClass(), classItems);
            }
            toret = new ClipboardItemImpl(this.id++, data, name, data.getClass());
            classItems.add(toret);
            this.prepareFireClipboardElementAdded(toret);
        }
        return toret;
    }

    public ClipboardItem findByID(int id) {
        for (List<ClipboardItem> list : this.items.values()) {
            for (ClipboardItem item : list) {
                if (item.getID() != id) continue;
                return item;
            }
        }
        return null;
    }

    public synchronized List<ClipboardItem> putItem(Object data, String name) {
        this.itemsPutting = new Vector();
        if (data == null) {
            return new ArrayList<ClipboardItem>();
        }
        ArrayList<ClipboardItem> list = new ArrayList<ClipboardItem>();
        ClipboardItem item = this.putElemInClipboard(data, list, name);
        this.rootClipboardItems.add(item);
        this.fireClipboardElementAdded();
        return list;
    }

    private ClipboardItem putElemInClipboard(Object elem, List<ClipboardItem> clipboardItems, String name) {
        ClipboardItem toret = null;
        if (elem != null) {
            Datatype aibenchType = elem.getClass().getAnnotation(Datatype.class);
            if (aibenchType != null && aibenchType.structure() != Structure.SIMPLE) {
                toret = aibenchType.structure() == Structure.COMPLEX ? this.putComplexInClipboard(elem, clipboardItems, name) : this.putListInClipboard(elem, clipboardItems, name);
            } else if (!elem.getClass().isArray()) {
                toret = this.putSimpleInClipboard(elem, clipboardItems, name);
            }
            if (elem.getClass().isArray()) {
                ArrayList<ClipboardItem> subItems = new ArrayList<ClipboardItem>();
                for (int i = 0; i < Array.getLength(elem); ++i) {
                    Object elem_i = Array.get(elem, i);
                    subItems.add(this.putElemInClipboard(elem_i, clipboardItems, null));
                }
                toret = this.putSimpleInClipboard(elem, clipboardItems, name);
                this.arraySubItems.put(toret, subItems);
            }
        } else {
            toret = this.putSimpleInClipboard(elem, clipboardItems, name);
        }
        return toret;
    }

    private ClipboardItem putSimpleInClipboard(Object elem, List<ClipboardItem> clipboardItems, String name) {
        ClipboardItem item;
        Datatype datatypeAnnot;
        String finalName = name;
        if (elem == null) {
            finalName = name + ":  null";
        } else {
            String surname = null;
            Datatype datatypeAnnot2 = elem.getClass().getAnnotation(Datatype.class);
            if (datatypeAnnot2 != null && !datatypeAnnot2.namingMethod().equals("")) {
                try {
                    Method m = elem.getClass().getMethod(datatypeAnnot2.namingMethod(), new Class[0]);
                    Object nameResult = m.invoke(elem, (Object[])null);
                    if (nameResult != null) {
                        surname = nameResult.toString();
                    } else {
                        nameResult = "null";
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    logger.error((Object)("Couldn't find the naming method in the Complex item " + elem.getClass() + ":  " + datatypeAnnot2.namingMethod()));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (surname == null || surname == "") {
                int number = -1;
                if (this.uniqueItems.get(elem.getClass()) == null) {
                    this.uniqueItems.put(elem.getClass(), new ArrayList());
                }
                for (ElemAndNumber item2 : this.uniqueItems.get(elem.getClass())) {
                    if (item2.elem != elem) continue;
                    number = item2.number;
                    break;
                }
                if (number == -1) {
                    if (this.uniqueItems.get(elem.getClass()).size() > 0) {
                        ElemAndNumber last = this.uniqueItems.get(elem.getClass()).get(this.uniqueItems.get(elem.getClass()).size() - 1);
                        number = last.number + 1;
                    } else {
                        number = 0;
                    }
                    ElemAndNumber en = new ElemAndNumber();
                    en.number = number;
                    en.elem = elem;
                    this.uniqueItems.get(elem.getClass()).add(en);
                }
                surname = elem.getClass().getSimpleName() + " (instance " + number + ")";
                finalName = (name == null ? "" : name + ": ") + surname;
            } else {
                finalName = surname;
            }
        }
        if (elem != null && (datatypeAnnot = elem.getClass().getAnnotation(Datatype.class)) != null && !datatypeAnnot.setNameMethod().equals("")) {
            try {
                Method m = elem.getClass().getMethod(datatypeAnnot.setNameMethod(), String.class);
                m.invoke(elem, finalName);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)("Couldn't find the set name method in the Complex item " + elem.getClass() + ":  " + datatypeAnnot.setNameMethod()));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if ((item = this.putItem_(elem, finalName)) != null) {
            clipboardItems.add(item);
        }
        return item;
    }

    private ClipboardItem putComplexInClipboard(Object elem, List<ClipboardItem> clipboardItems, String name) {
        LinkedList<ClipboardItem> subItems = new LinkedList<ClipboardItem>();
        HashMap<Integer, Method> order = new HashMap<Integer, Method>();
        for (Method m : elem.getClass().getMethods()) {
            es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard clip = m.getAnnotation(es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard.class);
            if (clip == null) continue;
            try {
                if (clip.order() != -1) {
                    int ordem;
                    int n = ordem = order.containsKey(clip.order()) ? (ordem = -1) : clip.order();
                    if (ordem == -1) {
                        throw new IllegalArgumentException("Please verify the order of the subitems of the complex type <" + elem.getClass().getName() + ">.\nEqually ordered elements were found.\n");
                    }
                    order.put(new Integer(clip.order()), m);
                    continue;
                }
                ClipboardItem item = this.putElemInClipboard(m.invoke(elem, (Object[])null), clipboardItems, clip.name());
                subItems.add(item);
                this.subItemsGetters.put(item, m);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        int[] sortKeys = new int[order.keySet().size()];
        int i = 0;
        for (Integer key : order.keySet()) {
            sortKeys[i] = key;
            ++i;
        }
        Arrays.sort(sortKeys);
        for (Object k : (Object)sortKeys) {
            Method m = (Method)order.get(new Integer((int)k));
            es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard clip = m.getAnnotation(es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard.class);
            try {
                ClipboardItem item = this.putElemInClipboard(m.invoke(elem, (Object[])null), clipboardItems, clip.name());
                this.subItemsGetters.put(item, m);
                this.itemsOrdered.put(new Integer(item.getID()), new Integer((int)k));
                subItems.add(item);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ClipboardItem toret = this.putSimpleInClipboard(elem, clipboardItems, name);
        this.complexSubItems.put(toret, subItems);
        for (ClipboardItem item : subItems) {
            this.parents.put(item, toret);
        }
        return toret;
    }

    private ClipboardItem putListInClipboard(Object elem, List<ClipboardItem> clipboardItems, String name) {
        ArrayList<ClipboardItem> subItems = new ArrayList<ClipboardItem>();
        for (Method m : elem.getClass().getMethods()) {
            ListElements annot = m.getAnnotation(ListElements.class);
            if (annot == null) continue;
            try {
                Collection subElems = (Collection)m.invoke(elem, (Object[])null);
                if (subElems == null) continue;
                for (Object o : subElems) {
                    subItems.add(this.putElemInClipboard(o, clipboardItems, null));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ClipboardItem toret = this.putSimpleInClipboard(elem, clipboardItems, name);
        this.listSubItems.put(toret, subItems);
        for (ClipboardItem item : subItems) {
            this.parents.put(item, toret);
        }
        return toret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeClipboardItem(ClipboardItem item) {
        ArrayList<ClipboardListener> listeners;
        ClipboardItem c;
        Object subItems;
        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            logger.debug((Object)("attempting to remove item: " + item));
        }
        if (this.complexSubItems.containsKey(item)) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"remove: is a complex item, removing subitems");
            }
            subItems = this.complexSubItems.get(item);
            Iterator<ClipboardItem> iterator = subItems.iterator();
            while (iterator.hasNext()) {
                c = iterator.next();
                if (c.wasRemoved()) continue;
                this.removeClipboardItem(c);
            }
            this.complexSubItems.remove(item);
        }
        if (this.listSubItems.containsKey(item)) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"remove: is list-complex item, removing subitems");
            }
            subItems = this.listSubItems.get(item);
            Iterator<ClipboardItem> iterator = subItems.iterator();
            while (iterator.hasNext()) {
                c = iterator.next();
                if (c.wasRemoved()) continue;
                this.removeClipboardItem(c);
            }
            this.listSubItems.remove(item);
        }
        if (this.arraySubItems.containsKey(item)) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"remove: is an array item, removing subitems");
            }
            subItems = this.arraySubItems.get(item);
            Iterator<ClipboardItem> iterator = subItems.iterator();
            while (iterator.hasNext()) {
                c = iterator.next();
                if (c.wasRemoved()) continue;
                this.removeClipboardItem(c);
            }
            this.arraySubItems.remove(item);
        }
        for (Class clazz : this.items.keySet()) {
            if (!this.items.get(clazz).contains(item)) continue;
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"remove: found, removing");
            }
            this.items.get(clazz).remove(item);
        }
        if (this.rootClipboardItems.contains(item)) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"remove: is a root item");
            }
            this.rootClipboardItems.remove(item);
        }
        for (Class clazz : this.uniqueItems.keySet()) {
            List<ElemAndNumber> objs = this.uniqueItems.get(clazz);
            for (int i = objs.size() - 1; i >= 0; --i) {
                if (objs.get((int)i).elem != item.getUserData()) continue;
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)"removed from unique items");
                }
                objs.remove(i);
            }
        }
        List<ClipboardListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<ClipboardListener>(this.listeners);
        }
        for (ClipboardListener listener : listeners) {
            listener.elementRemoved(item);
        }
        ((ClipboardItemImpl)item).removed = true;
        ((ClipboardItemImpl)item).data = null;
    }

    private void checkSubItemsUpdated(ClipboardItem item) {
        int counter = 0;
        if (this.isComplex(item)) {
            for (ClipboardItem possibleOld : this.getComplexSubItems(item)) {
                Method m = this.subItemsGetters.get(possibleOld);
                es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard clip = m.getAnnotation(es.uvigo.ei.aibench.core.datatypes.annotation.Clipboard.class);
                if (clip == null) continue;
                try {
                    Object value = m.invoke(item.getUserData(), (Object[])null);
                    if (value != possibleOld.getUserData()) {
                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                            logger.debug((Object)"A child in a complex item has changed");
                        }
                        int relativeOrder = clip.order();
                        ClipboardItem newItem = this.putElemInClipboard(value, new ArrayList<ClipboardItem>(), clip.name());
                        if (relativeOrder != -1) {
                            int newID = newItem.getID();
                            this.setOrder(newID, relativeOrder);
                            this.removeOrder(possibleOld.getID());
                        }
                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                            logger.debug((Object)("UPDATED " + newItem.getName() + " to ID:" + newItem.getID() + " with order = " + relativeOrder));
                        }
                        this.getComplexSubItems(item).set(counter, newItem);
                        this.subItemsGetters.remove(possibleOld);
                        this.subItemsGetters.put(newItem, m);
                        this.itemsPutting = new Vector();
                        this.removeClipboardItem(possibleOld);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                ++counter;
            }
        }
        if (this.isList(item)) {
            for (Method m : item.getUserData().getClass().getMethods()) {
                ListElements annot = m.getAnnotation(ListElements.class);
                if (annot == null) continue;
                try {
                    List subElems = (List)m.invoke(item.getUserData(), (Object[])null);
                    if (subElems != null) {
                        for (Object o : subElems) {
                            ClipboardItem possibleOld;
                            if (this.getListSubItems(item).size() <= counter) {
                                ClipboardItem newitem = this.putElemInClipboard(o, new ArrayList<ClipboardItem>(), null);
                                this.getListSubItems(item).add(newitem);
                                this.parents.put(newitem, item);
                            }
                            if (o != (possibleOld = this.getListSubItems(item).get(counter)).getUserData()) {
                                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                    logger.debug((Object)"A child in a complex-list item has changed");
                                }
                                this.getListSubItems(item).set(counter, this.putElemInClipboard(o, new ArrayList<ClipboardItem>(), null));
                                this.removeClipboardItem(possibleOld);
                            }
                            ++counter;
                        }
                        if (counter >= this.getListSubItems(item).size()) break;
                        for (int i = this.getListSubItems(item).size() - 1; i >= counter; --i) {
                            ClipboardItem old = this.getListSubItems(item).get(i);
                            this.getListSubItems(item).remove(i);
                            this.removeClipboardItem(old);
                        }
                        break;
                    }
                    throw new RuntimeException("please dont make null a list");
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (this.isArray(item)) {
            int i = 0;
            for (i = 0; i < Array.getLength(item.getUserData()); ++i) {
                ClipboardItem possibleOld;
                Object elem_i = Array.get(item.getUserData(), i);
                if (this.getArraySubItems(item).size() <= i) {
                    ClipboardItem newitem = this.putElemInClipboard(elem_i, new ArrayList<ClipboardItem>(), null);
                    this.getArraySubItems(item).add(newitem);
                    this.parents.put(newitem, item);
                }
                if (elem_i == (possibleOld = this.getArraySubItems(item).get(i)).getUserData()) continue;
                this.getListSubItems(item).set(counter, this.putElemInClipboard(elem_i, new ArrayList<ClipboardItem>(), null));
                this.removeClipboardItem(possibleOld);
            }
            if (i < this.getArraySubItems(item).size()) {
                for (int j = this.getArraySubItems(item).size() - 1; j >= i; --j) {
                    ClipboardItem old = this.getArraySubItems(item).get(j);
                    this.getArraySubItems(item).remove(j);
                    this.removeClipboardItem(old);
                }
            }
        }
    }

    private boolean isComplex(ClipboardItem item) {
        if (item.getUserData() == null) {
            return false;
        }
        Datatype annot = item.getUserData().getClass().getAnnotation(Datatype.class);
        return annot != null && annot.structure() == Structure.COMPLEX;
    }

    private boolean isList(ClipboardItem item) {
        if (item.getUserData() == null) {
            return false;
        }
        Datatype annot = item.getUserData().getClass().getAnnotation(Datatype.class);
        return annot != null && annot.structure() == Structure.LIST;
    }

    private boolean isArray(ClipboardItem item) {
        if (item.getUserData() == null) {
            return false;
        }
        return item.getUserData().getClass().isArray();
    }

    class ElemAndNumber {
        public Object elem;
        public int number;

        ElemAndNumber() {
        }
    }

    private class ClipboardItemImpl
    extends Observable
    implements ClipboardItem {
        private int id;
        private Object data;
        private String name;
        private Class<?> clazz;
        private boolean removed = false;
        private ReentrantReadWriteLock lock;

        public ClipboardItemImpl(int id, final Object data, String name, Class<?> clazz) {
            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                logger.debug((Object)"creating a clipboard item");
            }
            this.id = id;
            this.data = data;
            this.name = name;
            this.clazz = clazz;
            this.lock = new ReentrantReadWriteLock(true);
            if (Core.CONFIG.getProperty("clipboard.listenobservables") != null && Core.CONFIG.getProperty("clipboard.listenobservables").equals("true") && data != null && data instanceof Observable) {
                if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                    logger.debug((Object)("Its observable " + data));
                }
                ((Observable)data).addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                            logger.debug((Object)("clipboard item: " + ClipboardItemImpl.this.name + " changed"));
                        }
                        if (ClipboardItemImpl.this.getUserData() != data) {
                            if (logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
                                logger.debug((Object)"Receiving an update event from a clipboard item whose observed object is different from the userdata object, removing the observer");
                            }
                            o.deleteObserver(this);
                            return;
                        }
                        Datatype datatypeAnnot = ClipboardItemImpl.this.getUserData().getClass().getAnnotation(Datatype.class);
                        if (datatypeAnnot != null && !datatypeAnnot.namingMethod().equals("")) {
                            try {
                                Method m = ClipboardItemImpl.this.getUserData().getClass().getMethod(datatypeAnnot.namingMethod(), new Class[0]);
                                Object nameResult = m.invoke(ClipboardItemImpl.this.getUserData(), (Object[])null);
                                if (nameResult != null) {
                                    ClipboardItemImpl.this.name = nameResult.toString();
                                } else {
                                    ClipboardItemImpl.this.name = "null";
                                }
                            }
                            catch (SecurityException e) {
                                e.printStackTrace();
                            }
                            catch (NoSuchMethodException e) {
                                logger.error((Object)("Couldn't find the naming method in the Complex item " + ClipboardItemImpl.this.getUserData().getClass() + ":  " + datatypeAnnot.namingMethod()));
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        Clipboard.this.checkSubItemsUpdated(ClipboardItemImpl.this);
                        ClipboardItemImpl.this.setChanged();
                        ClipboardItemImpl.this.notifyObservers();
                        Clipboard.this.fireClipboardElementAdded();
                    }
                });
            }
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public Object getUserData() {
            return this.data;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getRegisteredUserClass() {
            return this.clazz;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean wasRemoved() {
            return this.removed;
        }

        @Override
        public ReentrantReadWriteLock getLock() {
            return this.lock;
        }
    }
}

