/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.gui.plate;

import es.uvigo.ei.sing.hlfernandez.text.BindJXTextField;
import es.uvigo.ei.sing.s2p.core.entities.MaldiPlateInformation;
import es.uvigo.ei.sing.s2p.gui.UISettings;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTextField;

public class MaldiPlateInformationEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MaldiPlateInformation info;

    public MaldiPlateInformationEditor(MaldiPlateInformation info) {
        this.info = info;
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(0, 1));
        this.setBackground(UISettings.BG_COLOR);
        JPanel firstRow = new JPanel();
        firstRow.setOpaque(false);
        firstRow.setLayout(new BoxLayout(firstRow, 0));
        firstRow.add(new JLabel("User: "));
        firstRow.add((Component)this.getUserTextField());
        firstRow.add(Box.createHorizontalStrut(50));
        firstRow.add(new JLabel("Date: "));
        firstRow.add((Component)this.getDateTextField());
        firstRow.add(Box.createHorizontalStrut(50));
        firstRow.add(new JLabel("Type of MALDI target: "));
        firstRow.add(this.getMaldiTargetCombo());
        JPanel secondRow = new JPanel();
        secondRow.setOpaque(false);
        secondRow.setLayout(new BoxLayout(secondRow, 0));
        secondRow.add(new JLabel("Type of sample: "));
        secondRow.add((Component)this.getSampleTypeTextField());
        secondRow.add(Box.createHorizontalStrut(50));
        secondRow.add(new JLabel("Mascot experiment: "));
        secondRow.add((Component)this.getMascotField());
        this.add(firstRow);
        this.add(secondRow);
    }

    private Component getMaldiTargetCombo() {
        JComboBox<MaldiPlateInformation.MaldiTarget> maldiTarget = new JComboBox<MaldiPlateInformation.MaldiTarget>(MaldiPlateInformation.MaldiTarget.values());
        if (this.info.getMaldiTarget().isPresent()) {
            maldiTarget.setSelectedItem(this.info.getMaldiTarget().get());
        }
        maldiTarget.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.info.setMaldiTarget((MaldiPlateInformation.MaldiTarget)maldiTarget.getSelectedItem());
            }
        });
        return maldiTarget;
    }

    public JXTextField getUserTextField() {
        return new BindJXTextField("User", this.info.getUser(), arg_0 -> ((MaldiPlateInformation)this.info).setUser(arg_0));
    }

    public JXTextField getDateTextField() {
        return new BindJXTextField("Date", this.info.getDate(), arg_0 -> ((MaldiPlateInformation)this.info).setDate(arg_0));
    }

    public JXTextField getSampleTypeTextField() {
        return new BindJXTextField("Type of sample", this.info.getSampleType(), arg_0 -> ((MaldiPlateInformation)this.info).setSampleType(arg_0));
    }

    public JXTextField getMascotField() {
        return new BindJXTextField("Mascot experiment", this.info.getMascotExperiment(), arg_0 -> ((MaldiPlateInformation)this.info).setMascotExperiment(arg_0));
    }
}

