/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.s2p.core.operations;

import es.uvigo.ei.sing.s2p.core.entities.MaldiPlate;
import es.uvigo.ei.sing.s2p.core.util.Checks;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MaldiPlateOperations {
    private static final String REQ_REPLICATES = "Number of replicates must be greater than 0";

    public static List<MaldiPlate> generateMaldiPlates(List<String> spotsList, int replicates, int rows, int cols, MaldiPlate.Positions rowsPositions, MaldiPlate.Positions columnsPositions, boolean calibrants, boolean random) {
        replicates = Checks.requireStrictPositive(replicates, REQ_REPLICATES);
        List<String> spots = MaldiPlateOperations.getSpotsList(spotsList, replicates);
        int requiredPlates = MaldiPlateOperations.computeRequiredPlates(spots.size(), rows, cols, calibrants);
        if (random) {
            Collections.shuffle(spots);
        }
        LinkedList<MaldiPlate> toret = new LinkedList<MaldiPlate>();
        for (int i = 0; i < requiredPlates; ++i) {
            MaldiPlate current = new MaldiPlate(rows, cols, rowsPositions, columnsPositions);
            if (calibrants) {
                current.addCalibrants();
            }
            current.setData(MaldiPlateOperations.fillData(current.getData(), spots));
            toret.add(current);
        }
        return toret;
    }

    private static List<String> getSpotsList(List<String> spotsList, int replicates) {
        LinkedList<String> toret = new LinkedList<String>();
        for (String s : spotsList) {
            for (int i = 0; i < replicates; ++i) {
                toret.add(s);
            }
        }
        return toret;
    }

    private static String[][] fillData(String[][] data, List<String> spots) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                String value = data[i][j];
                if (value != null && !value.equals("") || spots.size() <= 0) continue;
                data[i][j] = spots.remove(0);
            }
        }
        return data;
    }

    private static int computeRequiredPlates(int size, int rows, int cols, boolean calibrants) {
        MaldiPlate plate = new MaldiPlate(rows, cols, MaldiPlate.Positions.LETTERS, MaldiPlate.Positions.NUMBERS);
        if (calibrants) {
            plate.addCalibrants();
        }
        int plateSize = MaldiPlateOperations.countAvailablePositions(plate.getData());
        return (int)Math.ceil((double)size / (double)plateSize);
    }

    private static int countAvailablePositions(String[][] data) {
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                String value = data[i][j];
                if (value != null && !value.equals("")) continue;
                ++count;
            }
        }
        return count;
    }
}

