/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench;

import java.io.File;

public class Paths {
    private static Paths instance;
    private static final String DEFAULT_PATH = "conf";
    private static final String DEFAULT_AIBENCH_CONFIGURATION_PATH;
    private static final String DEFAULT_LOG4J_CONFIGURATION_PATH;
    private static final String DEFAULT_PLUGIN_MANAGER_CONFIGURATION_PATH;
    private static final String DEFAULT_PLUGINS_CONFIGURATION_PATH;
    private String aibenchConfigurationPath;
    private String log4jConfigurationPath;
    private String pluginManagerConfigurationPath;
    private String pluginsConfigurationPath;

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new Paths();
        }
    }

    public static Paths getInstance() {
        if (instance == null) {
            Paths.createInstance();
        }
        return instance;
    }

    private Paths() {
    }

    public String getAibenchConfigurationPath() {
        if (this.aibenchConfigurationPath == null) {
            this.createAibenchConfPath();
        }
        return this.aibenchConfigurationPath;
    }

    private synchronized void createAibenchConfPath() {
        if (this.aibenchConfigurationPath == null) {
            this.aibenchConfigurationPath = System.getProperty("aibench.paths.aibench.conf", DEFAULT_AIBENCH_CONFIGURATION_PATH);
        }
    }

    public String getLog4jConfigurationPath() {
        if (this.log4jConfigurationPath == null) {
            this.createLog4jConfigurationPath();
        }
        return this.log4jConfigurationPath;
    }

    private synchronized void createLog4jConfigurationPath() {
        if (this.log4jConfigurationPath == null) {
            this.log4jConfigurationPath = System.getProperty("aibench.paths.log4j.conf", DEFAULT_LOG4J_CONFIGURATION_PATH);
        }
    }

    public String getPluginManagerConfigurationPath() {
        if (this.pluginManagerConfigurationPath == null) {
            this.createPluginManagerConfigurationPath();
        }
        return this.pluginManagerConfigurationPath;
    }

    private synchronized void createPluginManagerConfigurationPath() {
        if (this.pluginManagerConfigurationPath == null) {
            this.pluginManagerConfigurationPath = System.getProperty("aibench.paths.pluginmanager.conf", DEFAULT_PLUGIN_MANAGER_CONFIGURATION_PATH);
        }
    }

    public String getPluginsConfigurationPath() {
        if (this.pluginsConfigurationPath == null) {
            this.createPluginsConfigurationPath();
        }
        return this.pluginsConfigurationPath;
    }

    private synchronized void createPluginsConfigurationPath() {
        if (this.pluginsConfigurationPath == null) {
            this.pluginsConfigurationPath = System.getProperty("aibench.paths.plugins.conf", DEFAULT_PLUGINS_CONFIGURATION_PATH);
        }
    }

    static {
        DEFAULT_AIBENCH_CONFIGURATION_PATH = DEFAULT_PATH + File.separator + "aibench.conf";
        DEFAULT_LOG4J_CONFIGURATION_PATH = DEFAULT_PATH + File.separator + "log4jconfig";
        DEFAULT_PLUGIN_MANAGER_CONFIGURATION_PATH = DEFAULT_PATH + File.separator + "pluginmanager.conf";
        DEFAULT_PLUGINS_CONFIGURATION_PATH = DEFAULT_PATH + File.separator + "plugins.conf";
    }
}

