/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.utilities;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.clipboard.Clipboard;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.workbench.utilities.JOptionPaneMessage;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ClearClipboardAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final String DESCRIPTION = "Removes all items in the clipboard";
    public static final ImageIcon ICON_16 = new ImageIcon(ClearClipboardAction.class.getResource("images/trash16.png"));
    public static final ImageIcon ICON_24 = new ImageIcon(ClearClipboardAction.class.getResource("images/trash24.png"));
    public static final ImageIcon ICON_32 = new ImageIcon(ClearClipboardAction.class.getResource("images/trash32.png"));
    private static final JOptionPaneMessage DONT_SHOW_AGAIN = new JOptionPaneMessage("All items in the clipboard will be deleted. Do you want to continue?");

    public ClearClipboardAction() {
        this(DESCRIPTION, ICON_32);
    }

    public ClearClipboardAction(String shortDescription) {
        this(shortDescription, ICON_32);
    }

    public ClearClipboardAction(ImageIcon icon) {
        this(DESCRIPTION, icon);
    }

    public ClearClipboardAction(String shortDescription, ImageIcon icon) {
        super(shortDescription, icon);
        this.putValue("ShortDescription", shortDescription);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.askRemoveClipboardItems()) {
            this.removeClipboardItems();
        }
    }

    private boolean askRemoveClipboardItems() {
        return !DONT_SHOW_AGAIN.shouldBeShown() || JOptionPane.showConfirmDialog(null, DONT_SHOW_AGAIN.getMessage(), "Remove all items", 0) == 0;
    }

    protected void removeClipboardItems() {
        for (ClipboardItem item : this.getClipboardItemsToRemove()) {
            Clipboard clipboard = Core.getInstance().getClipboard();
            if (item.getUserData() == null) continue;
            clipboard.removeClipboardItem(item);
        }
    }

    protected List<ClipboardItem> getClipboardItemsToRemove() {
        return Core.getInstance().getClipboard().getAllItems();
    }
}

