/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.platonos.pluginengine.Dependency;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.ExtensionPoint;
import org.platonos.pluginengine.Plugin;
import org.platonos.pluginengine.PluginEngine;
import org.platonos.pluginengine.PluginEngineException;
import org.platonos.pluginengine.PluginXmlNode;
import org.platonos.pluginengine.logging.LoggerLevel;
import org.platonos.pluginengine.version.PluginVersion;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class PluginXmlParser {
    private static final String PLUGIN = "plugin";
    private static final String EXTENSION = "extension";
    private static final String EXTENSION_POINT = "extensionpoint";
    private static final String DEPENDENCY = "dependency";
    private static final String UID = "uid";
    private static final String VERSION = "version";
    private static final String MIN_VERSION = "minversion";
    private static final String MAX_VERSION = "maxversion";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String LIFECYCLE_CLASS = "lifecycleclass";
    private static final String INTERFACE = "interface";
    private static final String START = "start";
    private static final String START_ORDER = "startOrder";
    private static final String DEPENDENT_PLUGIN_LOOKUP = "dependentPluginLookup";
    private static final String OPTIONAL = "optional";
    private static final String TRUE = "true";
    private static final String METADATA = "metadata";
    private static final String SCHEMA = "schema";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final URL pluginSchemaURL = PluginXmlParser.class.getResource("plugin.xsd");
    private static boolean isValidationSupported = true;
    static boolean isValidationEnabled = true;
    private static SAXParserFactory parserFactory;

    static synchronized boolean isValidationSupported() {
        if (parserFactory == null) {
            PluginXmlParser.getParserFactory();
        }
        return isValidationSupported;
    }

    private static synchronized SAXParserFactory getParserFactory() {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(true);
            try {
                parserFactory.newSAXParser().setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (SAXNotRecognizedException ex) {
                parserFactory.setValidating(false);
                isValidationSupported = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parserFactory;
    }

    private static synchronized SAXParser getParser(URL schemaURL) throws PluginEngineException {
        SAXParser parser;
        if (schemaURL == null) {
            throw new NullPointerException("Invalid schemaURL argument.");
        }
        try {
            parser = PluginXmlParser.getParserFactory().newSAXParser();
        }
        catch (Exception ex) {
            throw new PluginEngineException("Failed to create SAX parser.", ex);
        }
        if (isValidationSupported && isValidationEnabled) {
            try {
                parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                parser.setProperty(JAXP_SCHEMA_SOURCE, schemaURL.openStream());
            }
            catch (SAXException ex) {
                throw new PluginEngineException("XML schema error: " + schemaURL, ex);
            }
            catch (IOException ex) {
                throw new PluginEngineException("Error reading schema file: " + schemaURL, ex);
            }
        }
        return parser;
    }

    static Plugin parse(PluginEngine pluginEngine, URL pluginXmlURL) throws PluginEngineException {
        URL pluginURL;
        boolean isArchive = pluginXmlURL.getProtocol().equals("jar");
        try {
            String pluginURLStr = pluginXmlURL.toString();
            pluginURL = isArchive ? new URL(pluginURLStr.substring(4, pluginURLStr.length() - 12)) : new URL(pluginURLStr.substring(0, pluginURLStr.length() - 10));
        }
        catch (MalformedURLException ex) {
            throw new PluginEngineException("Error parsing plugin.xml URL.", ex);
        }
        Plugin plugin = new Plugin(pluginEngine, pluginURL);
        try {
            PluginXmlParser.getParser(pluginSchemaURL).parse(pluginXmlURL.openStream(), (DefaultHandler)new PluginXmlHandler(plugin, pluginXmlURL));
        }
        catch (SAXParseException ex) {
            throw new PluginEngineException("Failed parsing plugin.xml on line " + ex.getLineNumber() + ": " + pluginXmlURL, ex);
        }
        catch (SAXException ex) {
            throw new PluginEngineException("Failed parsing plugin.xml: " + pluginXmlURL, ex);
        }
        catch (IOException ex) {
            throw new PluginEngineException("Failed parsing plugin.xml: " + pluginXmlURL, ex);
        }
        return plugin;
    }

    static void validate(PluginEngine pluginEngine, URL schemaURL, String xml) throws SAXParseException {
        if (!isValidationSupported || !isValidationEnabled) {
            return;
        }
        try {
            PluginXmlParser.getParser(schemaURL).parse(new InputSource(new StringReader(xml)), (DefaultHandler)new ValidatingHandler(pluginEngine, xml));
        }
        catch (SAXException ex) {
            pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Failed parsing: " + xml, ex);
        }
        catch (IOException ex) {
            pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Failed parsing: " + xml, ex);
        }
        catch (PluginEngineException ex) {
            pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Failed parsing: " + xml, ex);
        }
    }

    private PluginXmlParser() {
    }

    static class PluginXmlHandler
    extends ValidatingHandler {
        private final Plugin plugin;
        private final StringBuffer accumulator = new StringBuffer(500);
        private PluginXmlNode currentXmlNode = null;

        PluginXmlHandler(Plugin plugin, URL pluginXmlURL) {
            super(plugin.getPluginEngine(), pluginXmlURL.toString());
            this.plugin = plugin;
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            this.accumulator.append(buffer, start, length);
        }

        @Override
        public void startElement(String namespaceURL, String localName, String qname, Attributes attributes) {
            this.accumulator.setLength(0);
            if (this.currentXmlNode != null) {
                PluginXmlNode node = this.createNode(qname, attributes);
                this.currentXmlNode.addChild(node);
                this.currentXmlNode = node;
                return;
            }
            if (qname.equals(PluginXmlParser.PLUGIN)) {
                this.plugin.setStartWhenResolved(PluginXmlParser.TRUE.equals(attributes.getValue(PluginXmlParser.START)));
                this.plugin.setDependentPluginLookup(PluginXmlParser.TRUE.equals(attributes.getValue(PluginXmlParser.DEPENDENT_PLUGIN_LOOKUP)));
                try {
                    String startOrder = attributes.getValue(PluginXmlParser.START_ORDER);
                    if (startOrder != null) {
                        this.plugin.setStartOrder(Integer.parseInt(startOrder));
                    }
                }
                catch (NumberFormatException nfe) {
                    this.pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Start order format not valid.", nfe);
                }
            } else if (qname.equals(PluginXmlParser.EXTENSION)) {
                Extension extension = new Extension(this.plugin, attributes.getValue(PluginXmlParser.UID), attributes.getValue(PluginXmlParser.NAME), attributes.getValue(PluginXmlParser.CLASS));
                this.plugin.addExtension(extension);
                this.currentXmlNode = this.createNode(PluginXmlParser.EXTENSION, attributes);
                extension.setExtensionXmlNode(this.currentXmlNode);
            } else if (qname.equals(PluginXmlParser.METADATA)) {
                this.currentXmlNode = this.createNode(PluginXmlParser.METADATA, attributes);
                this.plugin.setMetadataXmlNode(this.currentXmlNode);
            } else if (qname.equals(PluginXmlParser.EXTENSION_POINT)) {
                if (this.plugin.getUID() == null) {
                    this.pluginEngine.getLogger().log(LoggerLevel.SEVERE, "The Plugin's UID must be set before an \"extensionpoint\" element is encountered. Plugin: " + this.plugin.getPluginURL(), null);
                    return;
                }
                ExtensionPoint extensionPoint = new ExtensionPoint(this.plugin, attributes.getValue(PluginXmlParser.NAME), attributes.getValue(PluginXmlParser.INTERFACE));
                if (attributes.getValue(PluginXmlParser.SCHEMA) != null) {
                    extensionPoint.setSchemaFilename(attributes.getValue(PluginXmlParser.SCHEMA));
                }
                this.plugin.addExtensionPoint(extensionPoint);
            } else if (qname.equals(PluginXmlParser.DEPENDENCY)) {
                Dependency dependency = new Dependency(this.plugin, attributes.getValue(PluginXmlParser.UID));
                try {
                    String dependencyVersion = attributes.getValue(PluginXmlParser.VERSION);
                    if (dependencyVersion == null) {
                        String dependencyMinVersion = attributes.getValue(PluginXmlParser.MIN_VERSION);
                        String dependencyMaxVersion = attributes.getValue(PluginXmlParser.MAX_VERSION);
                        if (dependencyMinVersion != null && dependencyMaxVersion != null) {
                            dependency.requiredVersion = PluginVersion.createDependencyVersion(String.format("%s,%s", dependencyMinVersion, dependencyMaxVersion));
                        } else if (dependencyMaxVersion != null) {
                            dependency.requiredVersion = PluginVersion.createDependencyVersion(dependencyMaxVersion);
                        } else if (dependencyMinVersion != null) {
                            dependency.requiredVersion = PluginVersion.createDependencyVersion(dependencyMinVersion);
                        }
                    } else {
                        dependency.requiredVersion = PluginVersion.createDependencyVersion(dependencyVersion);
                    }
                    dependency.setOptional(PluginXmlParser.TRUE.equals(attributes.getValue(PluginXmlParser.OPTIONAL)));
                }
                catch (PluginEngineException ex) {
                    this.pluginEngine.getLogger().log(LoggerLevel.WARNING, "Unable to parse version for Dependency \"" + dependency.resolveToPluginUID + "\" in Plugin: " + this.plugin, ex);
                }
                this.plugin.addDependency(dependency);
            }
        }

        @Override
        public void endElement(String namespaceURL, String localName, String qname) {
            String value = this.accumulator.toString().trim();
            if (this.currentXmlNode != null) {
                this.currentXmlNode.setText(value);
                if ((qname.equals(PluginXmlParser.EXTENSION) || qname.equals(PluginXmlParser.METADATA)) && this.currentXmlNode.getParent() == null) {
                    this.currentXmlNode = null;
                    return;
                }
                this.currentXmlNode = this.currentXmlNode.getParent();
                return;
            }
            if (qname.equals(PluginXmlParser.NAME)) {
                this.plugin.setName(value);
            } else if (qname.equals(PluginXmlParser.VERSION)) {
                try {
                    this.plugin.setVersion(PluginVersion.createInstanceVersion(value));
                }
                catch (PluginEngineException ex) {
                    this.pluginEngine.getLogger().log(LoggerLevel.SEVERE, "Error setting PluginVersion for Plugin: " + this.plugin, ex);
                }
            } else if (qname.equals(PluginXmlParser.UID)) {
                this.plugin.setUID(value);
            } else if (qname.equals(PluginXmlParser.LIFECYCLE_CLASS)) {
                this.plugin.setLifecycleClassName(value);
            }
        }

        private PluginXmlNode createNode(String name, Attributes attributes) {
            PluginXmlNode node = new PluginXmlNode();
            node.setName(name);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                node.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            return node;
        }
    }

    static class ValidatingHandler
    extends DefaultHandler {
        protected final PluginEngine pluginEngine;
        private final String parsingMessage;

        ValidatingHandler(PluginEngine pluginEngine, String parsingMessage) {
            this.pluginEngine = pluginEngine;
            this.parsingMessage = parsingMessage;
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.pluginEngine.getLogger().log(LoggerLevel.WARNING, "Warning during parsing line " + ex.getLineNumber() + ": " + this.parsingMessage, ex);
        }
    }
}

