/*
 * Decompiled with CFR 0.152.
 */
package org.platonos.pluginengine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.platonos.pluginengine.Extension;
import org.platonos.pluginengine.PluginClassLoader;
import org.platonos.pluginengine.logging.LoggerLevel;

final class ExtensionClassLoader
extends ClassLoader {
    PluginClassLoader pluginClassLoader;
    Extension extension;

    ExtensionClassLoader(Extension extension) {
        this.extension = extension;
        this.pluginClassLoader = extension.getPlugin().pluginClassloader;
    }

    @Override
    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.isExtensionClass(className)) {
            Class<?> clazz = this.loadExtensionClass(className);
            if (clazz == null) {
                throw new ClassNotFoundException(className);
            }
            return clazz;
        }
        return this.pluginClassLoader.loadClass(className);
    }

    boolean isExtensionClass(String className) {
        int dollarIndex = className.indexOf(36);
        if (dollarIndex == -1) {
            return className.equals(this.extension.getExtensionClassName());
        }
        return className.substring(0, dollarIndex).equals(this.extension.getExtensionClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Class<?> loadExtensionClass(String className) {
        PluginClassLoader pluginClassLoader = this.pluginClassLoader;
        synchronized (pluginClassLoader) {
            byte[] data;
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                if (!this.extension.getPlugin().start()) {
                    this.extension.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Unable to start Plugin \"" + this.extension.getPlugin() + "\". Extension class cannot be acquired: " + className, null);
                    return null;
                }
                return clazz;
            }
            URL classResource = this.pluginClassLoader.getResource(className.replace('.', '/') + ".class");
            if (classResource == null) {
                this.extension.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Extension class not found in Plugin \"" + this.extension.getPlugin() + "\": " + className, null);
                return null;
            }
            try {
                int read;
                InputStream input = classResource.openStream();
                data = new byte[input.available()];
                int off = 0;
                int len = data.length;
                while ((read = input.read(data, off, len)) > 0) {
                    off += read;
                    len -= read;
                }
            }
            catch (IOException ex) {
                this.extension.getPluginEngine().getLogger().log(LoggerLevel.SEVERE, "Error loading extension class: " + className, ex);
                return null;
            }
            return this.defineClass(className, data, 0, data.length);
        }
    }

    @Override
    protected String findLibrary(String libName) {
        return this.pluginClassLoader.findLibrary(libName);
    }

    @Override
    public URL getResource(String name) {
        return this.pluginClassLoader.getResource(name);
    }
}

