/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.vda.gui;

import es.uvigo.ei.sing.vda.core.RColors;
import es.uvigo.ei.sing.vda.core.entities.NamedRSet;
import es.uvigo.ei.sing.vda.gui.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SetInput
extends JPanel {
    private static final long serialVersionUID = 1L;
    private NamedRSet<String> set;
    private JTextField nameTF;
    private JTextArea elementsTA;
    private Runnable onComponentNameChanged;
    private JComboBox<String> colorCombo;

    public SetInput(NamedRSet<String> set) {
        this.set = set;
        this.initComponent();
    }

    public void onComponentNameChanged(Runnable r) {
        this.onComponentNameChanged = r;
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.setBackground(UISettings.BG_COLOR);
        this.elementsTA = new JTextArea();
        this.set.forEach(s -> this.elementsTA.append(String.valueOf(s) + "\n"));
        this.add(this.getNorthPanel(), "North");
        this.add((Component)this.elementsTA, "Center");
    }

    private Component getNorthPanel() {
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setOpaque(false);
        this.nameTF = new JTextField(this.set.getName());
        this.nameTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(SetInput.this.onComponentNameChanged);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(SetInput.this.onComponentNameChanged);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.colorCombo = new JComboBox<String>(RColors.R_COLORS);
        this.colorCombo.setSelectedItem(this.set.getRSetColor());
        JPanel colorPanel = new JPanel(new BorderLayout());
        colorPanel.setOpaque(false);
        colorPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        colorPanel.add((Component)new JLabel("Color:"), "West");
        colorPanel.add(this.colorCombo, "Center");
        northPanel.add((Component)new JLabel("Set name:"), "West");
        northPanel.add((Component)this.nameTF, "Center");
        northPanel.add((Component)colorPanel, "East");
        northPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        return northPanel;
    }

    public NamedRSet<String> getNamedRSet() {
        NamedRSet<String> toret = new NamedRSet<String>(this.nameTF.getText(), (String)this.colorCombo.getSelectedItem());
        toret.addAll(this.getSetElements());
        return toret;
    }

    private Set<String> getSetElements() {
        return new HashSet<String>(Arrays.asList(this.elementsTA.getText().split("\n")));
    }

    public String getSetName() {
        return this.nameTF.getText();
    }
}

